/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.menuitemkit;

import java.io.IOException;
import org.eclipse.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.swt.internal.widgets.menuitemkit.BarMenuItemLCA;
import org.eclipse.swt.internal.widgets.menuitemkit.CheckMenuItemLCA;
import org.eclipse.swt.internal.widgets.menuitemkit.MenuItemDelegateLCA;
import org.eclipse.swt.internal.widgets.menuitemkit.PushMenuItemLCA;
import org.eclipse.swt.internal.widgets.menuitemkit.RadioMenuItemLCA;
import org.eclipse.swt.internal.widgets.menuitemkit.SeparatorMenuItemLCA;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

public final class MenuItemLCA
extends AbstractWidgetLCA {
    private static final BarMenuItemLCA BAR_MENU_ITEM_LCA = new BarMenuItemLCA();
    private static final PushMenuItemLCA PUSH_MENU_ITEM_LCA = new PushMenuItemLCA();
    private static final CheckMenuItemLCA CHECK_MENU_ITEM_LCA = new CheckMenuItemLCA();
    private static final RadioMenuItemLCA RADIO_MENU_ITEM_LCA = new RadioMenuItemLCA();
    private static final SeparatorMenuItemLCA SEPARATOR_MENU_ITEM_LCA = new SeparatorMenuItemLCA();

    public void preserveValues(Widget widget) {
        MenuItem menuItem = (MenuItem)widget;
        MenuItemLCA.getDelegateLCA(menuItem).preserveValues(menuItem);
    }

    public void readData(Widget widget) {
        MenuItem menuItem = (MenuItem)widget;
        MenuItemLCA.getDelegateLCA(menuItem).readData(menuItem);
    }

    public void renderInitialization(Widget widget) throws IOException {
        MenuItem menuItem = (MenuItem)widget;
        MenuItemLCA.getDelegateLCA(menuItem).renderInitialization(menuItem);
    }

    public void renderChanges(Widget widget) throws IOException {
        MenuItem menuItem = (MenuItem)widget;
        MenuItemLCA.getDelegateLCA(menuItem).renderChanges(menuItem);
    }

    public void renderDispose(Widget widget) throws IOException {
        JSWriter writer = JSWriter.getWriterFor(widget);
        writer.dispose();
    }

    private static boolean isTopLevelMenuBarItem(MenuItem menuItem) {
        return (menuItem.getParent().getStyle() & 2) != 0;
    }

    private static MenuItemDelegateLCA getDelegateLCA(MenuItem menuItem) {
        MenuItemDelegateLCA result;
        if (MenuItemLCA.isTopLevelMenuBarItem(menuItem)) {
            result = BAR_MENU_ITEM_LCA;
        } else if ((menuItem.getStyle() & 0x48) != 0) {
            result = PUSH_MENU_ITEM_LCA;
        } else if ((menuItem.getStyle() & 0x20) != 0) {
            result = CHECK_MENU_ITEM_LCA;
        } else if ((menuItem.getStyle() & 0x10) != 0) {
            result = RADIO_MENU_ITEM_LCA;
        } else if ((menuItem.getStyle() & 2) != 0) {
            result = SEPARATOR_MENU_ITEM_LCA;
        } else {
            throw new IllegalStateException("Unknown menu item type.");
        }
        return result;
    }
}

