/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.util;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.rwt.internal.util.ParamCheck;
import org.eclipse.rwt.internal.util.SerializableLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharedInstanceBuffer<K, I>
implements Serializable {
    private final SerializableLock lock = new SerializableLock();
    private final Map<K, I> store = new HashMap<K, I>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public I get(K key, IInstanceCreator<I> instanceCreator) {
        ParamCheck.notNull(instanceCreator, "valueCreator");
        SerializableLock serializableLock = this.lock;
        synchronized (serializableLock) {
            I result = this.store.get(key);
            if (result == null) {
                result = instanceCreator.createInstance();
                this.store.put(key, result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public I remove(K key) {
        SerializableLock serializableLock = this.lock;
        synchronized (serializableLock) {
            return this.store.remove(key);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IInstanceCreator<T> {
        public T createInstance();
    }
}

