/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.presentation;

import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.rap.demo.presentation.Images;
import org.eclipse.rwt.graphics.Graphics;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.presentations.IPresentablePart;

final class StackPopup
extends PopupDialog {
    private final Control contentProxy;
    private final Object[] parts;
    private final SelectionListener selectionListener;

    StackPopup(Shell parent, Control contentProxy, Object[] parts, SelectionListener selectionListener) {
        super(parent, 16400, false, false, false, false, null, null);
        this.contentProxy = contentProxy;
        this.parts = parts;
        this.selectionListener = selectionListener;
    }

    protected void adjustBounds() {
        Display display = this.contentProxy.getDisplay();
        Point position = display.map((Control)this.contentProxy.getParent(), null, this.contentProxy.getLocation());
        this.getShell().setBounds(position.x - 1, position.y + 1, this.contentProxy.getSize().x + 4, this.contentProxy.getSize().y + 2);
    }

    public int open() {
        int result = super.open();
        Listener closeListener = new Listener(){

            public void handleEvent(Event event) {
                StackPopup.this.close();
            }
        };
        this.getShell().addListener(27, closeListener);
        this.getShell().addListener(21, closeListener);
        this.contentProxy.addListener(12, closeListener);
        Shell controlShell = this.contentProxy.getShell();
        controlShell.addListener(10, closeListener);
        this.getShell().setAlpha(230);
        this.getShell().setBackgroundImage(Images.IMG_MIDDLE_CENTER);
        this.getShell().setActive();
        return result;
    }

    protected Control createDialogArea(Composite parent) {
        final Table result = new Table(parent, 0);
        FontData fontData = result.getFont().getFontData()[0];
        result.setFont(Graphics.getFont((String)fontData.getName(), (int)(fontData.getHeight() + 4), (int)fontData.getStyle()));
        result.setBackgroundImage(Images.IMG_MIDDLE_CENTER);
        result.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent evt) {
                result.removeControlListener((ControlListener)this);
                Point size = result.getSize();
                result.setSize(size.x + 25, size.y + 25);
                result.addControlListener((ControlListener)this);
            }
        });
        result.setRedraw(false);
        result.setItemCount(this.parts.length);
        TableItem[] items = result.getItems();
        int i = 0;
        while (i < items.length) {
            TableItem item = items[i];
            IPresentablePart part = (IPresentablePart)this.parts[i];
            item.setText(part.getTitle());
            item.setImage(part.getTitleImage());
            item.setData((Object)part);
            ++i;
        }
        result.setRedraw(true);
        result.addSelectionListener(this.selectionListener);
        return result;
    }
}

