/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.scalekit;

import java.io.IOException;
import org.eclipse.rap.rwt.internal.lifecycle.AbstractWidgetLCA;
import org.eclipse.rap.rwt.internal.lifecycle.ControlLCAUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.internal.protocol.JsonUtil;
import org.eclipse.rap.rwt.internal.protocol.RemoteObjectFactory;
import org.eclipse.rap.rwt.remote.RemoteObject;
import org.eclipse.swt.internal.widgets.scalekit.ScaleOperationHandler;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Widget;

public final class ScaleLCA
extends AbstractWidgetLCA {
    private static final String TYPE = "rwt.widgets.Scale";
    private static final String[] ALLOWED_STYLES = new String[]{"HORIZONTAL", "VERTICAL", "BORDER"};
    static final String PROP_MINIMUM = "minimum";
    static final String PROP_MAXIMUM = "maximum";
    static final String PROP_SELECTION = "selection";
    static final String PROP_INCREMENT = "increment";
    static final String PROP_PAGE_INCREMENT = "pageIncrement";
    private static final int DEFAULT_MINIMUM = 0;
    private static final int DEFAULT_MAXIMUM = 100;
    private static final int DEFAULT_SELECTION = 0;
    private static final int DEFAULT_INCREMENT = 1;
    private static final int DEFAULT_PAGE_INCREMENT = 10;

    @Override
    public void preserveValues(Widget widget) {
        Scale scale = (Scale)widget;
        ControlLCAUtil.preserveValues(scale);
        WidgetLCAUtil.preserveCustomVariant(scale);
        WidgetLCAUtil.preserveProperty((Widget)scale, PROP_MINIMUM, scale.getMinimum());
        WidgetLCAUtil.preserveProperty((Widget)scale, PROP_MAXIMUM, scale.getMaximum());
        WidgetLCAUtil.preserveProperty((Widget)scale, PROP_SELECTION, scale.getSelection());
        WidgetLCAUtil.preserveProperty((Widget)scale, PROP_INCREMENT, scale.getIncrement());
        WidgetLCAUtil.preserveProperty((Widget)scale, PROP_PAGE_INCREMENT, scale.getPageIncrement());
        WidgetLCAUtil.preserveListenSelection(scale);
    }

    @Override
    public void renderInitialization(Widget widget) throws IOException {
        Scale scale = (Scale)widget;
        RemoteObject remoteObject = RemoteObjectFactory.createRemoteObject(scale, TYPE);
        remoteObject.setHandler(new ScaleOperationHandler(scale));
        remoteObject.set("parent", WidgetUtil.getId(scale.getParent()));
        remoteObject.set("style", JsonUtil.createJsonArray(WidgetLCAUtil.getStyles(scale, ALLOWED_STYLES)));
    }

    @Override
    public void renderChanges(Widget widget) throws IOException {
        Scale scale = (Scale)widget;
        ControlLCAUtil.renderChanges(scale);
        WidgetLCAUtil.renderCustomVariant(scale);
        WidgetLCAUtil.renderProperty((Widget)scale, PROP_MINIMUM, scale.getMinimum(), 0);
        WidgetLCAUtil.renderProperty((Widget)scale, PROP_MAXIMUM, scale.getMaximum(), 100);
        WidgetLCAUtil.renderProperty((Widget)scale, PROP_SELECTION, scale.getSelection(), 0);
        WidgetLCAUtil.renderProperty((Widget)scale, PROP_INCREMENT, scale.getIncrement(), 1);
        WidgetLCAUtil.renderProperty((Widget)scale, PROP_PAGE_INCREMENT, scale.getPageIncrement(), 10);
        WidgetLCAUtil.renderListenSelection(scale);
        WidgetLCAUtil.renderClientListeners(scale);
    }
}

