/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.textsize;

import org.eclipse.rap.rwt.internal.lifecycle.LifeCycleUtil;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.service.ServiceStore;
import org.eclipse.rap.rwt.internal.textsize.BufferScrolledCompositeOriginsVisitor;
import org.eclipse.rap.rwt.internal.textsize.ClearLayoutBuffersVisitor;
import org.eclipse.rap.rwt.internal.textsize.EnlargeScrolledCompositeContentVisitor;
import org.eclipse.rap.rwt.internal.textsize.MarkLayoutNeededVisitor;
import org.eclipse.rap.rwt.internal.textsize.RePackVisitor;
import org.eclipse.rap.rwt.internal.textsize.RestoreScrolledCompositeOriginsVisitor;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.widgets.ControlUtil;
import org.eclipse.swt.internal.widgets.IDisplayAdapter;
import org.eclipse.swt.internal.widgets.IShellAdapter;
import org.eclipse.swt.internal.widgets.WidgetTreeUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

class TextSizeRecalculation {
    static final String TEMPORARY_RESIZE = String.valueOf(TextSizeRecalculation.class.getName()) + "#temporaryResize";
    static final String KEY_SCROLLED_COMPOSITE_CONTENT_SIZE = "org.eclipse.rap.content-size";
    static final String KEY_SCROLLED_COMPOSITE_ORIGIN = "org.eclipse.rap.sc-origin";
    static final int RESIZE_OFFSET = 1000;

    static void execute() {
        Shell[] shellArray = TextSizeRecalculation.getShells();
        int n = shellArray.length;
        int n2 = 0;
        while (n2 < n) {
            Shell shell = shellArray[n2];
            TextSizeRecalculation.forceShellRecalculations(shell);
            ++n2;
        }
    }

    private static void forceShellRecalculations(Shell shell) {
        boolean isPacked = ControlUtil.getControlAdapter(shell).isPacked();
        Rectangle boundsBuffer = shell.getBounds();
        TextSizeRecalculation.bufferScrolledCompositeOrigins(shell);
        TextSizeRecalculation.clearLayoutBuffers(shell);
        TextSizeRecalculation.setTemporaryResize(true);
        TextSizeRecalculation.enlargeShell(shell);
        TextSizeRecalculation.enlargeScrolledCompositeContent(shell);
        TextSizeRecalculation.setTemporaryResize(false);
        TextSizeRecalculation.clearLayoutBuffers(shell);
        TextSizeRecalculation.markLayoutNeeded(shell);
        TextSizeRecalculation.rePack(shell);
        TextSizeRecalculation.restoreScrolledCompositeOrigins(shell);
        TextSizeRecalculation.restoreShellSize(shell, boundsBuffer, isPacked);
    }

    private static void rePack(Shell shell) {
        WidgetTreeUtil.accept(shell, new RePackVisitor());
    }

    private static void clearLayoutBuffers(Shell shell) {
        WidgetTreeUtil.accept(shell, new ClearLayoutBuffersVisitor());
    }

    private static void markLayoutNeeded(Shell shell) {
        WidgetTreeUtil.accept(shell, new MarkLayoutNeededVisitor());
    }

    private static void bufferScrolledCompositeOrigins(Shell shell) {
        WidgetTreeUtil.accept(shell, new BufferScrolledCompositeOriginsVisitor());
    }

    private static void enlargeScrolledCompositeContent(Shell shell) {
        WidgetTreeUtil.accept(shell, new EnlargeScrolledCompositeContentVisitor());
    }

    private static void restoreScrolledCompositeOrigins(Shell shell) {
        WidgetTreeUtil.accept(shell, new RestoreScrolledCompositeOriginsVisitor());
    }

    private static void restoreShellSize(Shell shell, Rectangle bufferedBounds, boolean isPacked) {
        if (isPacked) {
            shell.pack();
            ControlUtil.getControlAdapter(shell).clearPacked();
        } else {
            TextSizeRecalculation.setShellSize(shell, bufferedBounds);
        }
    }

    private static void enlargeShell(Shell shell) {
        Rectangle bounds = shell.getBounds();
        int xPos = bounds.x;
        int yPos = bounds.y;
        int width = bounds.width + 1000;
        int height = bounds.height + 1000;
        TextSizeRecalculation.setShellSize(shell, new Rectangle(xPos, yPos, width, height));
    }

    private static Shell[] getShells() {
        return TextSizeRecalculation.getShells(LifeCycleUtil.getSessionDisplay());
    }

    private static Shell[] getShells(Display display) {
        return display.getAdapter(IDisplayAdapter.class).getShells();
    }

    private static void setShellSize(Shell shell, Rectangle bounds) {
        shell.getAdapter(IShellAdapter.class).setBounds(bounds);
    }

    private static void setTemporaryResize(boolean value) {
        ServiceStore serviceStore = ContextProvider.getServiceStore();
        if (value) {
            serviceStore.setAttribute(TEMPORARY_RESIZE, Boolean.TRUE);
        } else {
            serviceStore.removeAttribute(TEMPORARY_RESIZE);
        }
    }

    private TextSizeRecalculation() {
    }
}

