/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.protocol;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Widget;

public final class StylesUtil {
    private static final Map<String, Integer> availableStyles = new LinkedHashMap<String, Integer>();

    static {
        StylesUtil.initializeAvailableStyles();
    }

    private static void initializeAvailableStyles() {
        Field[] constants;
        Field[] fieldArray = constants = SWT.class.getDeclaredFields();
        int n = constants.length;
        int n2 = 0;
        while (n2 < n) {
            Field constant = fieldArray[n2];
            if (constant.getType() == Integer.TYPE) {
                StylesUtil.addStyleToMap(constant);
            }
            ++n2;
        }
    }

    private static void addStyleToMap(Field constant) {
        String styleName = constant.getName();
        try {
            constant.setAccessible(true);
            Integer value = constant.getInt(null);
            availableStyles.put(styleName, value);
        }
        catch (Exception e) {
            String message = "Could not initialize SWT styles map with constant " + styleName;
            throw new RuntimeException(message, e);
        }
    }

    public static String[] filterStyles(Widget widget, String ... allowedStyles) {
        return StylesUtil.filterStyles(widget.getStyle(), allowedStyles);
    }

    public static String[] filterStyles(int styles, String ... allowedStyles) {
        List<String> containedStyles = StylesUtil.findContainedStyles(styles, allowedStyles);
        if (containedStyles.isEmpty()) {
            containedStyles.add("NONE");
        }
        String[] result = new String[containedStyles.size()];
        return containedStyles.toArray(result);
    }

    private static List<String> findContainedStyles(int styles, String ... allowedStyles) {
        ArrayList<String> containedStyles = new ArrayList<String>();
        String[] stringArray = allowedStyles;
        int n = allowedStyles.length;
        int n2 = 0;
        while (n2 < n) {
            String allowedStyle = stringArray[n2];
            Integer object = availableStyles.get(allowedStyle);
            if (object == null) {
                throw new IllegalArgumentException(String.valueOf(allowedStyle) + " is not an existing SWT style");
            }
            if ((styles & object) != 0) {
                containedStyles.add(allowedStyle);
            }
            ++n2;
        }
        return containedStyles;
    }

    private StylesUtil() {
    }
}

