/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.preferences;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.eclipse.core.internal.preferences.PrefsMessages;
import org.osgi.service.prefs.BackingStoreException;

public abstract class AbstractPreferenceStorage {
    public abstract Properties load(String var1) throws BackingStoreException;

    public abstract void save(String var1, Properties var2) throws BackingStoreException;

    protected Properties loadProperties(InputStream input) throws BackingStoreException {
        Properties result = new Properties();
        try {
            try {
                input = new BufferedInputStream(input);
                result.load(input);
            }
            catch (IOException | IllegalArgumentException e) {
                throw new BackingStoreException(PrefsMessages.preferences_loadProblems, (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (input != null) {
            try {
                input.close();
            }
            catch (IOException iOException) {}
        }
        return result;
    }

    protected void saveProperties(OutputStream output, Properties properties) throws BackingStoreException {
        try {
            try {
                output = new BufferedOutputStream(output);
                properties.store(output, null);
                output.flush();
            }
            catch (IOException e) {
                throw new BackingStoreException(PrefsMessages.preferences_saveProblems, (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (output != null) {
            try {
                output.close();
            }
            catch (IOException iOException) {}
        }
    }

    public abstract String[] childrenNames(String var1) throws BackingStoreException;

    public abstract void removed(String var1);
}

