/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.observable.value;

import org.eclipse.core.databinding.observable.DecoratingObservable;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.ValueDiff;

public class DecoratingObservableValue<T>
extends DecoratingObservable
implements IObservableValue<T> {
    private IObservableValue<T> decorated;
    private IValueChangeListener<T> valueChangeListener;

    public DecoratingObservableValue(IObservableValue<T> decorated, boolean disposeDecoratedOnDispose) {
        super(decorated, disposeDecoratedOnDispose);
        this.decorated = decorated;
    }

    @Override
    public synchronized void addValueChangeListener(IValueChangeListener<? super T> listener) {
        this.addListener(ValueChangeEvent.TYPE, listener);
    }

    @Override
    public synchronized void removeValueChangeListener(IValueChangeListener<? super T> listener) {
        this.removeListener(ValueChangeEvent.TYPE, listener);
    }

    protected void fireValueChange(ValueDiff<T> diff) {
        super.fireChange();
        this.fireEvent(new ValueChangeEvent<T>(this, diff));
    }

    @Override
    protected void fireChange() {
        throw new RuntimeException("fireChange should not be called, use fireValueChange() instead");
    }

    @Override
    protected void firstListenerAdded() {
        if (this.valueChangeListener == null) {
            this.valueChangeListener = event -> this.handleValueChange(event);
        }
        this.decorated.addValueChangeListener(this.valueChangeListener);
        super.firstListenerAdded();
    }

    @Override
    protected void lastListenerRemoved() {
        super.lastListenerRemoved();
        if (this.valueChangeListener != null) {
            this.decorated.removeValueChangeListener(this.valueChangeListener);
            this.valueChangeListener = null;
        }
    }

    protected void handleValueChange(ValueChangeEvent<? extends T> event) {
        this.fireValueChange(Diffs.unmodifiableDiff(event.diff));
    }

    @Override
    public T getValue() {
        this.getterCalled();
        return this.decorated.getValue();
    }

    @Override
    public void setValue(T value) {
        this.checkRealm();
        this.decorated.setValue(value);
    }

    @Override
    public Object getValueType() {
        return this.decorated.getValueType();
    }

    @Override
    public synchronized void dispose() {
        if (this.decorated != null && this.valueChangeListener != null) {
            this.decorated.removeValueChangeListener(this.valueChangeListener);
        }
        this.decorated = null;
        this.valueChangeListener = null;
        super.dispose();
    }
}

