/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.internal.cheatsheets.registry.CheatSheetElement;
import org.eclipse.ui.internal.cheatsheets.registry.CheatSheetRegistryReader;

public class CheatSheetHistory {
    private static final int DEFAULT_DEPTH = 5;
    private ArrayList history;
    private CheatSheetRegistryReader reg;
    private ListenerList listeners = new ListenerList();

    public CheatSheetHistory(CheatSheetRegistryReader reg) {
        this.history = new ArrayList(5);
        this.reg = reg;
    }

    public void addListener(IPropertyListener l) {
        this.listeners.add((Object)l);
    }

    public void removeListener(IPropertyListener l) {
        this.listeners.remove((Object)l);
    }

    private void fireChange() {
        Object[] array = this.listeners.getListeners();
        int i = 0;
        while (i < array.length) {
            IPropertyListener element = (IPropertyListener)array[i];
            element.propertyChanged((Object)this, 0);
            ++i;
        }
    }

    public IStatus restoreState(IMemento memento) {
        IMemento[] children = memento.getChildren("element");
        int i = 0;
        while (i < children.length && i < 5) {
            CheatSheetElement element = this.reg.findCheatSheet(children[i].getID());
            if (element != null) {
                this.history.add(element);
            }
            ++i;
        }
        return new Status(0, "org.eclipse.rap.ui.cheatsheets", 0, "", null);
    }

    public IStatus saveState(IMemento memento) {
        for (CheatSheetElement element : this.history) {
            if (element == null) continue;
            memento.createChild("element", element.getID());
        }
        return new Status(0, "org.eclipse.rap.ui.cheatsheets", 0, "", null);
    }

    public void add(String id) {
        CheatSheetElement element = this.reg.findCheatSheet(id);
        if (element != null) {
            this.add(element);
        }
    }

    public void add(CheatSheetElement element) {
        if (this.history.contains((Object)element)) {
            return;
        }
        int size = this.history.size();
        int preferredSize = 5;
        while (size >= preferredSize) {
            this.history.remove(--size);
        }
        this.history.add(0, element);
        this.fireChange();
    }

    public void refreshFromRegistry() {
        boolean change = false;
        Iterator iter = this.history.iterator();
        while (iter.hasNext()) {
            CheatSheetElement element = (CheatSheetElement)((Object)iter.next());
            if (this.reg.findCheatSheet(element.getID()) != null) continue;
            iter.remove();
            change = true;
        }
        if (change) {
            this.fireChange();
        }
    }

    public int copyItems(List dest, int destStart, int count) {
        int itemCount = count;
        if (itemCount > this.history.size()) {
            itemCount = this.history.size();
        }
        int i = 0;
        while (i < itemCount) {
            dest.add(destStart + i, this.history.get(i));
            ++i;
        }
        return itemCount;
    }
}

