/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.emf.internal.xpath;

import org.eclipse.e4.emf.internal.xpath.EStructuralFeatureOwnerPointer;
import org.eclipse.e4.emf.internal.xpath.EStructuralFeaturePointer;
import org.eclipse.e4.emf.internal.xpath.NullPointer;
import org.eclipse.rap.e4.apache.jxpath.AbstractFactory;
import org.eclipse.rap.e4.apache.jxpath.JXPathAbstractFactoryException;
import org.eclipse.rap.e4.apache.jxpath.JXPathContext;
import org.eclipse.rap.e4.apache.jxpath.JXPathInvalidAccessException;
import org.eclipse.rap.e4.apache.jxpath.ri.QName;
import org.eclipse.rap.e4.apache.jxpath.ri.model.NodePointer;

public class NullEStructuralFeaturePointer
extends EStructuralFeaturePointer {
    private String propertyName = "*";
    private boolean byNameAttribute = false;
    private static final long serialVersionUID = 5296593071854982754L;

    public NullEStructuralFeaturePointer(NodePointer parent) {
        super(parent);
    }

    @Override
    public QName getName() {
        return new QName(this.propertyName);
    }

    @Override
    public void setPropertyIndex(int index) {
    }

    @Override
    public int getLength() {
        return 0;
    }

    @Override
    public Object getBaseValue() {
        return null;
    }

    @Override
    public Object getImmediateNode() {
        return null;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public NodePointer getValuePointer() {
        return new NullPointer((NodePointer)this, new QName(this.getPropertyName()));
    }

    @Override
    protected boolean isActualProperty() {
        return false;
    }

    @Override
    public boolean isActual() {
        return false;
    }

    @Override
    public boolean isContainer() {
        return true;
    }

    @Override
    public void setValue(Object value) {
        if (this.parent == null || this.parent.isContainer()) {
            throw new JXPathInvalidAccessException("Cannot set property " + this.asPath() + ", the target object is null");
        }
        if (!(this.parent instanceof EStructuralFeatureOwnerPointer) || !((EStructuralFeatureOwnerPointer)this.parent).isDynamicPropertyDeclarationSupported()) {
            throw new JXPathInvalidAccessException("Cannot set property " + this.asPath() + ", path does not match a changeable location");
        }
        EStructuralFeaturePointer propertyPointer = ((EStructuralFeatureOwnerPointer)this.parent).getPropertyPointer();
        propertyPointer.setPropertyName(this.propertyName);
        propertyPointer.setValue(value);
    }

    @Override
    public NodePointer createPath(JXPathContext context) {
        NodePointer newParent = this.parent.createPath(context);
        if (this.isAttribute()) {
            return newParent.createAttribute(context, this.getName());
        }
        if (this.parent instanceof NullPointer && this.parent.equals(newParent)) {
            throw this.createBadFactoryException(context.getFactory());
        }
        if (newParent instanceof EStructuralFeatureOwnerPointer) {
            EStructuralFeatureOwnerPointer pop = (EStructuralFeatureOwnerPointer)newParent;
            newParent = pop.getPropertyPointer();
        }
        return newParent.createChild(context, this.getName(), this.getIndex());
    }

    @Override
    public NodePointer createPath(JXPathContext context, Object value) {
        NodePointer newParent = this.parent.createPath(context);
        if (this.isAttribute()) {
            NodePointer pointer = newParent.createAttribute(context, this.getName());
            pointer.setValue(value);
            return pointer;
        }
        if (this.parent instanceof NullPointer && this.parent.equals(newParent)) {
            throw this.createBadFactoryException(context.getFactory());
        }
        if (newParent instanceof EStructuralFeatureOwnerPointer) {
            EStructuralFeatureOwnerPointer pop = (EStructuralFeatureOwnerPointer)newParent;
            newParent = pop.getPropertyPointer();
        }
        return newParent.createChild(context, this.getName(), this.index, value);
    }

    @Override
    public NodePointer createChild(JXPathContext context, QName name, int index) {
        return this.createPath(context).createChild(context, name, index);
    }

    @Override
    public NodePointer createChild(JXPathContext context, QName name, int index, Object value) {
        return this.createPath(context).createChild(context, name, index, value);
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public void setNameAttributeValue(String attributeValue) {
        this.propertyName = attributeValue;
        this.byNameAttribute = true;
    }

    @Override
    public boolean isCollection() {
        return this.getIndex() != Integer.MIN_VALUE;
    }

    @Override
    public int getPropertyCount() {
        return 0;
    }

    @Override
    public String[] getPropertyNames() {
        return new String[0];
    }

    @Override
    public String asPath() {
        if (!this.byNameAttribute) {
            return super.asPath();
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getImmediateParentPointer().asPath());
        buffer.append("[@name='");
        buffer.append(this.escape(this.getPropertyName()));
        buffer.append("']");
        if (this.index != Integer.MIN_VALUE) {
            buffer.append('[').append(this.index + 1).append(']');
        }
        return buffer.toString();
    }

    private JXPathAbstractFactoryException createBadFactoryException(AbstractFactory factory) {
        return new JXPathAbstractFactoryException("Factory " + factory + " reported success creating object for path: " + this.asPath() + " but object was null.  Terminating to avoid stack recursion.");
    }
}

