/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ssi;

import java.io.PrintWriter;
import org.apache.catalina.ssi.SSICommand;
import org.apache.catalina.ssi.SSIMediator;
import org.apache.catalina.ssi.SSIStopProcessingException;

public class SSISet
implements SSICommand {
    /*
     * Enabled aggressive block sorting
     */
    @Override
    public long process(SSIMediator ssiMediator, String commandName, String[] paramNames, String[] paramValues, PrintWriter writer) throws SSIStopProcessingException {
        long lastModified = 0L;
        String errorMessage = ssiMediator.getConfigErrMsg();
        String variableName = null;
        int i = 0;
        while (i < paramNames.length) {
            String paramName = paramNames[i];
            String paramValue = paramValues[i];
            if (paramName.equalsIgnoreCase("var")) {
                variableName = paramValue;
            } else {
                if (!paramName.equalsIgnoreCase("value")) {
                    ssiMediator.log("#set--Invalid attribute: " + paramName);
                    writer.write(errorMessage);
                    throw new SSIStopProcessingException();
                }
                if (variableName == null) {
                    ssiMediator.log("#set--no variable specified");
                    writer.write(errorMessage);
                    throw new SSIStopProcessingException();
                }
                String substitutedValue = ssiMediator.substituteVariables(paramValue);
                ssiMediator.setVariableValue(variableName, substitutedValue);
                lastModified = System.currentTimeMillis();
            }
            ++i;
        }
        return lastModified;
    }
}

