/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.CookieSupport;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.http.ServerCookie;

public final class Cookies {
    private static final Log log = LogFactory.getLog(Cookies.class);
    public static final int INITIAL_SIZE = 4;
    ServerCookie[] scookies = new ServerCookie[4];
    int cookieCount = 0;
    boolean unprocessed = true;
    MimeHeaders headers;

    public Cookies(MimeHeaders headers) {
        this.headers = headers;
    }

    public void recycle() {
        int i = 0;
        while (i < this.cookieCount) {
            if (this.scookies[i] != null) {
                this.scookies[i].recycle();
            }
            ++i;
        }
        this.cookieCount = 0;
        this.unprocessed = true;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("=== Cookies ===");
        int count = this.getCookieCount();
        int i = 0;
        while (i < count) {
            pw.println(this.getCookie(i).toString());
            ++i;
        }
        return sw.toString();
    }

    public ServerCookie getCookie(int idx) {
        if (this.unprocessed) {
            this.getCookieCount();
        }
        return this.scookies[idx];
    }

    public int getCookieCount() {
        if (this.unprocessed) {
            this.unprocessed = false;
            this.processCookies(this.headers);
        }
        return this.cookieCount;
    }

    private ServerCookie addCookie() {
        ServerCookie c;
        if (this.cookieCount >= this.scookies.length) {
            ServerCookie[] scookiesTmp = new ServerCookie[2 * this.cookieCount];
            System.arraycopy(this.scookies, 0, scookiesTmp, 0, this.cookieCount);
            this.scookies = scookiesTmp;
        }
        if ((c = this.scookies[this.cookieCount]) == null) {
            this.scookies[this.cookieCount] = c = new ServerCookie();
        }
        ++this.cookieCount;
        return c;
    }

    public void processCookies(MimeHeaders headers) {
        if (headers == null) {
            return;
        }
        int pos = 0;
        while (pos >= 0) {
            if ((pos = headers.findHeader("Cookie", pos)) < 0) break;
            MessageBytes cookieValue = headers.getValue(pos);
            if (cookieValue == null || cookieValue.isNull()) {
                ++pos;
                continue;
            }
            if (cookieValue.getType() != 2) {
                Exception e = new Exception();
                log.warn("Cookies: Parsing cookie as String. Expected bytes.", e);
                cookieValue.toBytes();
            }
            if (log.isDebugEnabled()) {
                log.debug("Cookies: Parsing b[]: " + cookieValue.toString());
            }
            ByteChunk bc = cookieValue.getByteChunk();
            this.processCookieHeader(bc.getBytes(), bc.getOffset(), bc.getLength());
            ++pos;
        }
    }

    private static boolean equals(String s, byte[] b, int start, int end) {
        int blen = end - start;
        if (b == null || blen != s.length()) {
            return false;
        }
        int boff = start;
        int i = 0;
        while (i < blen) {
            if (b[boff++] != s.charAt(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static final boolean isWhiteSpace(byte c) {
        return c == 32 || c == 9 || c == 10 || c == 13 || c == 12;
    }

    private static void unescapeDoubleQuotes(ByteChunk bc) {
        if (bc == null || bc.getLength() == 0 || bc.indexOf('\"', 0) == -1) {
            return;
        }
        int src = bc.getStart();
        int end = bc.getEnd();
        int dest = src;
        byte[] buffer = bc.getBuffer();
        while (src < end) {
            if (buffer[src] == 92 && src < end && buffer[src + 1] == 34) {
                ++src;
            }
            buffer[dest] = buffer[src];
            ++dest;
            ++src;
        }
        bc.setEnd(dest);
    }

    /*
     * Unable to fully structure code
     */
    protected final void processCookieHeader(byte[] bytes, int off, int len) {
        if (len <= 0 || bytes == null) {
            return;
        }
        end = off + len;
        pos = off;
        nameStart = 0;
        nameEnd = 0;
        valueStart = 0;
        valueEnd = 0;
        version = 0;
        sc = null;
        while (pos < end) {
            block22: {
                block21: {
                    isSpecial = false;
                    isQuoted = false;
                    while (pos < end && (CookieSupport.isHttpSeparator((char)bytes[pos]) && !CookieSupport.ALLOW_HTTP_SEPARATORS_IN_V0 || CookieSupport.isV0Separator((char)bytes[pos]) || Cookies.isWhiteSpace(bytes[pos]))) {
                        ++pos;
                    }
                    if (pos >= end) {
                        return;
                    }
                    if (bytes[pos] == 36) {
                        isSpecial = true;
                    }
                    valueStart = nameStart = ++pos;
                    valueEnd = nameStart;
                    pos = nameEnd = Cookies.getTokenEndPosition(bytes, pos, end, version, true);
                    while (pos < end && Cookies.isWhiteSpace(bytes[pos])) {
                        ++pos;
                    }
                    if (pos >= end - 1 || bytes[pos] != 61) break block21;
                    while (++pos < end && Cookies.isWhiteSpace(bytes[pos])) {
                    }
                    if (pos >= end) {
                        return;
                    }
                    switch (bytes[pos]) {
                        case 34: {
                            isQuoted = true;
                            valueStart = pos + 1;
                            pos = valueEnd = Cookies.getQuotedValueEndPosition(bytes, valueStart, end);
                            if (pos >= end) {
                                return;
                            }
                            break block22;
                        }
                        case 44: 
                        case 59: {
                            valueEnd = -1;
                            valueStart = -1;
                            break block22;
                        }
                        default: {
                            if ((version != 0 || CookieSupport.isV0Separator((char)bytes[pos]) || !CookieSupport.ALLOW_HTTP_SEPARATORS_IN_V0) && CookieSupport.isHttpSeparator((char)bytes[pos]) && (bytes[pos] != 61 || !CookieSupport.ALLOW_EQUALS_IN_VALUE)) ** GOTO lbl49
                            valueStart = pos;
                            pos = valueEnd = Cookies.getTokenEndPosition(bytes, valueStart, end, version, false);
                            break block22;
lbl49:
                            // 1 sources

                            Cookies.log.info("Cookies: Invalid cookie. Value not a token or quoted value");
                            while (pos < end && bytes[pos] != 59 && bytes[pos] != 44) {
                                ++pos;
                            }
                            ++pos;
                            sc = null;
                            break;
                        }
                    }
                    continue;
                }
                valueEnd = -1;
                valueStart = -1;
                pos = nameEnd;
            }
            while (pos < end && Cookies.isWhiteSpace(bytes[pos])) {
                ++pos;
            }
            while (pos < end && bytes[pos] != 59 && bytes[pos] != 44) {
                ++pos;
            }
            ++pos;
            if (isSpecial) {
                isSpecial = false;
                if (Cookies.equals("Version", bytes, nameStart, nameEnd) && sc == null) {
                    if (bytes[valueStart] != 49 || valueEnd != valueStart + 1) continue;
                    version = 1;
                    continue;
                }
                if (sc == null) continue;
                if (Cookies.equals("Domain", bytes, nameStart, nameEnd)) {
                    sc.getDomain().setBytes(bytes, valueStart, valueEnd - valueStart);
                    continue;
                }
                if (Cookies.equals("Path", bytes, nameStart, nameEnd)) {
                    sc.getPath().setBytes(bytes, valueStart, valueEnd - valueStart);
                    continue;
                }
                if (Cookies.equals("Port", bytes, nameStart, nameEnd) || Cookies.equals("CommentURL", bytes, nameStart, nameEnd)) continue;
                Cookies.log.info("Cookies: Unknown Special Cookie");
                continue;
            }
            if (valueStart == -1 && !CookieSupport.ALLOW_NAME_ONLY) continue;
            sc = this.addCookie();
            sc.setVersion(version);
            sc.getName().setBytes(bytes, nameStart, nameEnd - nameStart);
            if (valueStart != -1) {
                sc.getValue().setBytes(bytes, valueStart, valueEnd - valueStart);
                if (!isQuoted) continue;
                Cookies.unescapeDoubleQuotes(sc.getValue().getByteChunk());
                continue;
            }
            sc.getValue().setString("");
        }
    }

    private static final int getTokenEndPosition(byte[] bytes, int off, int end, int version, boolean isName) {
        int pos = off;
        while (pos < end && (!CookieSupport.isHttpSeparator((char)bytes[pos]) || version == 0 && CookieSupport.ALLOW_HTTP_SEPARATORS_IN_V0 && bytes[pos] != 61 && !CookieSupport.isV0Separator((char)bytes[pos]) || !isName && bytes[pos] == 61 && CookieSupport.ALLOW_EQUALS_IN_VALUE)) {
            ++pos;
        }
        if (pos > end) {
            return end;
        }
        return pos;
    }

    private static final int getQuotedValueEndPosition(byte[] bytes, int off, int end) {
        int pos = off;
        while (pos < end) {
            if (bytes[pos] == 34) {
                return pos;
            }
            if (bytes[pos] == 92 && pos < end - 1) {
                pos += 2;
                continue;
            }
            ++pos;
        }
        return end;
    }
}

