/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.supplemental.fileupload.internal;

import org.apache.commons.io.FileCleaningTracker;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.service.UISession;
import org.eclipse.rap.rwt.service.UISessionEvent;
import org.eclipse.rap.rwt.service.UISessionListener;

class CleaningTrackerUtil {
    static final String TRACKER_ATTR = CleaningTrackerUtil.class.getName().concat("#cleaningTrackerInstance");
    private static final FileUploadCleanupHandler LISTENER = new FileUploadCleanupHandler();

    private CleaningTrackerUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileCleaningTracker getCleaningTracker(boolean create) {
        FileCleaningTracker tracker;
        UISession uisession;
        UISession uISession = uisession = RWT.getUISession();
        synchronized (uISession) {
            tracker = (FileCleaningTracker)uisession.getAttribute(TRACKER_ATTR);
            if (tracker == null && create) {
                tracker = new FileCleaningTracker();
                uisession.setAttribute(TRACKER_ATTR, (Object)tracker);
                uisession.addUISessionListener((UISessionListener)LISTENER);
            }
        }
        return tracker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void stopCleaningTracker(UISession uisession) {
        UISession uISession = uisession;
        synchronized (uISession) {
            FileCleaningTracker tracker = (FileCleaningTracker)uisession.getAttribute(TRACKER_ATTR);
            if (tracker != null) {
                tracker.exitWhenFinished();
                uisession.removeAttribute(TRACKER_ATTR);
            }
        }
    }

    private static class FileUploadCleanupHandler
    implements UISessionListener {
        private FileUploadCleanupHandler() {
        }

        public void beforeDestroy(UISessionEvent event) {
            CleaningTrackerUtil.stopCleaningTracker(event.getUISession());
        }
    }
}

