/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.grid.internal.gridcolumngroupkit;

import java.io.IOException;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridColumnGroup;
import org.eclipse.rap.rwt.Adaptable;
import org.eclipse.rap.rwt.internal.protocol.ClientObjectFactory;
import org.eclipse.rap.rwt.internal.protocol.IClientObject;
import org.eclipse.rap.rwt.internal.protocol.ProtocolUtil;
import org.eclipse.rap.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rap.rwt.lifecycle.ProcessActionRunner;
import org.eclipse.rap.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.internal.widgets.ItemLCAUtil;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;

public class GridColumnGroupLCA
extends AbstractWidgetLCA {
    private static final String TYPE = "rwt.widgets.GridColumnGroup";
    private static final String[] ALLOWED_STYLES = new String[]{"TOGGLE"};
    private static final String PROP_LEFT = "left";
    private static final String PROP_WIDTH = "width";
    private static final String PROP_HEIGHT = "height";
    private static final String PROP_VISIBLE = "visibility";
    private static final String PROP_FONT = "font";
    private static final String PROP_EXPANDED = "expanded";
    private static final String PROP_EXPAND_LISTENER = "Expand";
    private static final String PROP_COLLAPSE_LISTENER = "Collapse";
    private static final int ZERO = 0;

    public void renderInitialization(Widget widget) throws IOException {
        GridColumnGroup group = (GridColumnGroup)widget;
        IClientObject clientObject = ClientObjectFactory.getClientObject((Adaptable)group);
        clientObject.create(TYPE);
        clientObject.set("parent", WidgetUtil.getId((Widget)group.getParent()));
        clientObject.set("style", (Object)WidgetLCAUtil.getStyles((Widget)group, (String[])ALLOWED_STYLES));
    }

    public void readData(Widget widget) {
        GridColumnGroup group = (GridColumnGroup)widget;
        GridColumnGroupLCA.readExpanded(group);
        GridColumnGroupLCA.processTreeEvent(group, 17, PROP_EXPAND_LISTENER);
        GridColumnGroupLCA.processTreeEvent(group, 18, PROP_COLLAPSE_LISTENER);
    }

    public void preserveValues(Widget widget) {
        GridColumnGroup group = (GridColumnGroup)widget;
        WidgetLCAUtil.preserveCustomVariant((Widget)group);
        ItemLCAUtil.preserve((Item)group);
        WidgetLCAUtil.preserveProperty((Widget)group, (String)PROP_LEFT, (int)GridColumnGroupLCA.getLeft(group));
        WidgetLCAUtil.preserveProperty((Widget)group, (String)PROP_WIDTH, (int)GridColumnGroupLCA.getWidth(group));
        WidgetLCAUtil.preserveProperty((Widget)group, (String)PROP_HEIGHT, (int)GridColumnGroupLCA.getHeight(group));
        WidgetLCAUtil.preserveProperty((Widget)group, (String)PROP_VISIBLE, (boolean)GridColumnGroupLCA.isVisible(group));
        WidgetLCAUtil.preserveProperty((Widget)group, (String)PROP_FONT, (Object)group.getHeaderFont());
        WidgetLCAUtil.preserveProperty((Widget)group, (String)PROP_EXPANDED, (boolean)group.getExpanded());
        WidgetLCAUtil.preserveListener((Widget)group, (String)PROP_EXPAND_LISTENER, (boolean)GridColumnGroupLCA.hasExpandListener(group));
        WidgetLCAUtil.preserveListener((Widget)group, (String)PROP_COLLAPSE_LISTENER, (boolean)GridColumnGroupLCA.hasCollapseListener(group));
    }

    public void renderChanges(Widget widget) throws IOException {
        GridColumnGroup group = (GridColumnGroup)widget;
        WidgetLCAUtil.renderCustomVariant((Widget)group);
        ItemLCAUtil.renderChanges((Item)group);
        WidgetLCAUtil.renderProperty((Widget)group, (String)PROP_LEFT, (int)GridColumnGroupLCA.getLeft(group), (int)0);
        WidgetLCAUtil.renderProperty((Widget)group, (String)PROP_WIDTH, (int)GridColumnGroupLCA.getWidth(group), (int)0);
        WidgetLCAUtil.renderProperty((Widget)group, (String)PROP_HEIGHT, (int)GridColumnGroupLCA.getHeight(group), (int)0);
        WidgetLCAUtil.renderProperty((Widget)group, (String)PROP_VISIBLE, (boolean)GridColumnGroupLCA.isVisible(group), (boolean)true);
        GridColumnGroupLCA.renderFont(group, PROP_FONT, group.getHeaderFont());
        WidgetLCAUtil.renderProperty((Widget)group, (String)PROP_EXPANDED, (boolean)group.getExpanded(), (boolean)true);
        WidgetLCAUtil.renderListener((Widget)group, (String)PROP_EXPAND_LISTENER, (boolean)GridColumnGroupLCA.hasExpandListener(group), (boolean)false);
        WidgetLCAUtil.renderListener((Widget)group, (String)PROP_COLLAPSE_LISTENER, (boolean)GridColumnGroupLCA.hasCollapseListener(group), (boolean)false);
    }

    private static void readExpanded(final GridColumnGroup group) {
        final String expanded = WidgetLCAUtil.readPropertyValue((Widget)group, (String)PROP_EXPANDED);
        if (expanded != null) {
            ProcessActionRunner.add((Runnable)new Runnable(){

                public void run() {
                    group.setExpanded(Boolean.valueOf(expanded));
                }
            });
        }
    }

    private static void processTreeEvent(GridColumnGroup group, int eventType, String eventName) {
        if (WidgetLCAUtil.wasEventSent((Widget)group, (String)eventName) && group.isListening(eventType)) {
            group.notifyListeners(eventType, new Event());
        }
    }

    private static void renderFont(GridColumnGroup group, String property, Font newValue) {
        if (WidgetLCAUtil.hasChanged((Widget)group, (String)property, (Object)newValue, (Object)group.getParent().getFont())) {
            IClientObject clientObject = ClientObjectFactory.getClientObject((Adaptable)group);
            clientObject.set(property, (Object)ProtocolUtil.getFontAsArray((Font)newValue));
        }
    }

    private static int getLeft(GridColumnGroup group) {
        int result = 0;
        Grid grid = group.getParent();
        int[] columnOrder = grid.getColumnOrder();
        boolean found = false;
        int i = 0;
        while (i < columnOrder.length && !found) {
            GridColumn currentColumn = grid.getColumn(columnOrder[i]);
            if (currentColumn.getColumnGroup() == group) {
                found = true;
            } else if (currentColumn.isVisible()) {
                result += currentColumn.getWidth();
            }
            ++i;
        }
        return result;
    }

    private static int getWidth(GridColumnGroup group) {
        int result = 0;
        GridColumn[] columns = group.getColumns();
        int i = 0;
        while (i < columns.length) {
            if (columns[i].isVisible()) {
                result += columns[i].getWidth();
            }
            ++i;
        }
        return result;
    }

    private static int getHeight(GridColumnGroup group) {
        return group.getParent().getGroupHeaderHeight();
    }

    private static boolean isVisible(GridColumnGroup group) {
        boolean result = false;
        GridColumn[] columns = group.getColumns();
        int i = 0;
        while (i < columns.length && !result) {
            if (columns[i].isVisible()) {
                result = true;
            }
            ++i;
        }
        return result;
    }

    private static boolean hasExpandListener(GridColumnGroup group) {
        return true;
    }

    private static boolean hasCollapseListener(GridColumnGroup group) {
        return true;
    }
}

