/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.io.File;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.eclipse.rap.addons.fileupload.DiskFileUploadReceiver;
import org.eclipse.rap.addons.fileupload.FileUploadHandler;
import org.eclipse.rap.addons.fileupload.FileUploadReceiver;
import org.eclipse.rap.rwt.service.ServerPushSession;
import org.eclipse.rap.rwt.widgets.FileUpload;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.widgets.FileUploadRunnable;
import org.eclipse.swt.internal.widgets.LayoutUtil;
import org.eclipse.swt.internal.widgets.ProgressCollector;
import org.eclipse.swt.internal.widgets.UploadPanel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class FileDialog
extends Dialog {
    private final ServerPushSession pushSession;
    private final ThreadPoolExecutor singleThreadExecutor;
    private Display display;
    private ScrolledComposite uploadsScroller;
    private Button okButton;
    private Label spacer;
    private UploadPanel placeHolder;
    private ProgressCollector progressCollector;

    public FileDialog(Shell parent) {
        this(parent, 67616);
    }

    public FileDialog(Shell parent, int style) {
        super(parent, FileDialog.checkStyle(parent, style));
        this.checkSubclass();
        this.pushSession = new ServerPushSession();
        this.singleThreadExecutor = this.createSingleThreadExecutor();
    }

    public String getFileName() {
        String[] fileNames = this.getFileNames();
        return fileNames.length == 0 ? "" : fileNames[0];
    }

    public String[] getFileNames() {
        return this.returnCode == 32 ? this.progressCollector.getCompletedFileNames() : new String[]{};
    }

    public String open() {
        this.prepareOpen();
        this.runEventLoop(this.shell);
        return this.returnCode == 32 ? this.getFileName() : null;
    }

    protected void prepareOpen() {
        this.createShell();
        this.createControls();
        this.initializeBounds();
        this.initializeDefaults();
        this.pushSession.start();
    }

    private void createShell() {
        this.shell = new Shell(this.getParent(), this.getStyle());
        this.shell.setText(this.getText());
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                FileDialog.this.cleanup();
            }
        });
        this.display = this.shell.getDisplay();
    }

    private void initializeBounds() {
        Point prefSize = this.shell.computeSize(-1, -1);
        prefSize.y += 165;
        this.shell.setMinimumSize(prefSize);
        Rectangle parentSize = this.getParent().getBounds();
        int locationX = (parentSize.width - prefSize.x) / 2 + parentSize.x;
        int locationY = (parentSize.height - prefSize.y) / 2 + parentSize.y;
        this.shell.setBounds(locationX, locationY, prefSize.x, prefSize.y);
        this.spacer.setLayoutData((Object)LayoutUtil.createHorizontalFillData());
    }

    private void initializeDefaults() {
        this.setReturnCode(256);
    }

    private void createControls() {
        this.shell.setLayout((Layout)LayoutUtil.createGridLayout(1, 10, 10));
        this.createDialogArea((Composite)this.shell);
        this.createButtonsArea((Composite)this.shell);
    }

    private void createDialogArea(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        dialogArea.setLayoutData((Object)LayoutUtil.createFillData());
        dialogArea.setLayout((Layout)LayoutUtil.createGridLayout(1, 0, 5));
        this.createUploadsArea(dialogArea);
        this.createProgressArea(dialogArea);
    }

    private void createUploadsArea(Composite parent) {
        this.uploadsScroller = new ScrolledComposite(parent, 512);
        this.uploadsScroller.setLayoutData((Object)LayoutUtil.createFillData());
        this.uploadsScroller.setExpandHorizontal(true);
        this.uploadsScroller.setExpandVertical(true);
        Composite scrolledContent = new Composite((Composite)this.uploadsScroller, 0);
        scrolledContent.setLayout((Layout)new GridLayout(1, false));
        this.uploadsScroller.setContent((Control)scrolledContent);
        this.uploadsScroller.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                FileDialog.this.updateScrolledComposite();
            }
        });
        this.placeHolder = new UploadPanel(scrolledContent, new String[]{""});
        this.placeHolder.setLayoutData(LayoutUtil.createHorizontalFillData());
    }

    private void createProgressArea(Composite parent) {
        this.progressCollector = new ProgressCollector(parent);
        this.progressCollector.setLayoutData(LayoutUtil.createHorizontalFillData());
    }

    private void createButtonsArea(Composite parent) {
        Composite buttonsArea = new Composite(parent, 0);
        buttonsArea.setLayout((Layout)LayoutUtil.createGridLayout(4, 0, 5));
        buttonsArea.setLayoutData((Object)LayoutUtil.createHorizontalFillData());
        String text = this.isMulti() ? SWT.getMessage((String)"SWT_Add") : SWT.getMessage((String)"SWT_Browse");
        this.createFileUpload(buttonsArea, text);
        this.createSpacer(buttonsArea);
        this.okButton = this.createButton(buttonsArea, SWT.getMessage((String)"SWT_OK"));
        parent.getShell().setDefaultButton(this.okButton);
        this.okButton.forceFocus();
        this.okButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FileDialog.this.okPressed();
            }
        });
        Button cancelButton = this.createButton(buttonsArea, SWT.getMessage((String)"SWT_Cancel"));
        cancelButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FileDialog.this.cancelPressed();
            }
        });
    }

    protected FileUpload createFileUpload(Composite parent, String text) {
        FileUpload fileUpload = new FileUpload(parent, this.isMulti() ? 2 : 0);
        fileUpload.setText(text);
        fileUpload.setLayoutData((Object)LayoutUtil.createButtonLayoutData((Control)fileUpload));
        fileUpload.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FileDialog.this.handleFileUploadSelection((FileUpload)event.widget);
            }
        });
        fileUpload.moveAbove(null);
        return fileUpload;
    }

    private void createSpacer(Composite buttonArea) {
        this.spacer = new Label(buttonArea, 0);
        this.spacer.setLayoutData((Object)LayoutUtil.createButtonLayoutData((Control)this.spacer));
    }

    protected Button createButton(Composite parent, String text) {
        Button button = new Button(parent, 8);
        button.setText(text);
        button.setLayoutData((Object)LayoutUtil.createButtonLayoutData((Control)button));
        return button;
    }

    private void handleFileUploadSelection(FileUpload fileUpload) {
        this.placeHolder.dispose();
        FileUploadHandler handler = new FileUploadHandler((FileUploadReceiver)new DiskFileUploadReceiver());
        UploadPanel uploadPanel = this.createUploadPanel(fileUpload.getFileNames());
        this.updateScrolledComposite();
        this.updateButtonsArea(fileUpload);
        FileUploadRunnable uploadRunnable = new FileUploadRunnable(fileUpload, uploadPanel, this.progressCollector, handler);
        this.singleThreadExecutor.execute(uploadRunnable);
    }

    private void updateScrolledComposite() {
        Composite content = (Composite)this.uploadsScroller.getContent();
        int i = 0;
        while (i < 2) {
            Rectangle clientArea = this.uploadsScroller.getClientArea();
            Point minSize = content.computeSize(clientArea.width, -1);
            this.uploadsScroller.setMinSize(minSize);
            ++i;
        }
        this.uploadsScroller.setOrigin(0, 10000);
        content.layout();
    }

    private void updateButtonsArea(FileUpload fileUpload) {
        if (this.isMulti()) {
            Composite buttonsArea = fileUpload.getParent();
            FileDialog.hideFileUpload(fileUpload);
            this.createFileUpload(buttonsArea, SWT.getMessage((String)"SWT_Add"));
            buttonsArea.layout();
        } else {
            fileUpload.setEnabled(false);
        }
    }

    private UploadPanel createUploadPanel(String[] fileNames) {
        Composite parent = (Composite)this.uploadsScroller.getContent();
        UploadPanel uploadPanel = new UploadPanel(parent, fileNames);
        uploadPanel.setLayoutData(LayoutUtil.createHorizontalFillData());
        return uploadPanel;
    }

    private static void hideFileUpload(FileUpload fileUpload) {
        GridData layoutData = LayoutUtil.createButtonLayoutData((Control)fileUpload);
        layoutData.exclude = true;
        fileUpload.setLayoutData((Object)layoutData);
        fileUpload.setVisible(false);
    }

    private void setButtonEnabled(final boolean enabled) {
        if (!this.display.isDisposed()) {
            this.display.asyncExec(new Runnable(){

                public void run() {
                    if (!FileDialog.this.okButton.isDisposed()) {
                        FileDialog.this.okButton.setEnabled(enabled);
                    }
                }
            });
        }
    }

    private void okPressed() {
        this.setReturnCode(32);
        this.close();
    }

    private void cancelPressed() {
        this.setReturnCode(256);
        this.close();
    }

    private void setReturnCode(int code) {
        this.returnCode = code;
    }

    private boolean isMulti() {
        return (this.getStyle() & 2) != 0;
    }

    private void close() {
        this.shell.close();
    }

    private void cleanup() {
        this.pushSession.stop();
        this.singleThreadExecutor.shutdownNow();
        if (this.returnCode == 256) {
            this.deleteUploadedFiles(this.progressCollector.getCompletedFileNames());
        }
    }

    void deleteUploadedFiles(String[] fileNames) {
        String[] stringArray = fileNames;
        int n = fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            File file = new File(fileName);
            if (file.exists()) {
                file.delete();
            }
            ++n2;
        }
    }

    static int checkStyle(Shell parent, int style) {
        int result = style;
        int mask = 229376;
        if ((result & 0x10000000) != 0 && ((result &= 0xEFFFFFFF) & mask) == 0) {
            result |= parent == null ? 65536 : 32768;
        }
        if ((result & mask) == 0) {
            result |= 0x10000;
        }
        if ((result & 0x2000000) == 0 && parent != null && (parent.getStyle() & 0x2000000) != 0) {
            result |= 0x2000000;
        }
        result |= 0x820;
        return result &= 0xFFFFFF7F;
    }

    ThreadPoolExecutor createSingleThreadExecutor() {
        return new SingleThreadExecutor();
    }

    private final class SingleThreadExecutor
    extends ThreadPoolExecutor {
        public SingleThreadExecutor() {
            super(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        }

        protected void beforeExecute(Thread thread, Runnable runnable) {
            FileDialog.this.setButtonEnabled(false);
        }

        protected void afterExecute(Runnable runnable, Throwable throwable) {
            if (this.getQueue().size() == 0) {
                FileDialog.this.setButtonEnabled(true);
            }
        }
    }
}

