/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.grid;

import java.util.ArrayList;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.internal.IGridItemAdapter;
import org.eclipse.rap.rwt.internal.textsize.TextSizeUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SerializableCompatibility;
import org.eclipse.swt.internal.widgets.IWidgetColorAdapter;
import org.eclipse.swt.internal.widgets.IWidgetFontAdapter;
import org.eclipse.swt.internal.widgets.MarkupUtil;
import org.eclipse.swt.internal.widgets.MarkupValidator;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridItem
extends Item {
    private Grid parent;
    private GridItem parentItem;
    private ArrayList<Data> data;
    private ArrayList<GridItem> children = new ArrayList();
    private boolean hasChildren;
    private int level;
    private int customHeight = -1;
    private boolean visible = true;
    private boolean expanded;
    private boolean hasSetData;
    private Font defaultFont;
    private Color defaultBackground;
    private Color defaultForeground;
    private transient IGridItemAdapter gridItemAdapter;

    public GridItem(Grid parent, int style) {
        this(parent, style, -1);
    }

    public GridItem(Grid parent, int style, int index) {
        super((Widget)parent, style, index);
        this.parent = parent;
        this.init();
        parent.newItem(this, index, true);
        parent.newRootItem(this, index);
        parent.setScrollValuesObsolete();
    }

    public GridItem(GridItem parent, int style) {
        this(parent, style, -1);
    }

    public GridItem(GridItem parent, int style, int index) {
        super((Widget)parent, style, index);
        this.parentItem = parent;
        this.parent = this.parentItem.getParent();
        this.parent.newItem(this, index, false);
        this.init();
        this.level = this.parentItem.getLevel() + 1;
        this.parentItem.newItem(this, index);
        if (parent.isVisible() && parent.isExpanded()) {
            this.setVisible(true);
        } else {
            this.setVisible(false);
        }
        this.parent.setScrollValuesObsolete();
    }

    public void dispose() {
        if (!this.parent.isDisposing() && !this.isDisposed()) {
            int i = 0;
            while (i < this.parent.getColumnCount()) {
                Data itemData = this.getItemData(i);
                this.updateColumnImageCount(i, itemData.image, null);
                this.updateColumnTextCount(i, itemData.text, "");
                ++i;
            }
            this.parent.removeItem(this);
            if (this.parentItem != null) {
                this.parentItem.remove(this);
            } else {
                this.parent.removeRootItem(this);
            }
            i = this.children.size() - 1;
            while (i >= 0) {
                this.children.get(i).dispose();
                --i;
            }
        }
        super.dispose();
    }

    public void fireEvent(int eventId) {
        this.checkWidget();
        Event event = new Event();
        event.display = this.getDisplay();
        event.widget = this;
        event.item = this;
        event.type = eventId;
        this.getParent().notifyListeners(eventId, event);
    }

    public void fireCheckEvent(int column) {
        this.checkWidget();
        Event event = new Event();
        event.display = this.getDisplay();
        event.widget = this;
        event.item = this;
        event.type = 13;
        event.detail = 32;
        event.index = column;
        this.getParent().notifyListeners(13, event);
    }

    public Grid getParent() {
        this.checkWidget();
        return this.parent;
    }

    public GridItem getParentItem() {
        this.checkWidget();
        return this.parentItem;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.children.size();
    }

    public GridItem[] getItems() {
        return this.children.toArray(new GridItem[this.children.size()]);
    }

    public GridItem getItem(int index) {
        this.checkWidget();
        return this.children.get(index);
    }

    public int indexOf(GridItem item) {
        this.checkWidget();
        if (item == null) {
            SWT.error((int)4);
        }
        if (item.isDisposed()) {
            SWT.error((int)5);
        }
        return this.children.indexOf((Object)item);
    }

    public boolean hasChildren() {
        this.checkWidget();
        return this.hasChildren;
    }

    public boolean isExpanded() {
        this.checkWidget();
        return this.expanded;
    }

    public void setExpanded(boolean expanded) {
        this.checkWidget();
        this.expanded = expanded;
        boolean unselected = false;
        for (GridItem item : this.children) {
            item.setVisible(expanded && this.visible);
            if (expanded) continue;
            if (this.parent.isSelected(item)) {
                this.parent.deselect(this.parent.indexOf(item));
                unselected = true;
            }
            if (!this.deselectChildren(item)) continue;
            unselected = true;
        }
        this.parent.invalidateTopBottomIndex();
        this.parent.setScrollValuesObsolete();
        if (unselected) {
            Event event = new Event();
            event.item = this;
            this.parent.notifyListeners(13, event);
        }
        if (this.parent.getFocusItem() != null && !this.parent.getFocusItem().isVisible()) {
            this.parent.setFocusItem(this);
        }
    }

    public int getLevel() {
        this.checkWidget();
        return this.level;
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error((int)5);
        }
        this.defaultFont = font;
        this.parent.redraw();
    }

    public Font getFont() {
        this.checkWidget();
        return this.defaultFont == null ? this.parent.getFont() : this.defaultFont;
    }

    public void setFont(int index, Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error((int)5);
        }
        this.getItemData((int)index).font = font;
        this.parent.redraw();
    }

    public Font getFont(int index) {
        this.checkWidget();
        this.handleVirtual();
        return this.internalGetFont(index);
    }

    public void setBackground(Color background) {
        this.checkWidget();
        if (background != null && background.isDisposed()) {
            SWT.error((int)5);
        }
        this.defaultBackground = background;
        this.parent.redraw();
    }

    public Color getBackground() {
        this.checkWidget();
        return this.defaultBackground == null ? this.parent.getBackground() : this.defaultBackground;
    }

    public void setBackground(int index, Color background) {
        this.checkWidget();
        if (background != null && background.isDisposed()) {
            SWT.error((int)5);
        }
        this.getItemData((int)index).background = background;
        this.parent.redraw();
    }

    public Color getBackground(int index) {
        this.checkWidget();
        this.handleVirtual();
        Color result = this.getItemData((int)index).background;
        if (result == null) {
            result = this.getBackground();
        }
        return result;
    }

    public void setForeground(Color foreground) {
        this.checkWidget();
        if (foreground != null && foreground.isDisposed()) {
            SWT.error((int)5);
        }
        this.defaultForeground = foreground;
        this.parent.redraw();
    }

    public Color getForeground() {
        this.checkWidget();
        return this.defaultForeground == null ? this.parent.getForeground() : this.defaultForeground;
    }

    public void setForeground(int index, Color foreground) {
        this.checkWidget();
        if (foreground != null && foreground.isDisposed()) {
            SWT.error((int)5);
        }
        this.getItemData((int)index).foreground = foreground;
        this.parent.redraw();
    }

    public Color getForeground(int index) {
        this.checkWidget();
        this.handleVirtual();
        Color result = this.getItemData((int)index).foreground;
        if (result == null) {
            result = this.getForeground();
        }
        return result;
    }

    public void setText(String string) {
        this.setText(0, string);
    }

    public String getText() {
        return this.getText(0);
    }

    public void setText(int index, String text) {
        this.checkWidget();
        if (text == null) {
            SWT.error((int)4);
        }
        if (MarkupUtil.isMarkupEnabledFor((Widget)this.parent) && !MarkupValidator.isValidationDisabledFor((Widget)this.parent)) {
            MarkupValidator.getInstance().validate(text);
        }
        Data itemData = this.getItemData(index);
        this.updateColumnTextCount(index, itemData.text, text);
        itemData.text = text;
        this.parent.redraw();
    }

    public String getText(int index) {
        this.checkWidget();
        this.handleVirtual();
        return this.getItemData((int)index).text;
    }

    public void setToolTipText(int index, String tooltip) {
        this.checkWidget();
        this.getItemData((int)index).tooltip = tooltip;
        if (tooltip != null && tooltip.length() > 0) {
            this.parent.setCellToolTipsEnabled(true);
        }
    }

    public String getToolTipText(int index) {
        this.checkWidget();
        this.handleVirtual();
        return this.getItemData((int)index).tooltip;
    }

    public void setImage(Image image) {
        this.setImage(0, image);
        this.parent.redraw();
    }

    public Image getImage() {
        this.checkWidget();
        return this.getImage(0);
    }

    public void setImage(int index, Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            SWT.error((int)5);
        }
        Data itemData = this.getItemData(index);
        this.updateColumnImageCount(index, itemData.image, image);
        itemData.image = image;
        this.parent.imageSetOnItem(index, this);
        this.parent.redraw();
    }

    public Image getImage(int index) {
        this.checkWidget();
        this.handleVirtual();
        return this.getItemData((int)index).image;
    }

    public void setChecked(boolean checked) {
        this.checkWidget();
        this.setChecked(0, checked);
        this.parent.redraw();
    }

    public boolean getChecked() {
        this.checkWidget();
        return this.getChecked(0);
    }

    public void setChecked(int index, boolean checked) {
        this.checkWidget();
        this.getItemData((int)index).checked = checked;
        this.parent.redraw();
    }

    public boolean getChecked(int index) {
        this.checkWidget();
        this.handleVirtual();
        return this.getItemData((int)index).checked;
    }

    public void setGrayed(boolean grayed) {
        this.checkWidget();
        this.setGrayed(0, grayed);
        this.parent.redraw();
    }

    public boolean getGrayed() {
        this.checkWidget();
        return this.getGrayed(0);
    }

    public void setGrayed(int index, boolean grayed) {
        this.checkWidget();
        this.getItemData((int)index).grayed = grayed;
        this.parent.redraw();
    }

    public boolean getGrayed(int index) {
        this.checkWidget();
        this.handleVirtual();
        return this.getItemData((int)index).grayed;
    }

    public void setCheckable(int index, boolean checked) {
        this.checkWidget();
        this.getItemData((int)index).checkable = checked;
        this.parent.redraw();
    }

    public boolean getCheckable(int index) {
        this.checkWidget();
        this.handleVirtual();
        boolean result = this.getItemData((int)index).checkable;
        if (this.parent.getColumnCount() > 0 && !this.parent.getColumn(index).getCheckable()) {
            result = false;
        }
        return result;
    }

    public void setHeight(int height) {
        this.checkWidget();
        if (height < 1) {
            SWT.error((int)5);
        }
        if (this.customHeight != height) {
            this.customHeight = height;
            this.parent.hasDifferingHeights = true;
            this.parent.invalidateTopBottomIndex();
            this.parent.setScrollValuesObsolete();
        }
    }

    public int getHeight() {
        this.checkWidget();
        return this.customHeight != -1 ? this.customHeight : this.parent.getItemHeight();
    }

    public void pack() {
        this.checkWidget();
        this.parent.layoutCache.invalidateItemHeight();
    }

    public Rectangle getBounds(int columnIndex) {
        this.checkWidget();
        Rectangle result = new Rectangle(-1000, -1000, 0, 0);
        if (this.isVisible() && this.parent.isShown(this)) {
            Point origin = this.parent.getOrigin(this.parent.getColumn(columnIndex), this);
            Point cellSize = this.getCellSize(columnIndex);
            result = new Rectangle(origin.x, origin.y, cellSize.x, cellSize.y);
        }
        return result;
    }

    public <T> T getAdapter(Class<T> adapter) {
        Object result;
        if (adapter == IWidgetFontAdapter.class || adapter == IWidgetColorAdapter.class || adapter == IGridItemAdapter.class) {
            if (this.gridItemAdapter == null) {
                this.gridItemAdapter = new GridItemAdapter();
            }
            result = this.gridItemAdapter;
        } else {
            result = super.getAdapter(adapter);
        }
        return (T)result;
    }

    void setHasChildren(boolean hasChildren) {
        this.hasChildren = hasChildren;
    }

    boolean isVisible() {
        return this.visible;
    }

    void setVisible(boolean visible) {
        if (this.visible != visible) {
            this.visible = visible;
            if (visible) {
                this.parent.updateVisibleItems(1);
            } else {
                this.parent.updateVisibleItems(-1);
            }
            if (this.hasChildren) {
                boolean childrenVisible = visible;
                if (visible) {
                    childrenVisible = this.expanded;
                }
                for (GridItem item : this.children) {
                    item.setVisible(childrenVisible);
                }
            }
        }
    }

    private void newItem(GridItem item, int index) {
        this.setHasChildren(true);
        if (index == -1) {
            this.children.add(item);
        } else {
            this.children.add(index, item);
        }
    }

    private void remove(GridItem child) {
        this.children.remove((Object)child);
        this.hasChildren = this.children.size() > 0;
    }

    void columnAdded(int index) {
        if (this.parent.getColumnCount() > 1) {
            if (index == -1) {
                this.data.add(null);
            } else {
                this.data.add(index, null);
            }
            this.hasSetData = false;
        }
    }

    void columnRemoved(int index) {
        if (this.parent.getColumnCount() > 0 && this.data.size() > index) {
            this.data.remove(index);
        }
    }

    void clear(boolean allChildren) {
        int i = 0;
        while (i < this.parent.getColumnCount()) {
            Data itemData = this.getItemData(i);
            this.updateColumnImageCount(i, itemData.image, null);
            this.updateColumnTextCount(i, itemData.text, "");
            ++i;
        }
        this.init();
        this.defaultFont = null;
        this.defaultBackground = null;
        this.defaultForeground = null;
        this.hasSetData = false;
        if (allChildren) {
            i = this.children.size() - 1;
            while (i >= 0) {
                this.children.get(i).clear(true);
                --i;
            }
        }
    }

    int getPreferredWidth(int index) {
        int result = this.getIndentationWidth(index);
        result += this.getPaddingWidth(index);
        result += this.getCheckBoxWidth(index);
        result += this.getImageWidth(index);
        result += this.getSpacing(index);
        return result += this.getTextWidth(index);
    }

    private int getIndentationWidth(int index) {
        int result = 0;
        if (this.parent.isTreeColumn(index)) {
            result = (this.level + 1) * this.parent.getIndentationWidth();
        }
        return result;
    }

    private int getPaddingWidth(int index) {
        int result = this.parent.getCellPadding().width;
        if (this.parent.isTreeColumn(index)) {
            result -= this.parent.getCellPadding().x;
        }
        return result;
    }

    private int getCheckBoxWidth(int index) {
        return this.parent.getColumn(index).isCheck() ? this.parent.getCheckBoxImageOuterSize().x : 0;
    }

    private int getImageWidth(int index) {
        int result = 0;
        if (this.parent.hasColumnImages(index)) {
            result = this.parent.getItemImageSize().x;
        }
        return result;
    }

    private int getSpacing(int index) {
        int result = 0;
        String text = this.getItemData((int)index).text;
        if (this.parent.hasColumnImages(index) && text.length() > 0) {
            result = this.parent.getCellSpacing();
        }
        return result;
    }

    private int getTextWidth(int index) {
        int result = 0;
        String text = this.getItemData((int)index).text;
        if (text.length() > 0) {
            result += TextSizeUtil.stringExtent((Font)this.internalGetFont((int)index), (String)text).x;
        }
        return result;
    }

    int getTextOffset(int index) {
        int result = this.getIndentationWidth(index);
        if (!this.parent.isTreeColumn(index)) {
            result += this.parent.getCellPadding().x;
        }
        result += this.getCheckBoxWidth(index);
        result += this.getImageWidth(index);
        return result += this.getSpacing(index);
    }

    private Font internalGetFont(int index) {
        Font result = this.getItemData((int)index).font;
        if (result == null) {
            result = this.getFont();
        }
        return result;
    }

    protected Point getCellSize(int index) {
        int width = 0;
        int span = 0;
        int i = 0;
        while (i <= span && i < this.parent.getColumnCount() - index) {
            width += this.parent.getColumn(index + i).getWidth();
            ++i;
        }
        GridItem item = this;
        int itemIndex = this.parent.indexOf(item);
        int height = this.getHeight();
        span = 0;
        int i2 = 1;
        while (i2 <= span && i2 < this.parent.getItemCount() - itemIndex) {
            item = this.parent.getItem(itemIndex + i2);
            if (item.isVisible()) {
                height += item.getHeight();
            }
            ++i2;
        }
        return new Point(width, height);
    }

    private void init() {
        if (this.data == null) {
            this.data = new ArrayList();
        } else {
            this.data.clear();
        }
        this.data.add(null);
        int i = 1;
        while (i < this.parent.getColumnCount()) {
            this.data.add(null);
            ++i;
        }
    }

    private Data getItemData(int index) {
        if (this.data.get(index) == null) {
            this.data.set(index, new Data());
        }
        return this.data.get(index);
    }

    private void handleVirtual() {
        if ((this.getParent().getStyle() & 0x10000000) != 0 && !this.hasSetData) {
            this.hasSetData = true;
            Event event = new Event();
            event.item = this;
            event.index = this.parentItem == null ? this.getParent().indexOf(this) : this.parentItem.indexOf(this);
            this.getParent().notifyListeners(36, event);
        }
    }

    private boolean deselectChildren(GridItem item) {
        boolean flag = false;
        GridItem[] kids = item.getItems();
        int i = 0;
        while (i < kids.length) {
            if (this.parent.isSelected(kids[i])) {
                flag = true;
            }
            this.parent.deselect(this.parent.indexOf(kids[i]));
            if (this.deselectChildren(kids[i])) {
                flag = true;
            }
            ++i;
        }
        return flag;
    }

    private void updateColumnImageCount(int index, Image oldImage, Image newImage) {
        int delta = 0;
        if (oldImage == null && newImage != null) {
            delta = 1;
        } else if (oldImage != null && newImage == null) {
            delta = -1;
        }
        if (delta != 0 && index >= 0 && index < this.parent.getColumnCount()) {
            this.parent.getColumn((int)index).imageCount += delta;
        }
    }

    private void updateColumnTextCount(int index, String oldText, String newText) {
        int delta = 0;
        if (oldText.length() == 0 && newText.length() > 0) {
            delta = 1;
        } else if (oldText.length() > 0 && newText.length() == 0) {
            delta = -1;
        }
        if (delta != 0 && index >= 0 && index < this.parent.getColumnCount()) {
            this.parent.getColumn((int)index).textCount += delta;
        }
    }

    private static final class Data
    implements SerializableCompatibility {
        public Font font;
        public Color background;
        public Color foreground;
        public String text = "";
        public String tooltip;
        public Image image;
        public boolean checked;
        public boolean grayed;
        public boolean checkable = true;

        private Data() {
        }
    }

    private final class GridItemAdapter
    implements IGridItemAdapter,
    IWidgetFontAdapter,
    IWidgetColorAdapter {
        private GridItemAdapter() {
        }

        public boolean isParentDisposed() {
            Object itemParent = GridItem.this.parentItem == null ? GridItem.this.parent : GridItem.this.parentItem;
            return itemParent.isDisposed();
        }

        public Color getUserBackground() {
            return GridItem.this.defaultBackground;
        }

        public Color getUserForeground() {
            return GridItem.this.defaultForeground;
        }

        public Font getUserFont() {
            return GridItem.this.defaultFont;
        }

        public Color[] getCellBackgrounds() {
            int columnCount = Math.max(1, GridItem.this.getParent().getColumnCount());
            Color[] result = new Color[columnCount];
            int i = 0;
            while (i < columnCount) {
                result[i] = ((GridItem)GridItem.this).getItemData((int)i).background;
                ++i;
            }
            return result;
        }

        public Color[] getCellForegrounds() {
            int columnCount = Math.max(1, GridItem.this.getParent().getColumnCount());
            Color[] result = new Color[columnCount];
            int i = 0;
            while (i < columnCount) {
                result[i] = ((GridItem)GridItem.this).getItemData((int)i).foreground;
                ++i;
            }
            return result;
        }

        public Font[] getCellFonts() {
            int columnCount = Math.max(1, GridItem.this.getParent().getColumnCount());
            Font[] result = new Font[columnCount];
            int i = 0;
            while (i < columnCount) {
                result[i] = ((GridItem)GridItem.this).getItemData((int)i).font;
                ++i;
            }
            return result;
        }
    }
}

