/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.rap.swt.custom;

import org.eclipse.draw2d.rap.swt.custom.ViewFormLayout;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ViewForm
extends Composite {
    public int marginWidth = 0;
    public int marginHeight = 0;
    public int horizontalSpacing = 1;
    public int verticalSpacing = 1;
    public static RGB borderInsideRGB = new RGB(132, 130, 132);
    public static RGB borderMiddleRGB = new RGB(143, 141, 138);
    public static RGB borderOutsideRGB = new RGB(171, 168, 165);
    Control topLeft;
    Control topCenter;
    Control topRight;
    Control content;
    boolean separateTopCenter = false;
    boolean showBorder = false;
    int separator = -1;
    int borderTop = 0;
    int borderBottom = 0;
    int borderLeft = 0;
    int borderRight = 0;
    int highlight = 0;
    Point oldSize;
    Color selectionBackground;
    static final int OFFSCREEN = -200;
    static final int SELECTION_BACKGROUND = 25;

    public ViewForm(Composite parent, int style) {
        super(parent, ViewForm.checkStyle(style));
        super.setLayout((Layout)new ViewFormLayout());
        this.setBorderVisible((style & 0x800) != 0);
        this.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent event) {
            }

            public void controlResized(ControlEvent event) {
                ViewForm.this.onResize();
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                ViewForm.this.onDispose();
            }
        });
    }

    static int checkStyle(int style) {
        int mask = 0x2800000;
        return style & mask;
    }

    protected void checkSubclass() {
        String name = ((Object)((Object)this)).getClass().getName();
        String validName = ViewForm.class.getName();
        if (!validName.equals(name)) {
            SWT.error((int)43);
        }
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        int trimX = x - this.borderLeft - this.highlight;
        int trimY = y - this.borderTop - this.highlight;
        int trimWidth = width + this.borderLeft + this.borderRight + 2 * this.highlight;
        int trimHeight = height + this.borderTop + this.borderBottom + 2 * this.highlight;
        return new Rectangle(trimX, trimY, trimWidth, trimHeight);
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        Rectangle clientArea = super.getClientArea();
        clientArea.x += this.borderLeft;
        clientArea.y += this.borderTop;
        clientArea.width -= this.borderLeft + this.borderRight;
        clientArea.height -= this.borderTop + this.borderBottom;
        return clientArea;
    }

    public Control getContent() {
        this.checkWidget();
        return this.content;
    }

    public Control getTopCenter() {
        this.checkWidget();
        return this.topCenter;
    }

    public Control getTopLeft() {
        this.checkWidget();
        return this.topLeft;
    }

    public Control getTopRight() {
        this.checkWidget();
        return this.topRight;
    }

    void onDispose() {
        this.topLeft = null;
        this.topCenter = null;
        this.topRight = null;
        this.content = null;
        this.oldSize = null;
        this.selectionBackground = null;
    }

    void onResize() {
        Point size = this.getSize();
        if (this.oldSize != null && this.oldSize.x != 0 && this.oldSize.y != 0) {
            if (this.oldSize.x < size.x) {
                int cfr_ignored_0 = size.x - this.oldSize.x + this.borderRight + this.highlight;
            } else if (this.oldSize.x > size.x) {
                int cfr_ignored_1 = this.borderRight + this.highlight;
            }
            if (this.oldSize.y < size.y) {
                int cfr_ignored_2 = size.y - this.oldSize.y + this.borderBottom + this.highlight;
            }
            if (this.oldSize.y > size.y) {
                int cfr_ignored_3 = this.borderBottom + this.highlight;
            }
        }
        this.oldSize = size;
    }

    public void setContent(Control content) {
        this.checkWidget();
        if (content != null && content.getParent() != this) {
            SWT.error((int)5);
        }
        if (this.content != null && !this.content.isDisposed()) {
            this.content.setBounds(-200, -200, 0, 0);
        }
        this.content = content;
        this.layout(false);
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
    }

    void setSelectionBackground(Color color) {
        this.checkWidget();
        if (this.selectionBackground == color) {
            return;
        }
        if (color == null) {
            color = this.getDisplay().getSystemColor(25);
        }
        this.selectionBackground = color;
        this.redraw();
    }

    public void setTopCenter(Control topCenter) {
        this.checkWidget();
        if (topCenter != null && topCenter.getParent() != this) {
            SWT.error((int)5);
        }
        if (this.topCenter != null && !this.topCenter.isDisposed()) {
            Point size = this.topCenter.getSize();
            this.topCenter.setLocation(-200 - size.x, -200 - size.y);
        }
        this.topCenter = topCenter;
        this.layout(false);
    }

    public void setTopLeft(Control c) {
        this.checkWidget();
        if (c != null && c.getParent() != this) {
            SWT.error((int)5);
        }
        if (this.topLeft != null && !this.topLeft.isDisposed()) {
            Point size = this.topLeft.getSize();
            this.topLeft.setLocation(-200 - size.x, -200 - size.y);
        }
        this.topLeft = c;
        this.layout(false);
    }

    public void setTopRight(Control c) {
        this.checkWidget();
        if (c != null && c.getParent() != this) {
            SWT.error((int)5);
        }
        if (this.topRight != null && !this.topRight.isDisposed()) {
            Point size = this.topRight.getSize();
            this.topRight.setLocation(-200 - size.x, -200 - size.y);
        }
        this.topRight = c;
        this.layout(false);
    }

    public void setBorderVisible(boolean show) {
        this.checkWidget();
        if (this.showBorder == show) {
            return;
        }
        this.showBorder = show;
        if (this.showBorder) {
            this.borderBottom = 1;
            this.borderRight = 1;
            this.borderTop = 1;
            this.borderLeft = 1;
            if ((this.getStyle() & 0x800000) == 0) {
                this.highlight = 2;
            }
        } else {
            this.borderRight = 0;
            this.borderLeft = 0;
            this.borderTop = 0;
            this.borderBottom = 0;
            this.highlight = 0;
        }
        this.layout(false);
        this.redraw();
    }

    public void setTopCenterSeparate(boolean show) {
        this.checkWidget();
        this.separateTopCenter = show;
        this.layout(false);
    }
}

