/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.actions;

import java.util.Arrays;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.internal.GEFMessages;
import org.eclipse.gef.internal.ui.rulers.RulerEditPart;
import org.eclipse.gef.rulers.RulerProvider;
import org.eclipse.jface.action.Action;

public class CreateGuideAction
extends Action {
    private EditPartViewer viewer;

    public CreateGuideAction(EditPartViewer ruler) {
        super(GEFMessages.get().Create_Guide_Label);
        this.viewer = ruler;
        this.setToolTipText(GEFMessages.get().Create_Guide_Tooltip);
    }

    public void run() {
        RulerProvider provider = ((RulerEditPart)this.viewer.getRootEditPart().getChildren().get(0)).getRulerProvider();
        int[] positions = provider.getGuidePositions();
        Arrays.sort(positions);
        int index = 0;
        int newPosition = 6;
        int desiredDifference = 11;
        boolean found = positions.length > 0 && positions[0] > desiredDifference;
        while (index < positions.length - 1 && !found) {
            if (positions[index + 1] - positions[index] > desiredDifference) {
                newPosition += positions[index];
                found = true;
            }
            ++index;
        }
        if (!found && positions.length > 0) {
            newPosition += positions[positions.length - 1];
        }
        this.viewer.getEditDomain().getCommandStack().execute(provider.getCreateGuideCommand(newPosition));
        this.viewer.reveal((EditPart)this.viewer.getEditPartRegistry().get(provider.getGuideAt(newPosition)));
    }
}

