/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Tracker
extends Widget {
    Control parent;
    boolean tracking;
    boolean cancelled;
    boolean stippled;
    Rectangle[] rectangles = new Rectangle[0];
    Rectangle[] proportions = this.rectangles;
    Rectangle bounds;
    int resizeCursor;
    Cursor clientCursor;
    int cursorOrientation = 0;
    boolean inEvent = false;
    int hwndTransparent;
    int hwndOpaque;
    int oldTransparentProc;
    int oldOpaqueProc;
    int oldX;
    int oldY;
    Shell trackerShell;
    static final int STEPSIZE_SMALL = 1;
    static final int STEPSIZE_LARGE = 9;
    private DropTarget trackerDropTarget;
    private int internalStyle;

    public Tracker(Composite parent, int style) {
        super((Widget)parent, Tracker.checkStyle(style));
        this.parent = parent;
        this.internalStyle = this.getStyle();
    }

    public void addControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(11, (Listener)typedListener);
        this.addListener(10, (Listener)typedListener);
    }

    public void addKeyListener(KeyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(2, (Listener)typedListener);
        this.addListener(1, (Listener)typedListener);
    }

    Point adjustMoveCursor() {
        if (this.bounds == null) {
            return null;
        }
        int cfr_ignored_0 = this.bounds.x;
        int cfr_ignored_1 = this.bounds.width / 2;
        int cfr_ignored_2 = this.bounds.y;
        return new Point(0, 0);
    }

    Point adjustResizeCursor() {
        if (this.bounds == null) {
            return null;
        }
        if ((this.cursorOrientation & 0x4000) != 0) {
            int cfr_ignored_0 = this.bounds.x;
        } else if ((this.cursorOrientation & 0x20000) != 0) {
            int cfr_ignored_1 = this.bounds.x + this.bounds.width;
        } else {
            int cfr_ignored_2 = this.bounds.x + this.bounds.width / 2;
        }
        if ((this.cursorOrientation & 0x80) != 0) {
            int cfr_ignored_3 = this.bounds.y;
        } else if ((this.cursorOrientation & 0x400) != 0) {
            int cfr_ignored_4 = this.bounds.y + this.bounds.height;
        } else {
            int cfr_ignored_5 = this.bounds.y + this.bounds.height / 2;
        }
        if (this.clientCursor == null) {
            int newCursor;
            this.resizeCursor = newCursor = 0;
        }
        return new Point(0, 0);
    }

    static int checkStyle(int style) {
        if ((style & 0x24480) == 0) {
            style |= 0x24480;
        }
        return style;
    }

    public void close() {
        this.checkWidget();
        if (this.trackerShell != null) {
            this.trackerShell.dispose();
            this.trackerDropTarget.dispose();
            this.trackerShell = null;
            this.trackerDropTarget = null;
        }
        this.tracking = false;
    }

    Rectangle computeBounds() {
        if (this.rectangles.length == 0) {
            return null;
        }
        int xMin = this.rectangles[0].x;
        int yMin = this.rectangles[0].y;
        int xMax = this.rectangles[0].x + this.rectangles[0].width;
        int yMax = this.rectangles[0].y + this.rectangles[0].height;
        int i = 1;
        while (i < this.rectangles.length) {
            int rectBottom;
            int rectRight;
            if (this.rectangles[i].x < xMin) {
                xMin = this.rectangles[i].x;
            }
            if (this.rectangles[i].y < yMin) {
                yMin = this.rectangles[i].y;
            }
            if ((rectRight = this.rectangles[i].x + this.rectangles[i].width) > xMax) {
                xMax = rectRight;
            }
            if ((rectBottom = this.rectangles[i].y + this.rectangles[i].height) > yMax) {
                yMax = rectBottom;
            }
            ++i;
        }
        return new Rectangle(xMin, yMin, xMax - xMin, yMax - yMin);
    }

    Rectangle[] computeProportions(Rectangle[] rects) {
        Rectangle[] result = new Rectangle[rects.length];
        this.bounds = this.computeBounds();
        if (this.bounds != null) {
            int i = 0;
            while (i < rects.length) {
                int x = 0;
                int y = 0;
                int width = 0;
                int height = 0;
                if (this.bounds.width != 0) {
                    x = (rects[i].x - this.bounds.x) * 100 / this.bounds.width;
                    width = rects[i].width * 100 / this.bounds.width;
                } else {
                    width = 100;
                }
                if (this.bounds.height != 0) {
                    y = (rects[i].y - this.bounds.y) * 100 / this.bounds.height;
                    height = rects[i].height * 100 / this.bounds.height;
                } else {
                    height = 100;
                }
                result[i] = new Rectangle(x, y, width, height);
                ++i;
            }
        }
        return result;
    }

    void drawRectangles(Rectangle[] rects, boolean stippled) {
        if (this.trackerShell == null || this.trackerShell.isDisposed()) {
            this.trackerShell = new Shell(this.getDisplay(), 8);
            this.trackerShell.setAlpha(140);
            this.trackerDropTarget = new DropTarget((Control)this.trackerShell, 2);
            this.trackerDropTarget.setTransfer(new Transfer[]{TextTransfer.getInstance()});
            this.trackerShell.open();
        }
        int i = 0;
        while (i < rects.length) {
            Rectangle rect = rects[i];
            if (this.trackerShell != null && !this.trackerShell.isDisposed()) {
                this.trackerShell.setBounds(rect);
            }
            ++i;
        }
    }

    public Rectangle[] getRectangles() {
        this.checkWidget();
        Rectangle[] result = new Rectangle[this.rectangles.length];
        int i = 0;
        while (i < this.rectangles.length) {
            Rectangle current = this.rectangles[i];
            result[i] = new Rectangle(current.x, current.y, current.width, current.height);
            ++i;
        }
        return result;
    }

    public boolean getStippled() {
        this.checkWidget();
        return this.stippled;
    }

    void moveRectangles(int xChange, int yChange) {
        if (this.bounds == null) {
            return;
        }
        if (xChange < 0 && (this.style & 0x4000) == 0) {
            xChange = 0;
        }
        if (xChange > 0 && (this.style & 0x20000) == 0) {
            xChange = 0;
        }
        if (yChange < 0 && (this.style & 0x80) == 0) {
            yChange = 0;
        }
        if (yChange > 0 && (this.style & 0x400) == 0) {
            yChange = 0;
        }
        if (xChange == 0 && yChange == 0) {
            return;
        }
        this.bounds.x += xChange;
        this.bounds.y += yChange;
        int i = 0;
        while (i < this.rectangles.length) {
            this.rectangles[i].x += xChange;
            this.rectangles[i].y += yChange;
            ++i;
        }
    }

    public boolean open() {
        int hStyle;
        this.cancelled = false;
        this.tracking = true;
        int vStyle = this.internalStyle & 0x480;
        if (vStyle == 128 || vStyle == 1024) {
            this.cursorOrientation |= vStyle;
        }
        if ((hStyle = this.internalStyle & 0x24000) == 16384 || hStyle == 131072) {
            this.cursorOrientation |= hStyle;
        }
        this.update();
        try {
            long timeout = 0L;
            long refreshRate = 200L;
            this.tracking = false;
            while (this.tracking && !this.cancelled) {
                final Display display = this.getDisplay();
                if (display == null || display.isDisposed()) continue;
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        Tracker.this.drawRectangles(Tracker.this.rectangles, Tracker.this.stippled);
                        Event ev = new Event();
                        ev.display = display;
                        Tracker.this.notifyListeners(10, ev);
                    }
                });
                if ((timeout += refreshRate) >= 60000L) {
                    this.cancelled = true;
                }
                Thread.sleep(refreshRate);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Display display = this.getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                Tracker.this.close();
            }
        });
        return !this.cancelled;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.parent = null;
        this.proportions = null;
        this.rectangles = null;
        this.bounds = null;
    }

    public void removeControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
    }

    public void removeKeyListener(KeyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
    }

    void resizeRectangles(int xChange, int yChange) {
        Rectangle proportion;
        int i;
        if (this.bounds == null) {
            return;
        }
        if (xChange < 0 && (this.style & 0x4000) != 0 && (this.cursorOrientation & 0x20000) == 0) {
            this.cursorOrientation |= 0x4000;
        }
        if (xChange > 0 && (this.style & 0x20000) != 0 && (this.cursorOrientation & 0x4000) == 0) {
            this.cursorOrientation |= 0x20000;
        }
        if (yChange < 0 && (this.style & 0x80) != 0 && (this.cursorOrientation & 0x400) == 0) {
            this.cursorOrientation |= 0x80;
        }
        if (yChange > 0 && (this.style & 0x400) != 0 && (this.cursorOrientation & 0x80) == 0) {
            this.cursorOrientation |= 0x400;
        }
        if ((this.cursorOrientation & 0x4000) != 0) {
            if (xChange > this.bounds.width) {
                if ((this.style & 0x20000) == 0) {
                    return;
                }
                this.cursorOrientation |= 0x20000;
                this.cursorOrientation &= 0xFFFFBFFF;
                this.bounds.x += this.bounds.width;
                xChange -= this.bounds.width;
                this.bounds.width = 0;
                if (this.proportions.length > 1) {
                    i = 0;
                    while (i < this.proportions.length) {
                        proportion = this.proportions[i];
                        proportion.x = 100 - proportion.x - proportion.width;
                        ++i;
                    }
                }
            }
        } else if ((this.cursorOrientation & 0x20000) != 0 && this.bounds.width < -xChange) {
            if ((this.style & 0x4000) == 0) {
                return;
            }
            this.cursorOrientation |= 0x4000;
            this.cursorOrientation &= 0xFFFDFFFF;
            xChange += this.bounds.width;
            this.bounds.width = 0;
            if (this.proportions.length > 1) {
                i = 0;
                while (i < this.proportions.length) {
                    proportion = this.proportions[i];
                    proportion.x = 100 - proportion.x - proportion.width;
                    ++i;
                }
            }
        }
        if ((this.cursorOrientation & 0x80) != 0) {
            if (yChange > this.bounds.height) {
                if ((this.style & 0x400) == 0) {
                    return;
                }
                this.cursorOrientation |= 0x400;
                this.cursorOrientation &= 0xFFFFFF7F;
                this.bounds.y += this.bounds.height;
                yChange -= this.bounds.height;
                this.bounds.height = 0;
                if (this.proportions.length > 1) {
                    i = 0;
                    while (i < this.proportions.length) {
                        proportion = this.proportions[i];
                        proportion.y = 100 - proportion.y - proportion.height;
                        ++i;
                    }
                }
            }
        } else if ((this.cursorOrientation & 0x400) != 0 && this.bounds.height < -yChange) {
            if ((this.style & 0x80) == 0) {
                return;
            }
            this.cursorOrientation |= 0x80;
            this.cursorOrientation &= 0xFFFFFBFF;
            yChange += this.bounds.height;
            this.bounds.height = 0;
            if (this.proportions.length > 1) {
                i = 0;
                while (i < this.proportions.length) {
                    proportion = this.proportions[i];
                    proportion.y = 100 - proportion.y - proportion.height;
                    ++i;
                }
            }
        }
        if ((this.cursorOrientation & 0x4000) != 0) {
            this.bounds.x += xChange;
            this.bounds.width -= xChange;
        } else if ((this.cursorOrientation & 0x20000) != 0) {
            this.bounds.width += xChange;
        }
        if ((this.cursorOrientation & 0x80) != 0) {
            this.bounds.y += yChange;
            this.bounds.height -= yChange;
        } else if ((this.cursorOrientation & 0x400) != 0) {
            this.bounds.height += yChange;
        }
        Rectangle[] newRects = new Rectangle[this.rectangles.length];
        int i2 = 0;
        while (i2 < this.rectangles.length) {
            Rectangle proportion2 = this.proportions[i2];
            newRects[i2] = new Rectangle(proportion2.x * this.bounds.width / 100 + this.bounds.x, proportion2.y * this.bounds.height / 100 + this.bounds.y, proportion2.width * this.bounds.width / 100, proportion2.height * this.bounds.height / 100);
            ++i2;
        }
        this.rectangles = newRects;
    }

    public void setCursor(Cursor newCursor) {
        this.checkWidget();
        this.clientCursor = newCursor;
    }

    public void setRectangles(Rectangle[] rectangles) {
        this.checkWidget();
        if (rectangles == null) {
            this.error(4);
        }
        this.rectangles = new Rectangle[rectangles.length];
        int i = 0;
        while (i < rectangles.length) {
            Rectangle current = rectangles[i];
            if (current == null) {
                this.error(4);
            }
            this.rectangles[i] = new Rectangle(current.x, current.y, current.width, current.height);
            ++i;
        }
        this.proportions = this.computeProportions(rectangles);
    }

    public void setStippled(boolean stippled) {
        this.checkWidget();
        this.stippled = stippled;
    }

    void update() {
    }
}

