/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.text;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.text.FlowBorder;
import org.eclipse.draw2d.text.FlowBox;
import org.eclipse.draw2d.text.FlowFigure;
import org.eclipse.draw2d.text.FlowFigureLayout;
import org.eclipse.draw2d.text.InlineFlowLayout;

public class InlineFlow
extends FlowFigure {
    List fragments = new ArrayList(1);

    public boolean addLeadingWordRequirements(int[] width) {
        Iterator iter = this.getChildren().iterator();
        while (iter.hasNext()) {
            if (!((FlowFigure)iter.next()).addLeadingWordRequirements(width)) continue;
            return true;
        }
        return false;
    }

    public boolean containsPoint(int x, int y) {
        if (super.containsPoint(x, y)) {
            List frags = this.getFragments();
            int i = 0;
            while (i < frags.size()) {
                if (((FlowBox)frags.get(i)).containsPoint(x, y)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected FlowFigureLayout createDefaultFlowLayout() {
        return new InlineFlowLayout(this);
    }

    public List getFragments() {
        return this.fragments;
    }

    protected void paintBorder(Graphics graphics) {
        if (this.getBorder() != null) {
            FlowBorder fb = (FlowBorder)this.getBorder();
            List frags = this.getFragments();
            Rectangle where = new Rectangle();
            int i = 0;
            while (i < frags.size()) {
                FlowBox box = (FlowBox)frags.get(i);
                where.x = box.getX();
                where.width = box.getWidth();
                where.y = -box.getAscentWithBorder();
                where.height = box.getDescentWithBorder() - where.y;
                where.y += box.getBaseline();
                int sides = 0;
                if (i == 0) {
                    sides = 16384;
                }
                if (i == frags.size() - 1) {
                    sides |= 0x20000;
                }
                fb.paint(this, graphics, where, sides);
                ++i;
            }
            graphics.restoreState();
        }
        if (this.selectionStart != -1) {
            this.paintSelection(graphics);
        }
    }

    protected void paintSelection(Graphics graphics) {
        graphics.restoreState();
        graphics.setXORMode(true);
        graphics.setBackgroundColor(ColorConstants.white());
        List list = this.getFragments();
        int i = 0;
        while (i < list.size()) {
            FlowBox box = (FlowBox)list.get(i);
            int top = box.getLineRoot().getVisibleTop();
            int bottom = box.getLineRoot().getVisibleBottom();
            graphics.fillRectangle(box.getX(), top, box.getWidth(), bottom - top);
            ++i;
        }
    }

    public void postValidate() {
        int right;
        int left;
        List list = this.getFragments();
        int top = left = Integer.MAX_VALUE;
        int bottom = right = Integer.MIN_VALUE;
        int i = 0;
        while (i < list.size()) {
            FlowBox box = (FlowBox)list.get(i);
            left = Math.min(left, box.getX());
            right = Math.max(right, box.getX() + box.getWidth());
            top = Math.min(top, box.getLineRoot().getVisibleTop());
            bottom = Math.max(bottom, box.getLineRoot().getVisibleBottom());
            ++i;
        }
        this.setBounds(new Rectangle(left, top, right - left, bottom - top));
        this.repaint();
        list = this.getChildren();
        i = 0;
        while (i < list.size()) {
            ((FlowFigure)list.get(i)).postValidate();
            ++i;
        }
    }

    public void setBorder(Border border) {
        if (border != null && !(border instanceof FlowBorder)) {
            throw new RuntimeException("Border must be an instance of FlowBorder");
        }
        super.setBorder(border);
    }
}

