/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.presentation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.util.Geometry;
import org.eclipse.rap.demo.presentation.Images;
import org.eclipse.rap.demo.presentation.StackPopup;
import org.eclipse.rwt.graphics.Graphics;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.internal.dnd.DragUtil;
import org.eclipse.ui.presentations.IPresentablePart;
import org.eclipse.ui.presentations.IStackPresentationSite;
import org.eclipse.ui.presentations.StackDropResult;
import org.eclipse.ui.presentations.StackPresentation;

class StackPresentationImpl
extends StackPresentation {
    private static final int TITLE_HEIGHT = 30;
    private List presentableParts = new ArrayList();
    private Control control;
    private IPresentablePart current;
    private Label content;
    private Button head;

    protected StackPresentationImpl(IStackPresentationSite stackSite, Composite parent) {
        super(stackSite);
        Composite background = new Composite(parent, 0);
        background.setBackgroundMode(2);
        background.setLayout((Layout)new FormLayout());
        this.content = new Label(background, 0);
        this.content.setBackground(Graphics.getColor((int)255, (int)255, (int)255));
        FormData fdContent = this.createFormData((Control)this.content);
        fdContent.top = new FormAttachment(0, 30);
        fdContent.left = new FormAttachment(0, 2);
        fdContent.right = new FormAttachment(100, -2);
        fdContent.bottom = new FormAttachment(100, -2);
        this.content.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent evt) {
                StackPresentationImpl.this.layout();
            }
        });
        this.head = new Button(background, 0x804008);
        FontData fontData = this.head.getFont().getFontData()[0];
        this.head.setFont(Graphics.getFont((String)fontData.getName(), (int)(fontData.getHeight() + 2), (int)fontData.getStyle()));
        FormData fdHead = this.createFormData((Control)this.head);
        fdHead.top = new FormAttachment(0, -1);
        fdHead.left = new FormAttachment(0, -1);
        fdHead.height = 31;
        fdHead.right = new FormAttachment(100, 1);
        this.head.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                Object[] parts = StackPresentationImpl.this.presentableParts.toArray();
                SelectionAdapter listener = new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        TableItem item = (TableItem)evt.item;
                        IPresentablePart part = (IPresentablePart)item.getData();
                        StackPresentationImpl.this.getSite().selectPart(part);
                        Control control = (Control)evt.widget;
                        control.getShell().close();
                    }
                };
                StackPopup popupDialog = new StackPopup(StackPresentationImpl.this.head.getShell(), (Control)StackPresentationImpl.this.content, parts, (SelectionListener)listener);
                popupDialog.open();
            }
        });
        Label topLeft = this.createImageLabel(background, Images.IMG_TOP_LEFT);
        FormData fdTopLeft = this.createFormData((Control)topLeft);
        fdTopLeft.left = new FormAttachment(0, 0);
        fdTopLeft.top = new FormAttachment(0, 0);
        Label topRight = this.createImageLabel(background, Images.IMG_TOP_RIGHT);
        FormData fdTopRight = this.createFormData((Control)topRight);
        fdTopRight.top = new FormAttachment(0, 0);
        fdTopRight.left = new FormAttachment(100, -topRight.getSize().x);
        Label topCenter = new Label(background, 0);
        topCenter.setBackgroundImage(Images.IMG_TOP_CENTER);
        FormData fdTopCenter = this.createFormData((Control)topCenter);
        fdTopCenter.top = new FormAttachment(0, 0);
        fdTopCenter.left = new FormAttachment((Control)topLeft);
        fdTopCenter.right = new FormAttachment((Control)topRight);
        fdTopCenter.height = Images.IMG_TOP_CENTER.getBounds().height;
        Label middleLeft = new Label(background, 0);
        middleLeft.setBackgroundImage(Images.IMG_MIDDLE_LEFT);
        FormData fdMiddleLeft = this.createFormData((Control)middleLeft);
        fdMiddleLeft.top = new FormAttachment((Control)topLeft);
        fdMiddleLeft.left = new FormAttachment(0, 0);
        fdMiddleLeft.width = Images.IMG_MIDDLE_LEFT.getBounds().width;
        fdMiddleLeft.bottom = new FormAttachment(100, -Images.IMG_BOTTOM_LEFT.getBounds().height);
        Label middleRight = new Label(background, 0);
        middleRight.setBackgroundImage(Images.IMG_MIDDLE_RIGHT);
        FormData fdMiddleRight = this.createFormData((Control)middleRight);
        fdMiddleRight.top = new FormAttachment((Control)topRight);
        fdMiddleRight.left = new FormAttachment(100, -Images.IMG_MIDDLE_RIGHT.getBounds().width);
        fdMiddleRight.width = Images.IMG_MIDDLE_RIGHT.getBounds().width;
        int height = -Images.IMG_BOTTOM_RIGHT.getBounds().height;
        fdMiddleRight.bottom = new FormAttachment(100, height);
        Label bottomLeft = this.createImageLabel(background, Images.IMG_BOTTOM_LEFT);
        FormData fdBottomLeft = this.createFormData((Control)bottomLeft);
        fdBottomLeft.left = new FormAttachment(0, 0);
        fdBottomLeft.top = new FormAttachment((Control)middleLeft);
        Label bottomRight = this.createImageLabel(background, Images.IMG_BOTTOM_RIGHT);
        FormData fdBottomRight = this.createFormData((Control)bottomRight);
        fdBottomRight.top = new FormAttachment((Control)middleRight);
        fdBottomRight.left = new FormAttachment(100, -bottomRight.getSize().x);
        Label bottomCenter = new Label(background, 0);
        bottomCenter.setBackgroundImage(Images.IMG_BOTTOM_CENTER);
        FormData fdBottomCenter = this.createFormData((Control)bottomCenter);
        fdBottomCenter.bottom = new FormAttachment(100, 0);
        fdBottomCenter.left = new FormAttachment((Control)bottomLeft);
        fdBottomCenter.right = new FormAttachment((Control)bottomRight);
        fdBottomCenter.height = Images.IMG_BOTTOM_CENTER.getBounds().height;
        Label middleCenter = new Label(background, 0);
        middleCenter.setBackgroundImage(Images.IMG_MIDDLE_CENTER);
        FormData fdMiddleCenter = this.createFormData((Control)middleCenter);
        fdMiddleCenter.top = new FormAttachment((Control)topCenter);
        fdMiddleCenter.left = new FormAttachment((Control)middleLeft);
        fdMiddleCenter.right = new FormAttachment((Control)middleRight);
        fdMiddleCenter.bottom = new FormAttachment((Control)bottomCenter);
        this.control = background;
    }

    private FormData createFormData(Control control) {
        FormData result = new FormData();
        control.setLayoutData((Object)result);
        return result;
    }

    private Label createImageLabel(Composite background, Image cornerImage) {
        Label result = new Label(background, 0);
        result.setImage(cornerImage);
        Rectangle boundsLeft = cornerImage.getBounds();
        result.setSize(boundsLeft.width, boundsLeft.height);
        return result;
    }

    public void addPart(IPresentablePart newPart, Object cookie) {
        this.presentableParts.add(newPart);
    }

    public void dispose() {
    }

    public Control getControl() {
        return this.control;
    }

    public Control[] getTabList(IPresentablePart part) {
        return null;
    }

    public void removePart(IPresentablePart oldPart) {
        this.presentableParts.remove(oldPart);
    }

    public void selectPart(IPresentablePart toSelect) {
        if (toSelect != null) {
            toSelect.setVisible(true);
            this.head.setImage(toSelect.getTitleImage());
            this.head.setText(toSelect.getTitle());
        } else {
            this.head.setText("");
            this.head.setImage(null);
        }
        if (this.current != null) {
            this.current.setVisible(false);
        }
        this.current = toSelect;
        this.layout();
    }

    protected void layout() {
        if (this.current != null) {
            Rectangle clientArea = DragUtil.getDisplayBounds((Control)this.content);
            Rectangle bounds = Geometry.toControl((Control)this.current.getControl().getParent(), (Rectangle)clientArea);
            this.current.setBounds(bounds);
        }
    }

    public void setActive(int newState) {
    }

    public void setBounds(Rectangle bounds) {
        this.control.setBounds(bounds.x + 4, bounds.y + 4, bounds.width - 8, bounds.height - 8);
    }

    public void setState(int state) {
    }

    public void setVisible(boolean isVisible) {
    }

    public void showPaneMenu() {
    }

    public void showSystemMenu() {
    }

    public StackDropResult dragOver(Control currentControl, Point location) {
        return null;
    }
}

