/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.events;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.rwt.internal.events.IEventAdapter;
import org.eclipse.rwt.internal.util.ParamCheck;
import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.internal.SerializableCompatibility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventAdapter
implements IEventAdapter,
SerializableCompatibility {
    private static final EventListener[] EMPTY_LISTENERS = new SWTEventListener[0];
    private Map<Class, Set<EventListener>> listenerSets;

    @Override
    public EventListener[] getListener(Class listenerType) {
        ParamCheck.notNull(listenerType, "listenerType");
        Set<EventListener> listenerSet = this.getListenerSet(listenerType);
        int size = listenerSet.size();
        EventListener[] result = (EventListener[])Array.newInstance(listenerType, size);
        listenerSet.toArray(result);
        return result;
    }

    @Override
    public boolean hasListener(Class listenerType) {
        ParamCheck.notNull(listenerType, "listenerType");
        EventAdapter.checkListenerType(listenerType);
        boolean result = false;
        if (this.listenerSets != null && this.listenerSets.containsKey(listenerType)) {
            result = !this.getListenerSet(listenerType).isEmpty();
        }
        return result;
    }

    @Override
    public void addListener(Class listenerType, EventListener listener) {
        if (listenerType == null) {
            SWT.error(4);
        }
        if (listener == null) {
            SWT.error(4);
        }
        EventAdapter.checkTypeCompatibility(listenerType, listener);
        this.getListenerSet(listenerType).add(listener);
    }

    @Override
    public void removeListener(Class listenerType, EventListener listener) {
        if (listenerType == null) {
            SWT.error(4);
        }
        if (listener == null) {
            SWT.error(4);
        }
        EventAdapter.checkTypeCompatibility(listenerType, listener);
        if (this.hasListener(listenerType)) {
            this.getListenerSet(listenerType).remove(listener);
        }
    }

    private Set<EventListener> getListenerSet(Class listenerType) {
        EventAdapter.checkListenerType(listenerType);
        if (this.listenerSets == null) {
            this.listenerSets = new HashMap<Class, Set<EventListener>>(4, 1.0f);
        }
        if (!this.listenerSets.containsKey(listenerType)) {
            this.listenerSets.put(listenerType, new ListenerSet());
        }
        return this.listenerSets.get(listenerType);
    }

    @Override
    public EventListener[] getListeners() {
        EventListener[] result = EMPTY_LISTENERS;
        if (this.listenerSets != null) {
            HashSet<EventListener> buffer = new HashSet<EventListener>();
            Object[] sets = this.listenerSets.values().toArray();
            int i = 0;
            while (i < sets.length) {
                Set set = (Set)sets[i];
                Object[] listeners = set.toArray();
                int j = 0;
                while (j < listeners.length) {
                    buffer.add((EventListener)listeners[j]);
                    ++j;
                }
                ++i;
            }
            result = buffer.toArray(new SWTEventListener[buffer.size()]);
        }
        return result;
    }

    private static void checkTypeCompatibility(Class<?> listenerType, Object listener) {
        if (!listenerType.isAssignableFrom(listener.getClass())) {
            String msg = "Parameter 'listener' must be of type '" + listenerType.getName() + "'.";
            throw new IllegalArgumentException(msg);
        }
    }

    private static void checkListenerType(Class listenerType) {
        if (!EventListener.class.isAssignableFrom(listenerType)) {
            String msg = "Parameter 'listenerType' must implement '" + EventListener.class.getName() + "'";
            throw new IllegalArgumentException(msg);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ListenerSet
    implements Set<EventListener>,
    SerializableCompatibility {
        private final List<EventListener> list = new ArrayList<EventListener>(3);

        private ListenerSet() {
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public void clear() {
            this.list.clear();
        }

        @Override
        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        @Override
        public Object[] toArray() {
            return this.list.toArray();
        }

        @Override
        public boolean add(EventListener o) {
            boolean result;
            boolean bl = result = !this.contains(o);
            if (result) {
                this.list.add(o);
            }
            return result;
        }

        @Override
        public boolean contains(Object o) {
            return this.list.contains(o);
        }

        @Override
        public boolean remove(Object o) {
            return this.list.remove(o);
        }

        @Override
        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<EventListener> iterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.list.toArray(a);
        }
    }
}

