/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.tools.launch.rwt.internal.tab;

import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.rap.tools.launch.rwt.internal.config.RWTLaunchConfig;
import org.eclipse.rap.tools.launch.rwt.internal.tab.RWTLaunchTab;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class VMArgumentsSection
extends RWTLaunchTab {
    private Text txtVMArguments;
    private Button btnVariables;

    public void createControl(Composite parent) {
        Group group = new Group(parent, 0);
        this.setControl((Control)group);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)VMArgumentsSection.newFillGridData());
        group.setText("VM arguments");
        int style = 2626;
        this.txtVMArguments = new Text((Composite)group, style);
        this.txtVMArguments.addTraverseListener((TraverseListener)new VMArgumentsTraverseListener());
        this.txtVMArguments.setLayoutData((Object)VMArgumentsSection.newFillGridData());
        this.txtVMArguments.addModifyListener((ModifyListener)new VMArgumentsModifyListener());
        this.btnVariables = this.createPushButton((Composite)group, "Variable&s...", null);
        this.btnVariables.setLayoutData((Object)new GridData(0x1000008, -1, false, false));
        this.btnVariables.addSelectionListener((SelectionListener)new VariablesSelectionListener());
    }

    @Override
    public void initializeFrom(RWTLaunchConfig launchCOnfig) {
        this.txtVMArguments.setText(launchCOnfig.getVMArguments());
    }

    @Override
    public void performApply(RWTLaunchConfig launchConfig) {
        launchConfig.setVMArguments(this.txtVMArguments.getText().trim());
    }

    public String getName() {
        return "VM arguments";
    }

    private static GridData newFillGridData() {
        return new GridData(4, 4, true, true);
    }

    private void selectVariable() {
        StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(this.getShell());
        dialog.open();
        String variable = dialog.getVariableExpression();
        if (variable != null) {
            this.txtVMArguments.insert(variable);
        }
        dialog.close();
    }

    private final class VMArgumentsModifyListener
    implements ModifyListener {
        private VMArgumentsModifyListener() {
        }

        public void modifyText(ModifyEvent event) {
            VMArgumentsSection.this.scheduleUpdateJob();
        }
    }

    private final class VMArgumentsTraverseListener
    implements TraverseListener {
        private VMArgumentsTraverseListener() {
        }

        public void keyTraversed(TraverseEvent event) {
            switch (event.detail) {
                case 2: 
                case 256: 
                case 512: {
                    event.doit = true;
                    break;
                }
                case 4: 
                case 8: 
                case 16: {
                    if ((VMArgumentsSection.this.txtVMArguments.getStyle() & 4) != 0) {
                        event.doit = true;
                        break;
                    }
                    if (VMArgumentsSection.this.txtVMArguments.isEnabled() && (event.stateMask & SWT.MODIFIER_MASK) == 0) break;
                    event.doit = true;
                }
            }
        }
    }

    private final class VariablesSelectionListener
    extends SelectionAdapter {
        private VariablesSelectionListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            VMArgumentsSection.this.selectVariable();
        }
    }
}

