/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.code;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.scout.sdk.core.model.api.ITypeParameter;
import org.eclipse.scout.sdk.core.s.util.ScoutTier;
import org.eclipse.scout.sdk.core.util.SdkException;
import org.eclipse.scout.sdk.s2e.environment.EclipseEnvironment;
import org.eclipse.scout.sdk.s2e.ui.fields.FieldToolkit;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.content.StrictHierarchyTypeContentProvider;
import org.eclipse.scout.sdk.s2e.ui.internal.code.CodeTypeNewWizard;
import org.eclipse.scout.sdk.s2e.ui.util.PackageContainer;
import org.eclipse.scout.sdk.s2e.ui.wizard.CompilationUnitNewWizardPage;
import org.eclipse.scout.sdk.s2e.util.JdtUtils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.PlatformUI;

public class CodeTypeNewWizardPage
extends CompilationUnitNewWizardPage {
    private final ProposalTextField[] m_typeArgFields;
    private static final int NUM_ARG_FIELDS = 3;
    private EclipseEnvironment m_provider;

    public CodeTypeNewWizardPage(PackageContainer packageContainer) {
        super(CodeTypeNewWizardPage.class.getName(), packageContainer, "CodeType", "org.eclipse.scout.rt.shared.services.common.code.ICodeType", "org.eclipse.scout.rt.shared.services.common.code.AbstractCodeType", ScoutTier.Shared);
        this.setTitle("Create a new CodeType");
        this.setDescription(this.getTitle());
        this.setIcuGroupName("New CodeType Details");
        this.m_typeArgFields = new ProposalTextField[3];
    }

    @Override
    protected void createContent(Composite parent) {
        super.createContent(parent);
        this.m_provider = EclipseEnvironment.createUnsafe(env -> this.getControl().addDisposeListener(e -> env.close()));
        this.createArgumentsGroup(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.scout.sdk.s2e.ui.scout_wizard_code-type_page_context");
    }

    protected void createArgumentsGroup(Composite p) {
        Group parent = FieldToolkit.createGroupBox(p, "Type Arguments");
        GridDataFactory.defaultsFor((Control)parent).align(4, 0x1000000).grab(true, false).applyTo((Control)parent);
        GridLayoutFactory.swtDefaults().applyTo((Composite)parent);
        int i = 0;
        while (i < 3) {
            this.m_typeArgFields[i] = FieldToolkit.createTypeProposalField((Composite)parent, CodeTypeNewWizardPage.getTypeArgLabel(i), this.getJavaProject(), this.getLabelWidth());
            this.m_typeArgFields[i].addProposalListener(proposal -> this.pingStateChanging());
            GridDataFactory.defaultsFor((Control)this.m_typeArgFields[i]).align(4, 0x1000000).grab(true, false).applyTo((Control)this.m_typeArgFields[i]);
            ++i;
        }
        this.syncTypeArgFieldsToSuperType();
    }

    protected static String getTypeArgLabel(int index) {
        switch (index) {
            case 0: {
                return "First Argument";
            }
            case 1: {
                return "Second Argument";
            }
            case 2: {
                return "Third Argument";
            }
        }
        throw new SdkException("unsupported index: " + index, new Object[0]);
    }

    @Override
    protected void handleJavaProjectChanged() {
        super.handleJavaProjectChanged();
        if (!this.isControlCreated()) {
            return;
        }
        ProposalTextField[] proposalTextFieldArray = this.m_typeArgFields;
        int n = this.m_typeArgFields.length;
        int n2 = 0;
        while (n2 < n) {
            ProposalTextField field = proposalTextFieldArray[n2];
            ((StrictHierarchyTypeContentProvider)field.getContentProvider()).setJavaProject(this.getJavaProject());
            ++n2;
        }
    }

    @Override
    protected void handleSuperTypeChanged() {
        super.handleSuperTypeChanged();
        if (this.isControlCreated()) {
            this.syncTypeArgFieldsToSuperType();
        }
    }

    protected void syncTypeArgFieldsToSuperType() {
        IType superType = this.getSuperType();
        if (!JdtUtils.exists((IJavaElement)superType)) {
            ProposalTextField[] proposalTextFieldArray = this.m_typeArgFields;
            int n = this.m_typeArgFields.length;
            int n2 = 0;
            while (n2 < n) {
                ProposalTextField field = proposalTextFieldArray[n2];
                field.setEnabled(false);
                ++n2;
            }
        } else {
            List typeParameters = this.m_provider.toScoutType(superType).typeParameters().collect(Collectors.toList());
            int i = 0;
            while (i < 3) {
                boolean typeParamAvailable = typeParameters.size() > i;
                this.m_typeArgFields[i].setEnabled(typeParamAvailable);
                if (typeParamAvailable) {
                    List bounds = ((ITypeParameter)typeParameters.get(i)).bounds().collect(Collectors.toList());
                    StrictHierarchyTypeContentProvider typeContentProvider = (StrictHierarchyTypeContentProvider)this.m_typeArgFields[i].getContentProvider();
                    if (bounds.isEmpty()) {
                        typeContentProvider.setBaseClassFqn(null);
                    } else {
                        typeContentProvider.setBaseClassFqn(((org.eclipse.scout.sdk.core.model.api.IType)bounds.get(0)).name());
                    }
                }
                ++i;
            }
        }
    }

    public String getSuperClassReference() {
        IType superType = this.getSuperType();
        StringBuilder superTypeBuilder = new StringBuilder(superType.getFullyQualifiedName());
        try {
            int numParams = superType.getTypeParameters().length;
            if (numParams > 0) {
                superTypeBuilder.append('<');
                int i = 0;
                while (i < numParams) {
                    String param;
                    if (i != 0) {
                        superTypeBuilder.append(',');
                    }
                    boolean appendCodeGeneric = false;
                    if (i < 3) {
                        IType selectedProposal = (IType)this.m_typeArgFields[i].getSelectedProposal();
                        appendCodeGeneric = selectedProposal.getTypeParameters().length > 0 && JdtUtils.hierarchyContains((ITypeHierarchy)selectedProposal.newSupertypeHierarchy(null), (String)"org.eclipse.scout.rt.shared.services.common.code.ICode");
                        param = selectedProposal.getFullyQualifiedName();
                    } else {
                        param = Object.class.getName();
                    }
                    superTypeBuilder.append(param);
                    if (appendCodeGeneric) {
                        superTypeBuilder.append('<');
                        superTypeBuilder.append(this.getCodeIdDataType());
                        superTypeBuilder.append('>');
                    }
                    ++i;
                }
                superTypeBuilder.append('>');
            }
        }
        catch (JavaModelException e) {
            throw new SdkException((Throwable)e);
        }
        return superTypeBuilder.toString();
    }

    public String getCodeIdDataType() {
        return this.getCodeTypeTypeArgDatatype(1);
    }

    public String getCodeTypeIdDataType() {
        return this.getCodeTypeTypeArgDatatype(0);
    }

    protected String getCodeTypeTypeArgDatatype(int typeParamIndex) {
        org.eclipse.scout.sdk.core.model.api.IType superType = this.m_provider.toScoutType(this.getSuperType());
        org.eclipse.scout.sdk.core.model.api.IType codeTypeIdArg = (org.eclipse.scout.sdk.core.model.api.IType)((org.eclipse.scout.sdk.core.model.api.IType)superType.superTypes().withSelf(false).withName("org.eclipse.scout.rt.shared.services.common.code.ICodeType").first().get()).typeArguments().skip(typeParamIndex).findAny().get();
        if (codeTypeIdArg.isParameterType()) {
            List typeParameters = superType.typeParameters().collect(Collectors.toList());
            int index = -1;
            int i = 0;
            while (i < typeParameters.size()) {
                if (((ITypeParameter)typeParameters.get(i)).elementName().equals(codeTypeIdArg.elementName())) {
                    index = i;
                    break;
                }
                ++i;
            }
            IType result = null;
            if (index >= 0 && index < 3) {
                result = (IType)this.m_typeArgFields[index].getSelectedProposal();
            }
            if (result != null) {
                return result.getFullyQualifiedName();
            }
        } else {
            return codeTypeIdArg.reference();
        }
        return Object.class.getName();
    }

    public CodeTypeNewWizard getWizard() {
        return (CodeTypeNewWizard)super.getWizard();
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        super.validatePage(multiStatus);
        multiStatus.add(this.getStatusTypeArgFields());
    }

    protected IStatus getStatusTypeArgFields() {
        if (this.isControlCreated()) {
            ProposalTextField[] proposalTextFieldArray = this.m_typeArgFields;
            int n = this.m_typeArgFields.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElement selected;
                ProposalTextField field = proposalTextFieldArray[n2];
                if (field.isEnabled() && !JdtUtils.exists((IJavaElement)(selected = (IJavaElement)field.getSelectedProposal()))) {
                    return new Status(4, "org.eclipse.scout.sdk.s2e", "Please choose the type arguments.");
                }
                ++n2;
            }
        }
        return Status.OK_STATUS;
    }
}

