/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.template.ast;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ast.AstNodeFactory;

public abstract class AbstractAstBuilder<INSTANCE extends AbstractAstBuilder<INSTANCE>> {
    private final AstNodeFactory m_owner;
    private final Set<Modifier.ModifierKeyword> m_modifiers;
    private final INSTANCE m_return;
    private boolean m_createLinks;
    private TypeDeclaration m_declaringType;

    protected AbstractAstBuilder(AstNodeFactory owner) {
        this.m_owner = (AstNodeFactory)Ensure.notNull((Object)owner);
        this.m_modifiers = new LinkedHashSet<Modifier.ModifierKeyword>();
        this.m_return = this;
        this.m_createLinks = true;
    }

    public INSTANCE withCreateLinks(boolean createLinks) {
        this.m_createLinks = createLinks;
        return this.m_return;
    }

    public INSTANCE withModifiers(Modifier.ModifierKeyword ... keywords) {
        if (keywords == null || keywords.length < 1) {
            return (INSTANCE)this;
        }
        Collections.addAll(this.m_modifiers, keywords);
        return this.m_return;
    }

    public INSTANCE in(TypeDeclaration declaringType) {
        this.m_declaringType = declaringType;
        return this.m_return;
    }

    public AstNodeFactory getFactory() {
        return this.m_owner;
    }

    public boolean isCreateLinks() {
        return this.m_createLinks;
    }

    protected Set<Modifier.ModifierKeyword> getModifiers() {
        return Collections.unmodifiableSet(this.m_modifiers);
    }

    protected TypeDeclaration getDeclaringType() {
        return this.m_declaringType;
    }

    public abstract INSTANCE insert();
}

