/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.nls;

import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.sdk.core.s.nls.ITranslationStore;
import org.eclipse.scout.sdk.core.s.nls.TranslationStoreStack;
import org.eclipse.scout.sdk.core.s.nls.TranslationValidator;

public final class TranslationInputValidator {
    private TranslationInputValidator() {
    }

    public static IStatus validateDefaultTranslation(CharSequence defaultTranslation) {
        return TranslationInputValidator.toStatus(TranslationValidator.validateDefaultText((CharSequence)defaultTranslation));
    }

    public static IStatus validateNlsKey(TranslationStoreStack project, ITranslationStore target, String key) {
        return TranslationInputValidator.validateNlsKey(project, target, key, null);
    }

    public static IStatus validateNlsKey(TranslationStoreStack project, ITranslationStore target, String key, Collection<String> acceptedKeys) {
        return TranslationInputValidator.toStatus(TranslationValidator.validateKey((TranslationStoreStack)project, (ITranslationStore)target, (String)key, acceptedKeys));
    }

    public static IStatus validateTranslationStore(ITranslationStore store) {
        if (store == null) {
            return new Status(4, "org.eclipse.scout.sdk.s2e.ui", -1, "Please choose a service.", null);
        }
        if (!store.isEditable()) {
            return new Status(4, "org.eclipse.scout.sdk.s2e.ui", -1, "The selected service is read-only.", null);
        }
        return Status.OK_STATUS;
    }

    private static IStatus toStatus(int validationResult) {
        if (validationResult == 0) {
            return Status.OK_STATUS;
        }
        int severity = 4;
        if (!TranslationValidator.isForbidden((int)validationResult)) {
            severity = 2;
        }
        return new Status(severity, "org.eclipse.scout.sdk.s2e.ui", validationResult, TranslationInputValidator.getValidationText(validationResult), null);
    }

    private static String getValidationText(int validationResult) {
        switch (validationResult) {
            case 0: {
                return "";
            }
            case 1: 
            case 2: {
                return "The default text must be set.";
            }
            case 3: {
                return "Please specify a key.";
            }
            case 4: {
                return "This key already exists!";
            }
            case 5: {
                return "The key overrides an inherited entry.";
            }
            case 6: {
                return "The key is overridden by another entry.";
            }
            case 7: {
                return "The key overrides an inherited entry and is itself overridden by another entry.";
            }
        }
        return "The key name is not valid.";
    }
}

