/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.jaxws.editor;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.s.apidef.IScoutAnnotationApi;
import org.eclipse.scout.sdk.core.s.apidef.IScoutApi;
import org.eclipse.scout.sdk.core.s.apidef.IScoutVariousApi;
import org.eclipse.scout.sdk.core.s.jaxws.AbstractWebServiceNewOperation;
import org.eclipse.scout.sdk.core.s.jaxws.JaxWsUtils;
import org.eclipse.scout.sdk.core.s.jaxws.ParsedWsdl;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.JavaTypes;
import org.eclipse.scout.sdk.core.util.SdkException;
import org.eclipse.scout.sdk.core.util.Strings;
import org.eclipse.scout.sdk.core.util.Xml;
import org.eclipse.scout.sdk.s2e.util.ApiHelper;
import org.eclipse.scout.sdk.s2e.util.JdtUtils;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WebServiceFormPageInput
implements Comparable<WebServiceFormPageInput> {
    private final IJavaProject m_javaProject;
    private final int m_hash;
    private final String m_displayName;
    private final Map<IType, ITypeHierarchy> m_superHierarchyCache;
    private final Map<IType, ITypeHierarchy> m_hierarchyCache;
    private final Path m_wsdl;
    private final List<Path> m_bindings;
    private final Map<IType, Set<IType>> m_portTypes;
    private final Map<IType, QName> m_portTypeNamesInWsdl;
    private final Map<IType, QName> m_webServices;
    private final List<Path> m_jaxwsBindingFiles;
    private final IScoutApi m_scoutApi;
    private ParsedWsdl m_servicesFromWsdl;
    private final Map<IType, IType> m_webServiceClients;
    private final Map<IType, IType> m_entryPoints;
    private final Map<IType, IType> m_entryPointDefinitions;
    private final Map<IType, IType> m_serviceImplementations;
    private final Map<IType, String> m_entryPointNameFromDefinitions;
    private final Map<IType, String> m_entryPointPackageFromDefinitions;
    private final Map<IType, IType> m_authMethodFromDefinitions;
    private final Map<IType, IType> m_authVerifierFromDefinitions;
    private final Map<IType, List<IType>> m_handlersFromDefinitions;

    public WebServiceFormPageInput(Path wsdl, IJavaProject javaProject, IScoutApi api) {
        this.m_wsdl = (Path)Ensure.notNull((Object)wsdl);
        Ensure.isTrue((boolean)JdtUtils.exists((IJavaElement)javaProject));
        this.m_javaProject = javaProject;
        this.m_displayName = this.calcDisplayName();
        this.m_hash = this.m_wsdl.hashCode();
        this.m_scoutApi = (IScoutApi)Ensure.notNull((Object)api);
        int defaultSize = 3;
        this.m_bindings = new ArrayList<Path>(defaultSize);
        this.m_jaxwsBindingFiles = new ArrayList<Path>(defaultSize);
        this.m_webServices = new HashMap<IType, QName>(defaultSize);
        this.m_superHierarchyCache = new HashMap<IType, ITypeHierarchy>(defaultSize);
        this.m_hierarchyCache = new HashMap<IType, ITypeHierarchy>(defaultSize);
        this.m_webServiceClients = new HashMap<IType, IType>(defaultSize);
        this.m_entryPoints = new HashMap<IType, IType>(defaultSize);
        this.m_portTypes = new HashMap<IType, Set<IType>>(defaultSize);
        this.m_serviceImplementations = new HashMap<IType, IType>(defaultSize);
        this.m_entryPointDefinitions = new HashMap<IType, IType>(defaultSize);
        this.m_entryPointNameFromDefinitions = new HashMap<IType, String>(defaultSize);
        this.m_entryPointPackageFromDefinitions = new HashMap<IType, String>(defaultSize);
        this.m_authMethodFromDefinitions = new HashMap<IType, IType>(defaultSize);
        this.m_authVerifierFromDefinitions = new HashMap<IType, IType>(defaultSize);
        this.m_handlersFromDefinitions = new HashMap<IType, List<IType>>(defaultSize);
        this.m_portTypeNamesInWsdl = new HashMap<IType, QName>(defaultSize);
    }

    public void load(IProgressMonitor monitor) throws JavaModelException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)("Parse artifacts of " + this.getWsdl().getFileName()), (int)120);
        S2eUtils.waitForJdt();
        this.loadWsdlServices();
        progress.worked(50);
        this.loadWebServicesAndPortTypes();
        progress.worked(10);
        this.loadBindings();
        progress.worked(10);
        this.loadJaxwsBindingFile();
        progress.worked(10);
        this.loadWebServiceClient();
        progress.worked(10);
        this.loadEntryPoint();
        progress.worked(10);
        this.loadEntryPointDefinitions();
        progress.worked(10);
        this.loadServiceImplementations();
        progress.worked(10);
    }

    protected String calcDisplayName() {
        String name = this.getWsdl().getFileName().toString();
        int lastDotPos = name.lastIndexOf(46);
        if (lastDotPos > 0) {
            name = name.substring(0, lastDotPos);
        }
        name = JaxWsUtils.removeCommonSuffixes((String)name);
        String words = Pattern.compile("([A-Z])").matcher(name).replaceAll(" $1");
        CharSequence cleanWords = Strings.trim((CharSequence)Pattern.compile("[^A-Za-z0-9\\s]").matcher(words).replaceAll(" "));
        return Pattern.compile("\\s").splitAsStream(cleanWords).filter(Strings::hasText).map(Strings::capitalize).collect(Collectors.joining(" "));
    }

    protected void loadWsdlServices() {
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(this.getWsdl(), StandardOpenOption.READ));){
            this.setServicesFromWsdl(ParsedWsdl.create((URI)this.getWsdl().toUri(), (InputStream)in, (boolean)false));
        }
        catch (IOException | WSDLException e) {
            throw new SdkException(e);
        }
    }

    protected void loadWebServiceClient() {
        Predicate<IType> webServiceClientsFilter = element -> {
            try {
                ITypeHierarchy superTypeHierarchy = this.getSuperTypeHierarchy((IType)element);
                return JdtUtils.hierarchyContains((ITypeHierarchy)superTypeHierarchy, (String)this.getScoutApi().AbstractWebServiceClient().fqn());
            }
            catch (SdkException e) {
                SdkLog.warning((CharSequence)"Unable to check if element '{}' is a web service client.", (Object[])new Object[]{element.getFullyQualifiedName(), e});
                return false;
            }
        };
        this.visitPortTypes(portType -> {
            IType webServiceClient = this.getPortTypeChildClass((IType)portType, webServiceClientsFilter);
            if (JdtUtils.exists((IJavaElement)webServiceClient)) {
                this.m_webServiceClients.put((IType)portType, webServiceClient);
            }
        });
    }

    protected IType getPortTypeChildClass(IType portType, Predicate<IType> filter) {
        if (!JdtUtils.exists((IJavaElement)portType)) {
            return null;
        }
        IType[] candidates = this.getTypeHierarchy(portType).getAllSubtypes(portType);
        return Arrays.stream(candidates).filter(t -> filter == null || filter.test((IType)t)).findFirst().orElse(null);
    }

    protected void loadEntryPoint() {
        String webServiceFqn = this.getScoutApi().WebService().fqn();
        Predicate<IType> portTypeFilter = element -> JdtUtils.exists((IJavaElement)JdtUtils.getAnnotation((IAnnotatable)element, (String)webServiceFqn));
        this.visitPortTypes(portType -> {
            IType entryPoint = this.getPortTypeChildClass((IType)portType, portTypeFilter);
            if (JdtUtils.exists((IJavaElement)entryPoint)) {
                this.m_entryPoints.put((IType)portType, entryPoint);
            }
        });
    }

    protected void loadEntryPointDefinitions() throws JavaModelException {
        Set<IType> webServiceEntryPointDefinitions = this.findAllTypesAnnotatedWith(this.getScoutApi().WebServiceEntryPoint().fqn());
        if (webServiceEntryPointDefinitions.isEmpty()) {
            return;
        }
        if (this.m_entryPoints.isEmpty()) {
            return;
        }
        for (Set<IType> portTypes : this.m_portTypes.values()) {
            for (IType portType : portTypes) {
                IType entryPoint = this.getEntryPoint(portType);
                if (!JdtUtils.exists((IJavaElement)entryPoint)) continue;
                String entryPointFqn = entryPoint.getFullyQualifiedName();
                for (IType entryPointDefCandidate : webServiceEntryPointDefinitions) {
                    this.loadEntryPointDefinition(entryPointDefCandidate, portType, entryPointFqn);
                }
            }
        }
    }

    protected void loadEntryPointDefinition(IType entryPointDefCandidate, IType portType, String entryPointFqn) throws JavaModelException {
        IScoutAnnotationApi.WebServiceEntryPoint entryPointApi = this.getScoutApi().WebServiceEntryPoint();
        IAnnotation annotation = JdtUtils.getAnnotation((IAnnotatable)entryPointDefCandidate, (String)entryPointApi.fqn());
        if (!JdtUtils.exists((IJavaElement)annotation)) {
            return;
        }
        String pck = JdtUtils.getAnnotationValueString((IAnnotation)annotation, (String)entryPointApi.entryPointPackageElementName());
        Object name = JdtUtils.getAnnotationValueString((IAnnotation)annotation, (String)entryPointApi.entryPointNameElementName());
        if (Strings.isBlank((CharSequence)pck)) {
            pck = JavaTypes.qualifier((CharSequence)entryPointDefCandidate.getFullyQualifiedName());
        }
        if (Strings.isBlank((CharSequence)name)) {
            name = portType.getElementName() + "EntryPoint";
        }
        if (entryPointFqn.equals(pck + "." + (String)name)) {
            this.m_entryPointDefinitions.put(portType, entryPointDefCandidate);
            this.m_entryPointNameFromDefinitions.put(portType, (String)name);
            this.m_entryPointPackageFromDefinitions.put(portType, pck);
            for (IMemberValuePair mvp : annotation.getMemberValuePairs()) {
                Object value;
                if (entryPointApi.authenticationElementName().equals(mvp.getMemberName())) {
                    value = mvp.getValue();
                    if (!(value instanceof IAnnotation)) continue;
                    IAnnotation authentication = (IAnnotation)value;
                    for (IMemberValuePair authElement : authentication.getMemberValuePairs()) {
                        if (this.getScoutApi().Authentication().methodElementName().equals(authElement.getMemberName()) && authElement.getValueKind() == 10) {
                            this.m_authMethodFromDefinitions.put(portType, this.getClazzAnnotationValue((IAnnotation)authElement.getValue(), entryPointDefCandidate));
                            continue;
                        }
                        if (!this.getScoutApi().Authentication().verifierElementName().equals(authElement.getMemberName()) || authElement.getValueKind() != 10) continue;
                        this.m_authVerifierFromDefinitions.put(portType, this.getClazzAnnotationValue((IAnnotation)authElement.getValue(), entryPointDefCandidate));
                    }
                    continue;
                }
                if (!entryPointApi.handlerChainElementName().equals(mvp.getMemberName())) continue;
                value = mvp.getValue();
                if (value instanceof Object[]) {
                    Object[] values = (Object[])value;
                    Collection handlers = Arrays.stream(values).filter(o -> o instanceof IAnnotation).map(o -> (IAnnotation)o).collect(Collectors.toList());
                    this.loadHandlersFromDefinition(handlers, entryPointDefCandidate, portType);
                    continue;
                }
                if (!(value instanceof IAnnotation)) continue;
                this.loadHandlersFromDefinition(Collections.singletonList((IAnnotation)value), entryPointDefCandidate, portType);
            }
        }
    }

    protected void loadHandlersFromDefinition(Iterable<IAnnotation> handlers, IType owner, IType portType) throws JavaModelException {
        String handlerValueElementName = this.getScoutApi().Handler().valueElementName();
        for (IAnnotation handler : handlers) {
            for (IMemberValuePair mvp : handler.getMemberValuePairs()) {
                IAnnotation clazzAnnotation;
                IType handlerType;
                if (!handlerValueElementName.equals(mvp.getMemberName()) || mvp.getValueKind() != 10 || !JdtUtils.exists((IJavaElement)(handlerType = this.getClazzAnnotationValue(clazzAnnotation = (IAnnotation)mvp.getValue(), owner)))) continue;
                this.m_handlersFromDefinitions.computeIfAbsent(portType, k -> new ArrayList(3)).add(handlerType);
            }
        }
    }

    protected IType getClazzAnnotationValue(IAnnotation clazzAnnotation, IType owner) throws JavaModelException {
        if (!JdtUtils.exists((IJavaElement)clazzAnnotation)) {
            return null;
        }
        IScoutAnnotationApi.Clazz clazzApi = this.getScoutApi().Clazz();
        String qualifiedName = JdtUtils.getAnnotationValueString((IAnnotation)clazzAnnotation, (String)clazzApi.qualifiedNameElementName());
        IJavaProject javaProject = owner.getJavaProject();
        if (Strings.hasText((CharSequence)qualifiedName)) {
            return javaProject.findType(qualifiedName);
        }
        String value = JdtUtils.getAnnotationValueString((IAnnotation)clazzAnnotation, (String)clazzApi.valueElementName());
        if (Strings.isBlank((CharSequence)value)) {
            return null;
        }
        String nullClazzSimpleName = this.getScoutApi().NullClazz().simpleName().replace('$', '.');
        if (value.equals(nullClazzSimpleName) || value.endsWith("." + nullClazzSimpleName) || value.endsWith("$" + nullClazzSimpleName)) {
            return null;
        }
        return WebServiceFormPageInput.getReferencedType(owner, value);
    }

    protected static IType getReferencedType(IType declaringType, String typeName) throws JavaModelException {
        String[][] resolvedTypeName = declaringType.resolveType(typeName);
        if (resolvedTypeName == null || resolvedTypeName.length < 1) {
            return null;
        }
        IJavaProject javaProject = declaringType.getJavaProject();
        for (String[] fqn : resolvedTypeName) {
            IType result = javaProject.findType(fqn[0], fqn[1]);
            if (!JdtUtils.exists((IJavaElement)result)) continue;
            return result;
        }
        return null;
    }

    protected void loadServiceImplementations() {
        String webServiceFqn = this.getScoutApi().WebService().fqn();
        Predicate<IType> serviceImplFilter = element -> {
            if (JdtUtils.exists((IJavaElement)JdtUtils.getAnnotation((IAnnotatable)element, (String)webServiceFqn))) {
                return false;
            }
            try {
                ITypeHierarchy superTypeHierarchy = this.getSuperTypeHierarchy((IType)element);
                return !JdtUtils.hierarchyContains((ITypeHierarchy)superTypeHierarchy, (String)this.getScoutApi().AbstractWebServiceClient().fqn());
            }
            catch (SdkException e) {
                SdkLog.warning((CharSequence)"Unable to check if element '{}' is a web service client.", (Object[])new Object[]{element.getFullyQualifiedName(), e});
                return false;
            }
        };
        this.visitPortTypes(portType -> {
            IType serviceImpl = this.getPortTypeChildClass((IType)portType, serviceImplFilter);
            if (JdtUtils.exists((IJavaElement)serviceImpl)) {
                this.m_serviceImplementations.put((IType)portType, serviceImpl);
            }
        });
    }

    protected void visitPortTypes(Consumer<IType> visitor) {
        for (Set<IType> portTypes : this.m_portTypes.values()) {
            for (IType portType : portTypes) {
                visitor.accept(portType);
            }
        }
    }

    protected void loadWebServicesAndPortTypes() throws JavaModelException {
        if (this.getServicesFromWsdl().isEmpty()) {
            return;
        }
        IScoutVariousApi.WebServiceClient webServiceClientApi = this.getScoutApi().WebServiceClient();
        Set<IType> candidates = this.findAllTypesAnnotatedWith(webServiceClientApi.fqn());
        if (candidates.isEmpty()) {
            return;
        }
        for (IType candidate : candidates) {
            IAnnotation annotation = JdtUtils.getAnnotation((IAnnotatable)candidate, (String)webServiceClientApi.fqn());
            String name = JdtUtils.getAnnotationValueString((IAnnotation)annotation, (String)webServiceClientApi.nameElementName());
            String targetNamespace = JdtUtils.getAnnotationValueString((IAnnotation)annotation, (String)webServiceClientApi.targetNamespaceElementName());
            for (Service info : this.getServicesFromWsdl().getWebServices().keySet()) {
                QName webServiceName = info.getQName();
                if (!Objects.equals(name, webServiceName.getLocalPart()) || !Objects.equals(targetNamespace, webServiceName.getNamespaceURI())) continue;
                this.m_webServices.put(candidate, webServiceName);
                this.loadPortTypes(info, candidate);
            }
        }
    }

    protected void loadPortTypes(Service service, IType webService) throws JavaModelException {
        if (this.getServicesFromWsdl().isEmpty()) {
            return;
        }
        IScoutVariousApi.WebService webServiceApi = this.getScoutApi().WebService();
        Set<IType> candidates = this.findAllTypesAnnotatedWith(webServiceApi.fqn());
        if (candidates.isEmpty()) {
            return;
        }
        for (IType candidate : candidates) {
            if (!candidate.isInterface()) continue;
            IAnnotation annotation = JdtUtils.getAnnotation((IAnnotatable)candidate, (String)webServiceApi.fqn());
            String name = JdtUtils.getAnnotationValueString((IAnnotation)annotation, (String)webServiceApi.nameElementName());
            String targetNamespace = JdtUtils.getAnnotationValueString((IAnnotation)annotation, (String)webServiceApi.targetNamespaceElementName());
            for (Map.Entry port : this.getServicesFromWsdl().getPorts(service).entrySet()) {
                QName portTypeName = (QName)port.getValue();
                if (!Objects.equals(name, portTypeName.getLocalPart()) || !Objects.equals(targetNamespace, portTypeName.getNamespaceURI())) continue;
                this.m_portTypes.computeIfAbsent(webService, k -> new LinkedHashSet(3)).add(candidate);
                this.m_portTypeNamesInWsdl.put(candidate, portTypeName);
            }
        }
    }

    protected Set<IType> findAllTypesAnnotatedWith(String fqn) {
        IJavaSearchScope scope = JdtUtils.createJavaSearchScope((IJavaElement[])new IJavaElement[]{this.getJavaProject()});
        return JdtUtils.findAllTypesAnnotatedWith((String)fqn, (IJavaSearchScope)scope, null);
    }

    protected ITypeHierarchy getTypeHierarchy(IType t) {
        if (!JdtUtils.exists((IJavaElement)t)) {
            return null;
        }
        return this.m_hierarchyCache.computeIfAbsent(t, key -> {
            try {
                return key.newTypeHierarchy(null);
            }
            catch (JavaModelException e) {
                throw new SdkException((Throwable)e);
            }
        });
    }

    protected ITypeHierarchy getSuperTypeHierarchy(IType t) {
        if (!JdtUtils.exists((IJavaElement)t)) {
            return null;
        }
        return this.m_superHierarchyCache.computeIfAbsent(t, key -> {
            try {
                return key.newSupertypeHierarchy(null);
            }
            catch (JavaModelException e) {
                throw new SdkException((Throwable)e);
            }
        });
    }

    protected void loadBindings() {
        block12: {
            Document pomDocument = S2eUtils.getPomDocument((IProject)this.getJavaProject().getProject());
            if (pomDocument == null) {
                return;
            }
            Path projectPath = this.getJavaProject().getProject().getLocation().toFile().toPath();
            Path bindingFolder = AbstractWebServiceNewOperation.getBindingRootFolder((Path)projectPath);
            if (!Files.isDirectory(bindingFolder, new LinkOption[0])) {
                return;
            }
            try {
                Path wsdlFolderRelativePath = AbstractWebServiceNewOperation.getWsdlRootFolder((Path)projectPath).relativize(this.getWsdl());
                IScoutApi scoutApi = ApiHelper.requireScoutApiFor((IJavaElement)this.getJavaProject());
                List paths = JaxWsUtils.getBindingPathsFromPom((Node)pomDocument, (String)wsdlFolderRelativePath.toString().replace('\\', '/'), (IScoutVariousApi)scoutApi);
                if (paths.isEmpty()) {
                    try (Stream<Path> ps = Files.list(bindingFolder);){
                        ps.filter(Files::isReadable).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(this.m_bindings::add);
                        break block12;
                    }
                }
                for (String bindingRelPath : paths) {
                    Path candidate = bindingFolder.resolve(bindingRelPath);
                    if (!Files.isReadable(candidate) || !Files.isRegularFile(candidate, new LinkOption[0])) continue;
                    this.m_bindings.add(candidate);
                }
            }
            catch (IOException | XPathExpressionException e) {
                throw new SdkException((Throwable)e);
            }
        }
    }

    protected void loadJaxwsBindingFile() {
        if (this.m_bindings.isEmpty()) {
            return;
        }
        for (Path candidate : this.m_bindings) {
            try {
                String rootNs;
                Document document = Xml.get((Path)candidate);
                Element rootTag = document.getDocumentElement();
                if (!"bindings".equals(rootTag.getLocalName()) || !"http://java.sun.com/xml/ns/jaxws".equals(rootNs = rootTag.getNamespaceURI())) continue;
                this.m_jaxwsBindingFiles.add(candidate);
            }
            catch (IOException e) {
                throw new SdkException((Throwable)e);
            }
        }
    }

    public IType getWebService(IType portType) {
        return this.m_portTypes.entrySet().stream().filter(entry -> ((Set)entry.getValue()).stream().anyMatch(pt -> pt.equals(portType))).findFirst().map(Map.Entry::getKey).orElse(null);
    }

    public QName getWebServiceNameInWsdl(IType webService) {
        return this.m_webServices.get(webService);
    }

    public QName getPortTypeNameInWsdl(IType portType) {
        return this.m_portTypeNamesInWsdl.get(portType);
    }

    public List<Path> getJaxWsBindingFiles() {
        return Collections.unmodifiableList(this.m_jaxwsBindingFiles);
    }

    public boolean hasConsumerElements() {
        return !this.m_webServiceClients.isEmpty();
    }

    public boolean hasProviderElements() {
        return Stream.of(this.m_entryPoints, this.m_serviceImplementations, this.m_entryPointDefinitions).anyMatch(iTypeITypeMap -> !iTypeITypeMap.isEmpty());
    }

    public String getDisplayName() {
        return this.m_displayName;
    }

    public Path getWsdl() {
        return this.m_wsdl;
    }

    public IType getWebServiceClient(IType portType) {
        return this.m_webServiceClients.get(portType);
    }

    public IType getEntryPoint(IType portType) {
        return this.m_entryPoints.get(portType);
    }

    public IType getEntryPointDefinition(IType portType) {
        return this.m_entryPointDefinitions.get(portType);
    }

    public IType getServiceImplementation(IType portType) {
        return this.m_serviceImplementations.get(portType);
    }

    public Set<IType> getPortTypes(IType webService) {
        Set<IType> result = this.m_portTypes.get(webService);
        if (result == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(result);
    }

    public Set<IType> getAllPortTypes() {
        return this.m_portTypes.values().stream().flatMap(Collection::stream).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public Set<IType> getWebServices() {
        return Collections.unmodifiableSet(this.m_webServices.keySet());
    }

    protected ParsedWsdl getServicesFromWsdl() {
        return this.m_servicesFromWsdl;
    }

    protected void setServicesFromWsdl(ParsedWsdl namesFromWsdl) {
        this.m_servicesFromWsdl = namesFromWsdl;
    }

    public String getEntryPointNameFromDefinition(IType portType) {
        return this.m_entryPointNameFromDefinitions.get(portType);
    }

    public String getEntryPointPackageFromDefinition(IType portType) {
        return this.m_entryPointPackageFromDefinitions.get(portType);
    }

    public IType getAuthMethodFromDefinition(IType portType) {
        return this.m_authMethodFromDefinitions.get(portType);
    }

    public IType getAuthVerifierFromDefinition(IType portType) {
        return this.m_authVerifierFromDefinitions.get(portType);
    }

    public List<Path> getBindings() {
        return Collections.unmodifiableList(this.m_bindings);
    }

    public List<IType> getHandlers(IType portType) {
        List<IType> list = this.m_handlersFromDefinitions.get(portType);
        if (list == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(list);
    }

    public IJavaProject getJavaProject() {
        return this.m_javaProject;
    }

    public IScoutApi getScoutApi() {
        return this.m_scoutApi;
    }

    public int hashCode() {
        return this.m_hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WebServiceFormPageInput other = (WebServiceFormPageInput)obj;
        return this.m_wsdl.equals(other.m_wsdl);
    }

    @Override
    public int compareTo(WebServiceFormPageInput o) {
        if (o.getWsdl() == this.getWsdl()) {
            return 0;
        }
        int result = this.getWsdl().getFileName().toString().compareTo(o.getWsdl().getFileName().toString());
        if (result != 0) {
            return result;
        }
        return this.getWsdl().toString().compareTo(o.getWsdl().toString());
    }

    public String toString() {
        return this.getWsdl().toString();
    }
}

