/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.classid;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IRegion;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.scout.sdk.core.apidef.IClassNameSupplier;
import org.eclipse.scout.sdk.core.imports.CompilationUnitScopedImportCollector;
import org.eclipse.scout.sdk.core.imports.IImportCollector;
import org.eclipse.scout.sdk.core.imports.IImportValidator;
import org.eclipse.scout.sdk.core.imports.ImportCollector;
import org.eclipse.scout.sdk.core.imports.ImportValidator;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.s.apidef.IScoutInterfaceApi;
import org.eclipse.scout.sdk.core.s.apidef.ScoutApi;
import org.eclipse.scout.sdk.core.s.classid.ClassIds;
import org.eclipse.scout.sdk.core.s.generator.annotation.ScoutAnnotationGenerator;
import org.eclipse.scout.sdk.core.util.SdkException;
import org.eclipse.scout.sdk.s2e.environment.EclipseEnvironment;
import org.eclipse.scout.sdk.s2e.environment.EclipseProgress;
import org.eclipse.scout.sdk.s2e.environment.WorkingCopyManager;
import org.eclipse.scout.sdk.s2e.operation.AnnotationNewOperation;
import org.eclipse.scout.sdk.s2e.operation.ImportsCreateOperation;
import org.eclipse.scout.sdk.s2e.util.ApiHelper;
import org.eclipse.scout.sdk.s2e.util.JdtUtils;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class MissingClassIdsNewOperation
implements BiConsumer<EclipseEnvironment, EclipseProgress> {
    private Set<IResource> m_selection;

    @Override
    public void accept(EclipseEnvironment env, EclipseProgress p) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)p.monitor(), (int)10);
        try {
            Collection<IType> candidates = this.findCandidates(progress.newChild(8));
            if (candidates.isEmpty()) {
                return;
            }
            this.processCandidates(candidates, env, progress.newChild(2));
        }
        catch (OperationCanceledException e) {
            SdkLog.debug((CharSequence)"Creation of missing @ClassId annotations has been canceled.", (Object[])new Object[]{e});
        }
    }

    protected ITypeHierarchy createHierarchy(IType iTypeWithClassId, IProgressMonitor monitor) {
        if (this.useRegion()) {
            return this.createRegionHierarchy(monitor);
        }
        try {
            return iTypeWithClassId.newTypeHierarchy(monitor);
        }
        catch (JavaModelException e) {
            throw new SdkException((Throwable)e);
        }
    }

    protected boolean useRegion() {
        Set<IResource> selection = this.selection();
        if (selection.isEmpty() || selection.size() > 100) {
            return false;
        }
        return selection.stream().noneMatch(r -> r.getType() != 1);
    }

    protected ITypeHierarchy createRegionHierarchy(IProgressMonitor monitor) {
        IRegion region = JavaCore.newRegion();
        for (IResource r : this.selection()) {
            IJavaElement element;
            if (r == null || !r.isAccessible() || !JdtUtils.exists(element = JavaCore.create((IResource)r))) continue;
            region.add(element);
        }
        try {
            return JavaCore.newTypeHierarchy((IRegion)region, null, (IProgressMonitor)monitor);
        }
        catch (JavaModelException e) {
            throw new SdkException((Throwable)e);
        }
    }

    protected Collection<IType> findCandidates(SubMonitor monitor) {
        Set startTypes = ScoutApi.allKnown().map(IScoutInterfaceApi::ITypeWithClassId).map(IClassNameSupplier::fqn).distinct().map(JdtUtils::resolveJdtTypes).flatMap(Collection::stream).collect(Collectors.toSet());
        monitor.setWorkRemaining(startTypes.size());
        monitor.setTaskName("Search for classes...");
        if (startTypes.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<IType> result = new HashSet<IType>();
        for (IType startType : startTypes) {
            ITypeHierarchy hierarchy = this.createHierarchy(startType, (IProgressMonitor)monitor.newChild(1));
            if (hierarchy == null || monitor.isCanceled()) {
                return Collections.emptyList();
            }
            Collections.addAll(result, hierarchy.getAllSubtypes(startType));
            if (!monitor.isCanceled()) continue;
            return Collections.emptyList();
        }
        return result;
    }

    protected boolean acceptType(IType candidate) {
        try {
            if (!JdtUtils.exists((IJavaElement)candidate) || !candidate.isClass() || candidate.isBinary() || candidate.isAnonymous()) {
                return false;
            }
        }
        catch (JavaModelException e) {
            SdkLog.warning((CharSequence)"Unable to check flags of type '{}'. Skipping.", (Object[])new Object[]{candidate.getFullyQualifiedName(), e});
            return false;
        }
        IResource resource = candidate.getResource();
        if (resource == null || !resource.isAccessible()) {
            return false;
        }
        if (this.selection().isEmpty()) {
            return true;
        }
        return this.isInResources(resource);
    }

    protected boolean isInResources(IResource candidate) {
        IPath location = candidate.getLocation();
        return this.selection().stream().anyMatch(r -> r.getLocation().isPrefixOf(location));
    }

    protected void processCandidates(Collection<IType> candidates, EclipseEnvironment env, SubMonitor monitor) {
        SubMonitor subMonitor = monitor.newChild(2);
        subMonitor.setWorkRemaining(candidates.size());
        subMonitor.setTaskName("Search for missing annotations...");
        int numTypes = 0;
        HashMap<ICompilationUnit, Set> typesWithoutClassId = new HashMap<ICompilationUnit, Set>();
        for (IType iType : candidates) {
            ICompilationUnit icu;
            String classIdFqn;
            IAnnotation annotation;
            if (this.acceptType(iType) && (annotation = JdtUtils.getAnnotation((IAnnotatable)iType, classIdFqn = ApiHelper.requireScoutApiFor((IJavaElement)iType, env).ClassId().fqn())) == null && typesWithoutClassId.computeIfAbsent(icu = iType.getCompilationUnit(), k -> new HashSet()).add(iType)) {
                ++numTypes;
            }
            if (monitor.isCanceled()) {
                return;
            }
            subMonitor.worked(1);
        }
        subMonitor = monitor.newChild(6);
        subMonitor.setWorkRemaining(numTypes);
        subMonitor.setTaskName("Create new annotations...");
        for (Map.Entry entry : typesWithoutClassId.entrySet()) {
            try {
                MissingClassIdsNewOperation.createClassIdsForIcu((ICompilationUnit)entry.getKey(), (Iterable)entry.getValue(), env, (IProgressMonitor)subMonitor);
            }
            catch (CoreException e1) {
                SdkLog.warning((CharSequence)"Unable to write compilation unit '{}'.", (Object[])new Object[]{((ICompilationUnit)entry.getKey()).getPath(), e1});
            }
            if (!monitor.isCanceled()) continue;
            return;
        }
    }

    public static void createClassIdsForIcu(ICompilationUnit icu, Iterable<IType> types, EclipseEnvironment env, IProgressMonitor monitor) throws CoreException {
        WorkingCopyManager.currentWorkingCopyManager().register(icu, null);
        IJavaEnvironment environment = env.toScoutJavaEnvironment(icu.getJavaProject());
        CompilationUnitScopedImportCollector collector = new CompilationUnitScopedImportCollector((IImportCollector)new ImportCollector(environment), JdtUtils.getPackage(icu));
        IBuffer buffer = icu.getBuffer();
        Document sourceDoc = new Document(buffer.getContents());
        MultiTextEdit multiEdit = new MultiTextEdit();
        ImportValidator validator = new ImportValidator((IImportCollector)collector);
        String nl = icu.findRecommendedLineSeparator();
        for (IType t : types) {
            String newClassId = ClassIds.next((String)t.getFullyQualifiedName());
            AnnotationNewOperation op = new AnnotationNewOperation(ScoutAnnotationGenerator.createClassId((CharSequence)newClassId), (IMember)t);
            TextEdit edit = op.createEdit((IImportValidator)validator, (IDocument)sourceDoc, nl);
            multiEdit.addChild(edit);
            monitor.worked(1);
            if (!monitor.isCanceled()) continue;
            return;
        }
        try {
            multiEdit.apply((IDocument)sourceDoc);
            buffer.setContents(sourceDoc.get());
            new ImportsCreateOperation(icu, (IImportCollector)collector).accept(env, EclipseEnvironment.toScoutProgress(monitor));
        }
        catch (BadLocationException e) {
            SdkLog.warning((CharSequence)"Could not update @ClassId annotations for compilation unit '{}'.", (Object[])new Object[]{icu.getElementName(), e});
        }
    }

    public String toString() {
        return "Create missing @ClassId annotations";
    }

    public Set<IResource> selection() {
        if (this.m_selection == null) {
            return Collections.emptySet();
        }
        return this.m_selection;
    }

    public MissingClassIdsNewOperation withSelection(Set<IResource> selection) {
        this.m_selection = selection;
        return this;
    }
}

