/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate.preserveorder;

import java.util.Comparator;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.OrderingStrategy;

public class ModelOrderNodeComparator
implements Comparator<LNode> {
    private final Layer previousLayer;
    private final OrderingStrategy orderingStrategy;

    public ModelOrderNodeComparator(Layer previousLayer, OrderingStrategy orderingStrategy) {
        this.previousLayer = previousLayer;
        this.orderingStrategy = orderingStrategy;
    }

    @Override
    public int compare(LNode n1, LNode n2) {
        if (this.orderingStrategy == OrderingStrategy.PREFER_EDGES || !n1.hasProperty(InternalProperties.MODEL_ORDER) || !n2.hasProperty(InternalProperties.MODEL_ORDER)) {
            LPort p1SourcePort = n1.getPorts().stream().filter(p -> !p.getIncomingEdges().isEmpty()).findFirst().map(p -> p.getIncomingEdges().get(0).getSource()).orElse(null);
            LPort p2SourcePort = n2.getPorts().stream().filter(p -> !p.getIncomingEdges().isEmpty()).findFirst().map(p -> p.getIncomingEdges().get(0).getSource()).orElse(null);
            if (p1SourcePort != null && p2SourcePort != null) {
                LNode p1Node = p1SourcePort.getNode();
                LNode p2Node = p2SourcePort.getNode();
                if (p1Node != null && ((Object)((Object)p1Node)).equals((Object)p2Node)) {
                    for (LPort port : p1Node.getPorts()) {
                        if (((Object)((Object)port)).equals((Object)p1SourcePort)) {
                            return -1;
                        }
                        if (!((Object)((Object)port)).equals((Object)p2SourcePort)) continue;
                        return 1;
                    }
                    assert (false);
                    return Integer.compare(this.getModelOrderFromConnectedEdges(n1), this.getModelOrderFromConnectedEdges(n2));
                }
                for (LNode previousNode : this.previousLayer) {
                    if (((Object)((Object)previousNode)).equals((Object)p1Node)) {
                        return -1;
                    }
                    if (!((Object)((Object)previousNode)).equals((Object)p2Node)) continue;
                    return 1;
                }
            }
            if (!n1.hasProperty(InternalProperties.MODEL_ORDER) || !n2.hasProperty(InternalProperties.MODEL_ORDER)) {
                return Integer.compare(this.getModelOrderFromConnectedEdges(n1), this.getModelOrderFromConnectedEdges(n2));
            }
        }
        return Integer.compare((Integer)n1.getProperty(InternalProperties.MODEL_ORDER), (Integer)n2.getProperty(InternalProperties.MODEL_ORDER));
    }

    private int getModelOrderFromConnectedEdges(LNode n) {
        LEdge edge;
        LPort sourcePort = n.getPorts().stream().filter(p -> !p.getIncomingEdges().isEmpty()).findFirst().orElse(null);
        if (sourcePort != null && (edge = sourcePort.getIncomingEdges().get(0)) != null) {
            return (Integer)edge.getProperty(InternalProperties.MODEL_ORDER);
        }
        return Integer.MAX_VALUE;
    }
}

