/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tools.api.ui;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.business.api.query.ResourceQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.Messages;

public final class RefreshHelper {
    private static List<Predicate<Notification>> impactingNotificationPredicates = new ArrayList<Predicate<Notification>>();

    private RefreshHelper() {
    }

    public static boolean isImpactingNotification(Collection<Notification> notifications) {
        HashMap<EObject, Boolean> notifierIsInAirdOrSrmResource = new HashMap<EObject, Boolean>();
        HashMap<EObject, Resource> notifierWithResource = new HashMap<EObject, Resource>();
        HashSet<EObject> alreadyDoneNotifiers = new HashSet<EObject>();
        for (Notification notification : notifications) {
            EObject eObjectNotifier;
            Object notifier = notification.getNotifier();
            if (!(notifier instanceof EObject) || alreadyDoneNotifiers.contains(eObjectNotifier = (EObject)notifier) || !RefreshHelper.isImpactingNotification(notification, eObjectNotifier, alreadyDoneNotifiers, notifierWithResource, notifierIsInAirdOrSrmResource)) continue;
            return true;
        }
        return false;
    }

    protected static boolean isImpactingNotification(Notification notification, EObject notifier, Set<EObject> alreadyDoneNotifiers, Map<EObject, Resource> notifierWithResource, Map<EObject, Boolean> notifierIsInAirdOrSrmResource) {
        Resource notifierResource = notifierWithResource.get(notifier);
        Boolean isAirdOrSrmResourceCache = notifierIsInAirdOrSrmResource.get(notifier);
        boolean isImpactingNotification = false;
        if (notifierResource != null) {
            isImpactingNotification = isAirdOrSrmResourceCache == false;
        } else {
            notifierResource = notifier.eResource();
            if (notifierResource != null) {
                if (impactingNotificationPredicates.isEmpty()) {
                    alreadyDoneNotifiers.add(notifier);
                }
                isImpactingNotification = !new ResourceQuery(notifierResource).isAirdOrSrmResource();
                notifierWithResource.put(notifier, notifierResource);
                notifierIsInAirdOrSrmResource.put(notifier, !isImpactingNotification);
            }
        }
        if (notifierResource != null && !isImpactingNotification && RefreshHelper.isSpecificImpactingNotification(notification)) {
            Option<DRepresentation> optionalDRepresentation = Options.newNone();
            Session session = SessionManager.INSTANCE.getExistingSession(notifierResource.getURI());
            if (session == null && (optionalDRepresentation = new EObjectQuery(notifier).getRepresentation()).some()) {
                session = new EObjectQuery((EObject)optionalDRepresentation.get()).getSession();
            }
            if (session != null && !session.getSiriusPreferences().isAutoRefresh()) {
                if (!optionalDRepresentation.some()) {
                    optionalDRepresentation = new EObjectQuery(notifier).getRepresentation();
                }
                if (optionalDRepresentation.some()) {
                    session.getRefreshEditorsListener().addRepresentationToForceRefresh((DRepresentation)optionalDRepresentation.get());
                }
            }
            isImpactingNotification = true;
        }
        return isImpactingNotification;
    }

    private static boolean isSpecificImpactingNotification(Notification notification) {
        for (Predicate<Notification> predicate : impactingNotificationPredicates) {
            if (!predicate.test(notification)) continue;
            return true;
        }
        return false;
    }

    public static void registerImpactingNotification(Predicate<Notification> impactingNotificationPredicate) {
        Preconditions.checkNotNull(impactingNotificationPredicate, (Object)Messages.RefreshHelper_notNullPredicate);
        impactingNotificationPredicates.add(impactingNotificationPredicate);
    }

    public static void unregisterImpactingNotification(Predicate<Notification> impactingNotificationPredicate) {
        Preconditions.checkNotNull(impactingNotificationPredicate, (Object)Messages.RefreshHelper_notNullPredicate);
        impactingNotificationPredicates.remove(impactingNotificationPredicate);
    }
}

