/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.services.graphql.internal.schema.mutation;

import graphql.schema.DataFetcher;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Optional;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.sirius.services.graphql.internal.SiriusGraphQLPlugin;
import org.eclipse.sirius.services.graphql.internal.schema.mutation.ContainerPathArgument;
import org.eclipse.sirius.services.graphql.internal.schema.mutation.FileCreationHelper;
import org.eclipse.sirius.services.graphql.internal.schema.mutation.ProjectNameArgument;

public final class CreateFileField {
    private static final String CREATE_FILE_FIELD = "createFile";
    private static final String DESCRIPTION_ARG = "description";

    private CreateFileField() {
    }

    public static GraphQLFieldDefinition build() {
        return GraphQLFieldDefinition.newFieldDefinition().name(CREATE_FILE_FIELD).argument(ProjectNameArgument.build()).argument(ContainerPathArgument.build()).argument(CreateFileField.getDescriptionArgument()).type((GraphQLOutputType)new GraphQLTypeReference("File")).dataFetcher(CreateFileField.getCreateTextFileDataFetcher()).build();
    }

    private static GraphQLArgument getDescriptionArgument() {
        return GraphQLArgument.newArgument().name(DESCRIPTION_ARG).type((GraphQLInputType)new GraphQLNonNull((GraphQLType)new GraphQLTypeReference("FileCreationDescription"))).build();
    }

    private static DataFetcher<IFile> getCreateTextFileDataFetcher() {
        return environment -> {
            IFile iFile;
            Optional<IFile> optionalFile = FileCreationHelper.getFile(environment);
            if (optionalFile.isPresent() && !(iFile = optionalFile.get()).exists()) {
                try {
                    iFile.create((InputStream)new ByteArrayInputStream("".getBytes()), false, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException exception) {
                    Status status = new Status(4, "org.eclipse.sirius.services.graphql", exception.getMessage(), (Throwable)exception);
                    SiriusGraphQLPlugin.getPlugin().log(status);
                }
                return iFile;
            }
            return null;
        };
    }
}

