/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.server.internal;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.sirius.server.internal.Messages;
import org.eclipse.sirius.server.internal.SiriusServerConfigurator;
import org.eclipse.sirius.server.internal.SiriusServerHeaderConfigurator;
import org.eclipse.sirius.server.internal.SiriusServerPlugin;

public class SiriusServerManager {
    private static final String OS_NAME = "os.name";
    private static final String WINDOWS_NAME = "win";
    private static final String ALL_INTERFACES_HOST = "0.0.0.0";
    private static final String LOCALHOST = "localhost";
    private Server server;

    public void start() {
        if (this.server == null || !this.server.isRunning()) {
            this.server = new Server();
            this.server.setHandler((Handler)new HandlerCollection());
            SiriusServerConfigurator siriusServerConfigurator = new SiriusServerConfigurator();
            siriusServerConfigurator.configure(this.server);
            SiriusServerPlugin.getPlugin().getSiriusServerConfigurators().forEach(configurator -> configurator.configure(this.server));
            SiriusServerHeaderConfigurator headerConfigurator = new SiriusServerHeaderConfigurator();
            headerConfigurator.configure(this.server);
            try {
                this.server.start();
            }
            catch (Exception exception) {
                Status status = new Status(4, "org.eclipse.sirius.server", Messages.SiriusServerManager_cannotStartServer, (Throwable)exception);
                SiriusServerPlugin.getPlugin().log(status);
            }
        }
    }

    public void stop() {
        Optional.ofNullable(this.server).ifPresent(s -> {
            try {
                s.stop();
            }
            catch (Exception exception) {
                Status status = new Status(4, "org.eclipse.sirius.server", Messages.SiriusServerManager_cannotStopServer, (Throwable)exception);
                SiriusServerPlugin.getPlugin().log(status);
            }
        });
    }

    public URI getURI() {
        URI uri = this.server.getURI();
        String osName = System.getProperty(OS_NAME).toLowerCase();
        if (osName.indexOf(WINDOWS_NAME) >= 0 && ALL_INTERFACES_HOST.equals(uri.getHost())) {
            try {
                uri = new URI(uri.getScheme(), uri.getUserInfo(), LOCALHOST, uri.getPort(), uri.getPath(), uri.getRawQuery(), uri.getRawFragment());
            }
            catch (URISyntaxException exception) {
                Status status = new Status(4, "org.eclipse.sirius.server", exception.getMessage(), (Throwable)exception);
                SiriusServerPlugin.getPlugin().getLog().log((IStatus)status);
            }
        }
        return uri;
    }
}

