/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.server.internal;

import java.io.File;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.DispatcherType;
import javax.servlet.ServletException;
import javax.servlet.SessionCookieConfig;
import javax.websocket.DeploymentException;
import javax.websocket.server.ServerEndpointConfig;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.websocket.jsr356.server.ServerContainer;
import org.eclipse.jetty.websocket.jsr356.server.deploy.WebSocketServerContainerInitializer;
import org.eclipse.sirius.server.api.ISiriusServerConfigurator;
import org.eclipse.sirius.server.api.ISiriusServerEndpointConfigurationProvider;
import org.eclipse.sirius.server.internal.Messages;
import org.eclipse.sirius.server.internal.SiriusServerErrorHandler;
import org.eclipse.sirius.server.internal.SiriusServerFilter;
import org.eclipse.sirius.server.internal.SiriusServerPlugin;

public class SiriusServerConfigurator
implements ISiriusServerConfigurator {
    private static final String HTTPS_ENABLED = "org.eclipse.sirius.server.https.enabled";
    private static final String HTTPS_HOST = "org.eclipse.sirius.server.https.host";
    private static final String HTTPS_PORT = "org.eclipse.sirius.server.https.port";
    private static final String SSL_KEYSTORE_PATH = "org.eclipse.sirius.server.ssl.keystore.path";
    private static final String SSL_KEYSTORE_PASSPHRASE = "org.eclipse.sirius.server.ssl.keystore.passphrase";
    private static final String HTTP_HOST = "org.eclipse.sirius.server.http.host";
    private static final String HTTP_PORT = "org.eclipse.sirius.server.http.port";
    private static final String DEFAULT_HOSTNAME = "0.0.0.0";
    private static final int DEFAULT_HTTP_PORT = 0;
    private static final int DEFAULT_HTTPS_PORT = 0;
    private static final String HTTP_API_CONTEXT_PATH = "/api";
    private static final String WS_API_CONTEXT_PATH = "/ws";
    private static final String ALL_PATH = "/*";

    @Override
    public void configure(Server server) {
        boolean httpsEnabled = Boolean.parseBoolean(System.getProperty(HTTPS_ENABLED));
        Connector connector = null;
        connector = httpsEnabled ? this.createHttpsConnector(server) : this.createHttpConnector(server);
        server.addConnector(connector);
        ServletContextHandler httpAPIServletContextHandler = new ServletContextHandler(5);
        httpAPIServletContextHandler.setContextPath(HTTP_API_CONTEXT_PATH);
        httpAPIServletContextHandler.setErrorHandler((ErrorHandler)new SiriusServerErrorHandler());
        SessionCookieConfig sessionCookieConfig = httpAPIServletContextHandler.getServletContext().getSessionCookieConfig();
        sessionCookieConfig.setHttpOnly(true);
        httpAPIServletContextHandler.addFilter(SiriusServerFilter.class, ALL_PATH, EnumSet.of(DispatcherType.REQUEST, DispatcherType.INCLUDE));
        ServletContextHandler wsAPIServletContextHandler = new ServletContextHandler(5);
        wsAPIServletContextHandler.setContextPath(WS_API_CONTEXT_PATH);
        Handler handler = server.getHandler();
        if (handler instanceof HandlerCollection) {
            HandlerCollection handlerCollection = (HandlerCollection)handler;
            handlerCollection.addHandler((Handler)httpAPIServletContextHandler);
            handlerCollection.addHandler((Handler)wsAPIServletContextHandler);
        }
        try {
            ServerContainer container = WebSocketServerContainerInitializer.configureContext((ServletContextHandler)wsAPIServletContextHandler);
            container.setDefaultMaxSessionIdleTimeout(0L);
            List<ISiriusServerEndpointConfigurationProvider> providers = SiriusServerPlugin.getPlugin().getEndpointConfigurationProviders();
            List endpointConfigurations = providers.stream().map(ISiriusServerEndpointConfigurationProvider::getEndpointConfiguration).collect(Collectors.toList());
            for (ServerEndpointConfig endpointConfiguration : endpointConfigurations) {
                container.addEndpoint(endpointConfiguration);
            }
        }
        catch (ServletException | DeploymentException e) {
            Status status = new Status(4, "org.eclipse.sirius.server", e.getMessage(), e);
            SiriusServerPlugin.INSTANCE.log(status);
        }
    }

    private Connector createHttpConnector(Server server) {
        HttpConfiguration httpConfiguration = new HttpConfiguration();
        httpConfiguration.setSendServerVersion(false);
        HttpConnectionFactory httpConnectionFactory = new HttpConnectionFactory(httpConfiguration);
        ServerConnector serverConnector = new ServerConnector(server, new ConnectionFactory[]{httpConnectionFactory});
        serverConnector.setHost(System.getProperty(HTTP_HOST, DEFAULT_HOSTNAME));
        serverConnector.setPort(this.handleSystemPropertiesIntegerValue(HTTP_PORT, 0));
        return serverConnector;
    }

    private Connector createHttpsConnector(Server server) {
        SslContextFactory sslContextFactory = new SslContextFactory();
        File file = new File(System.getProperty(SSL_KEYSTORE_PATH));
        file.exists();
        sslContextFactory.setKeyStorePath(file.getAbsolutePath());
        sslContextFactory.setKeyStorePassword(System.getProperty(SSL_KEYSTORE_PASSPHRASE));
        sslContextFactory.setKeyStoreType("JKS");
        sslContextFactory.setProtocol("TLS");
        sslContextFactory.setWantClientAuth(false);
        sslContextFactory.setNeedClientAuth(false);
        HttpConfiguration httpsConfiguration = new HttpConfiguration();
        httpsConfiguration.setSendServerVersion(false);
        httpsConfiguration.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        ServerConnector serverConnector = new ServerConnector(server, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, "http/1.1"), new HttpConnectionFactory(httpsConfiguration)});
        serverConnector.setHost(System.getProperty(HTTPS_HOST, DEFAULT_HOSTNAME));
        serverConnector.setPort(this.handleSystemPropertiesIntegerValue(HTTPS_PORT, 0));
        serverConnector.setIdleTimeout(30000L);
        return serverConnector;
    }

    private int handleSystemPropertiesIntegerValue(String property, int defaultValue) {
        int value = defaultValue;
        String propertyValue = System.getProperty(property);
        if (propertyValue != null && propertyValue.length() > 0) {
            try {
                value = Integer.parseInt(propertyValue);
            }
            catch (NumberFormatException exception) {
                String message = String.format(Messages.SiriusServerConfigurator_wrongPropertyTypeWarning, propertyValue);
                Status status = new Status(4, "org.eclipse.sirius.server", message, (Throwable)exception);
                SiriusServerPlugin.getPlugin().getLog().log((IStatus)status);
            }
        }
        return value;
    }
}

