/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtbot.swt.finder.widgets;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swtbot.swt.finder.exceptions.WidgetNotFoundException;
import org.eclipse.swtbot.swt.finder.results.BoolResult;
import org.eclipse.swtbot.swt.finder.results.Result;
import org.eclipse.swtbot.swt.finder.results.StringResult;
import org.eclipse.swtbot.swt.finder.results.VoidResult;
import org.eclipse.swtbot.swt.finder.results.WidgetResult;
import org.eclipse.swtbot.swt.finder.utils.MessageFormat;
import org.eclipse.swtbot.swt.finder.utils.internal.Assert;
import org.eclipse.swtbot.swt.finder.widgets.AbstractSWTBot;
import org.eclipse.swtbot.swt.finder.widgets.SiriusSWTBotTable;
import org.hamcrest.SelfDescribing;

public class SiriusSWTBotTableItem
extends AbstractSWTBot<TableItem> {
    private Table table;

    public SiriusSWTBotTableItem(TableItem tableItem) throws WidgetNotFoundException {
        this(tableItem, null);
    }

    public SiriusSWTBotTableItem(final TableItem tableItem, SelfDescribing description) throws WidgetNotFoundException {
        super((Widget)tableItem, description);
        this.table = (Table)this.syncExec((Result)new WidgetResult<Table>(){

            public Table run() {
                return tableItem.getParent();
            }
        });
    }

    public SiriusSWTBotTableItem select() {
        this.waitForEnabled();
        this.syncExec(new VoidResult(){

            public void run() {
                SiriusSWTBotTableItem.this.table.setFocus();
                SiriusSWTBotTableItem.this.table.setSelection((TableItem)SiriusSWTBotTableItem.this.widget);
            }
        });
        this.notifySelect();
        return this;
    }

    protected void clickXY(int x, int y) {
        this.log.debug((Object)MessageFormat.format((String)"Clicking on {0}", (Object[])new Object[]{this}));
        this.notifyTable(6, this.createMouseEvent(x, y, 0, 0, 0));
        this.notifyTable(26, super.createEvent());
        this.syncExec(new VoidResult(){

            public void run() {
                if (SiriusSWTBotTableItem.this.table.getSelectionCount() != 1 || !SiriusSWTBotTableItem.this.table.getSelection()[0].equals(SiriusSWTBotTableItem.this.widget)) {
                    SiriusSWTBotTableItem.this.table.setSelection((TableItem)SiriusSWTBotTableItem.this.widget);
                }
                if (!SiriusSWTBotTableItem.this.table.isFocusControl()) {
                    SiriusSWTBotTableItem.this.table.setFocus();
                }
            }
        });
        this.notifyTable(15, super.createEvent());
        this.notifyTable(3, this.createMouseEvent(x, y, 1, 0, 1));
        this.notifyTable(13);
        this.notifyTable(4, this.createMouseEvent(x, y, 1, 524288, 1));
        this.notifyTable(7, this.createMouseEvent(x, y, 0, 0, 0));
        this.notifyTable(27, super.createEvent());
        this.notifyTable(16, super.createEvent());
        this.log.debug((Object)MessageFormat.format((String)"Clicked on {0}", (Object[])new Object[]{this}));
    }

    private void notifyTable(int eventType, Event event) {
        this.notify(eventType, event, (Widget)this.table);
    }

    private void notifyTable(int event) {
        this.notifyTable(event, this.createEvent());
    }

    public SiriusSWTBotTableItem click() {
        this.waitForEnabled();
        Point center = this.getCenter(this.getBounds());
        this.clickXY(center.x, center.y);
        return this;
    }

    public SiriusSWTBotTableItem click(int column) {
        this.waitForEnabled();
        Point center = this.getCenter(this.getCellBounds(column));
        this.clickXY(center.x, center.y);
        return this;
    }

    public SiriusSWTBotTableItem doubleClick() {
        this.waitForEnabled();
        this.log.debug((Object)MessageFormat.format((String)"Double-clicking on {0}", (Object[])new Object[]{this}));
        this.notifyTable(6, this.createMouseEvent(0, 0, 0));
        this.notifyTable(26, super.createEvent());
        this.syncExec(new VoidResult(){

            public void run() {
                if (SiriusSWTBotTableItem.this.table.getSelectionCount() != 1 || !SiriusSWTBotTableItem.this.table.getSelection()[0].equals(SiriusSWTBotTableItem.this.widget)) {
                    SiriusSWTBotTableItem.this.table.setSelection((TableItem)SiriusSWTBotTableItem.this.widget);
                }
                if (!SiriusSWTBotTableItem.this.table.isFocusControl()) {
                    SiriusSWTBotTableItem.this.table.setFocus();
                }
            }
        });
        this.notifyTable(15, super.createEvent());
        this.notifyTable(3, this.createMouseEvent(1, 0, 1));
        this.notifyTable(13);
        this.notifyTable(4, this.createMouseEvent(1, 524288, 1));
        this.notifyTable(3, this.createMouseEvent(1, 0, 2));
        this.notifyTable(13);
        this.notifyTable(8, this.createMouseEvent(1, 0, 2));
        this.notifyTable(14);
        this.notifyTable(4, this.createMouseEvent(1, 524288, 2));
        this.notifyTable(7, this.createMouseEvent(0, 0, 0));
        this.notifyTable(27, super.createEvent());
        this.notifyTable(16, super.createEvent());
        this.log.debug((Object)MessageFormat.format((String)"Double-clicked on {0}", (Object[])new Object[]{this}));
        return this;
    }

    protected Control getDNDControl() {
        return this.table;
    }

    protected void dragStart() {
        this.syncExec(new VoidResult(){

            public void run() {
                SiriusSWTBotTableItem.this.table.setFocus();
                SiriusSWTBotTableItem.this.table.setSelection((TableItem)SiriusSWTBotTableItem.this.widget);
            }
        });
        this.notifyTable(26);
        this.notifyTable(15);
        this.notifyTable(3, this.createMouseEvent(1, 0, 1));
        this.notifyTable(13, this.createSelectionEvent(524288));
    }

    protected Rectangle getBounds() {
        return (Rectangle)this.syncExec((Result)new Result<Rectangle>(){

            public Rectangle run() {
                return ((TableItem)SiriusSWTBotTableItem.this.widget).getBounds();
            }
        });
    }

    private Rectangle getCellBounds(final int column) {
        return (Rectangle)this.syncExec((Result)new Result<Rectangle>(){

            public Rectangle run() {
                return ((TableItem)SiriusSWTBotTableItem.this.widget).getBounds(column);
            }
        });
    }

    private Point getCenter(Rectangle bounds) {
        return new Point(bounds.x + bounds.width / 2, bounds.y + bounds.height / 2);
    }

    public String getText() {
        return this.syncExec(new StringResult(){

            public String run() {
                return ((TableItem)SiriusSWTBotTableItem.this.widget).getText();
            }
        });
    }

    public String getText(final int index) {
        return this.syncExec(new StringResult(){

            public String run() {
                return ((TableItem)SiriusSWTBotTableItem.this.widget).getText(index);
            }
        });
    }

    public void toggleCheck() {
        this.setChecked(!this.isChecked());
    }

    public void check() {
        this.setChecked(true);
    }

    public void uncheck() {
        this.setChecked(false);
    }

    public boolean isChecked() {
        this.assertIsCheck();
        return this.syncExec(new BoolResult(){

            public Boolean run() {
                return ((TableItem)SiriusSWTBotTableItem.this.widget).getChecked();
            }
        });
    }

    public boolean isGrayed() {
        this.assertIsCheck();
        return this.syncExec(new BoolResult(){

            public Boolean run() {
                return ((TableItem)SiriusSWTBotTableItem.this.widget).getGrayed();
            }
        });
    }

    private Event createCheckEvent() {
        Event event = this.createEvent();
        event.detail = 32;
        return event;
    }

    protected Event createEvent() {
        Event event = super.createEvent();
        event.widget = this.table;
        event.item = this.widget;
        return event;
    }

    private void setChecked(final boolean checked) {
        this.waitForEnabled();
        this.assertIsCheck();
        this.syncExec(new VoidResult(){

            public void run() {
                TableItem item = (TableItem)SiriusSWTBotTableItem.this.widget;
                SiriusSWTBotTableItem.this.log.debug((Object)MessageFormat.format((String)"Setting state to {0} on: {1}", (Object[])new Object[]{checked ? "checked" : "unchecked", item.getText()}));
                item.setChecked(checked);
            }
        });
        this.notifyCheck();
    }

    private void assertIsCheck() {
        Assert.isLegal((boolean)this.hasStyle((Widget)this.table, 32), (Object)"The table does not have the style SWT.CHECK");
    }

    private void notifyCheck() {
        this.syncExec(new VoidResult(){

            public void run() {
                SiriusSWTBotTableItem.this.table.notifyListeners(13, SiriusSWTBotTableItem.this.createCheckEvent());
            }
        });
    }

    private void notifySelect() {
        this.notifyTable(6);
        this.notifyTable(5);
        this.notifyTable(26);
        this.notifyTable(15);
        this.notifyTable(3, this.createMouseEvent(1, 0, 1));
        this.notifyTable(13, this.createSelectionEvent(524288));
        this.notifyTable(4, this.createMouseEvent(1, 524288, 1));
    }

    protected void waitForEnabled() {
        new SiriusSWTBotTable(this.table).waitForEnabled();
    }

    protected Event createSelectionEvent(int stateMask) {
        Event event = super.createSelectionEvent(stateMask);
        event.item = this.widget;
        return event;
    }

    public boolean isEnabled() {
        return this.syncExec(new BoolResult(){

            public Boolean run() {
                return SiriusSWTBotTableItem.this.table.isEnabled();
            }
        });
    }

    protected Rectangle absoluteLocation() {
        return (Rectangle)this.syncExec((Result)new Result<Rectangle>(){

            public Rectangle run() {
                return SiriusSWTBotTableItem.this.display.map((Control)((TableItem)SiriusSWTBotTableItem.this.widget).getParent(), null, ((TableItem)SiriusSWTBotTableItem.this.widget).getBounds());
            }
        });
    }

    protected Event createMouseEvent(int button, int stateMask, int count) {
        Rectangle bounds = this.getBounds();
        int x = bounds.x + bounds.width / 2;
        int y = bounds.y + bounds.height / 2;
        return this.createMouseEvent(x, y, button, stateMask, count);
    }
}

