/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.disco.graph;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import org.eclipse.elk.alg.disco.graph.DCComponent;
import org.eclipse.elk.alg.disco.graph.DCExtension;
import org.eclipse.elk.core.math.ElkMath;
import org.eclipse.elk.core.math.ElkRectangle;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.math.KVectorChain;
import org.eclipse.elk.graph.properties.MapPropertyHolder;

public class DCElement
extends MapPropertyHolder {
    private static final long serialVersionUID = 58841189716563145L;
    private final KVectorChain shape;
    private final ElkRectangle bounds;
    private DCComponent cp;
    private double[] coords;
    private KVector parentCoords = null;
    private List<DCExtension> extensions = Lists.newArrayList();

    public DCElement(KVectorChain polyPath) {
        this.shape = polyPath;
        double minX = Double.POSITIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        for (KVector v : polyPath) {
            minX = Math.min(minX, v.x);
            minY = Math.min(minY, v.y);
            maxX = Math.max(maxX, v.x);
            maxY = Math.max(maxY, v.y);
        }
        this.bounds = new ElkRectangle(minX, minY, maxX - minX, maxY - minY);
    }

    public KVector getOffset() throws NullPointerException {
        return this.cp.getOffset();
    }

    public double[] getCoords() {
        if (this.coords != null) {
            return this.coords;
        }
        this.coords = new double[this.shape.size() * 2];
        Iterator it = this.shape.iterator();
        int i = 0;
        while (it.hasNext()) {
            KVector c = (KVector)it.next();
            this.coords[i] = c.x;
            this.coords[i + 1] = c.y;
            i += 2;
        }
        return this.coords;
    }

    public void addExtension(DCExtension extension) {
        this.extensions.add(extension);
    }

    public List<DCExtension> getExtensions() {
        return this.extensions;
    }

    public ElkRectangle getBounds() {
        return this.bounds;
    }

    public void setParentCoords(KVector pCoords) {
        this.parentCoords = pCoords;
    }

    public KVector getParentcoords() {
        return this.parentCoords;
    }

    void setComponent(DCComponent comp) {
        this.cp = comp;
    }

    boolean intersects(ElkRectangle rect) {
        return ElkMath.intersects((ElkRectangle)rect, (KVectorChain)this.shape) || ElkMath.contains((ElkRectangle)rect, (KVectorChain)this.shape);
    }
}

