/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.editor.tools.internal.wizards;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.sirius.editor.editorPlugin.SiriusEditorPlugin;
import org.eclipse.sirius.ui.tools.api.project.ViewpointSpecificationProject;
import org.eclipse.sirius.ui.tools.internal.wizards.pages.NewModelingProjectCreationWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public class ViewpointSpecificationProjectWizard
extends Wizard
implements INewWizard {
    public static final String ID = "org.eclipse.sirius.ui.specificationproject.wizard";
    private static final String MODULE_NAME_PREFIX = "my.project.design";
    private IProject project;
    private WizardNewProjectCreationPage newProjectPage;
    private WizardNewODesignFilePage newOdesignPage;
    private IWorkbench workbench;

    public boolean performFinish() {
        try {
            if (!this.newOdesignPage.isVsmNameChanged.booleanValue()) {
                this.newOdesignPage.modelName.setText(this.newOdesignPage.extractModelName(this.newOdesignPage.firstPage.getProjectName()));
            }
            ViewpointSpecificationProject.createNewViewpointSpecificationProject((IWorkbench)this.workbench, (String)this.newProjectPage.getProjectName(), (IPath)this.newProjectPage.getLocationPath(), (String)this.newOdesignPage.getModelName().getText(), (String)this.newOdesignPage.getInitialObjectName(), (String)this.newOdesignPage.getEncoding(), (IRunnableContext)this.getContainer());
            return true;
        }
        catch (CoreException e) {
            Status status = new Status(4, "org.eclipse.sirius.editor", 0, e.getMessage(), (Throwable)e);
            SiriusEditorPlugin.getPlugin().getLog().log((IStatus)status);
            return false;
        }
    }

    public void init(IWorkbench wkbch, IStructuredSelection sel) {
        this.workbench = wkbch;
        this.setWindowTitle("New Viewpoint Specification Project");
        this.setDefaultPageImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(SiriusEditorPlugin.INSTANCE.getImage("full/wizban/banner_viewpoint_specification_project.gif")));
    }

    public IFile getModelFile() {
        return ResourcesPlugin.getWorkspace().getRoot().getFile(this.project.getFullPath().append("description/" + this.newOdesignPage.getModelName().getText()));
    }

    public void addPages() {
        this.newProjectPage = new NewModelingProjectCreationWizardPage(SiriusEditorPlugin.getPlugin().getString("_UI_ViewpointSpecificationProjectWizard_label"));
        this.newProjectPage.setInitialProjectName(MODULE_NAME_PREFIX);
        this.newProjectPage.setTitle(SiriusEditorPlugin.getPlugin().getString("_UI_ViewpointSpecificationProjectWizard_label"));
        this.newProjectPage.setDescription(SiriusEditorPlugin.getPlugin().getString("_UI_ViewpointSpecificationProjectWizard_description"));
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.newProjectPage.getProjectName());
        this.addPage((IWizardPage)this.newProjectPage);
        this.newOdesignPage = new WizardNewODesignFilePage("ODesign Model", this.newProjectPage);
        this.newOdesignPage.setTitle(SiriusEditorPlugin.getPlugin().getString("_UI_SiriusModelWizard_label"));
        this.newOdesignPage.setDescription(SiriusEditorPlugin.getPlugin().getString("_UI_SiriusModelWizard_description"));
        this.addPage((IWizardPage)this.newOdesignPage);
        super.addPages();
    }

    private static class WizardNewODesignFilePage
    extends WizardPage {
        private static final String DOT = ".";
        private List<String> encodings;
        private Combo encodingField;
        private ModifyListener validator = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                this.setPageComplete(this.validatePage());
                isVsmNameChanged = true;
            }
        };
        private Text modelName;
        private Boolean isVsmNameChanged = false;
        private WizardNewProjectCreationPage firstPage;

        protected WizardNewODesignFilePage(String pageName, WizardNewProjectCreationPage firstPage) {
            super(pageName);
            this.firstPage = firstPage;
        }

        public Text getModelName() {
            return this.modelName;
        }

        public String getEncoding() {
            return this.encodingField.getText();
        }

        public String getInitialObjectName() {
            return ViewpointSpecificationProject.INITIAL_OBJECT_NAME;
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            layout.verticalSpacing = 12;
            composite.setLayout((Layout)layout);
            GridData data = new GridData();
            data.verticalAlignment = 4;
            data.grabExcessVerticalSpace = true;
            data.horizontalAlignment = 4;
            composite.setLayoutData((Object)data);
            Label modelNameLabel = new Label(composite, 16384);
            modelNameLabel.setText(SiriusEditorPlugin.getPlugin().getString("_UI_SiriusModelWizardName_label"));
            data = new GridData();
            data.horizontalAlignment = 4;
            modelNameLabel.setLayoutData((Object)data);
            this.modelName = new Text(composite, 18432);
            this.modelName.setText(this.extractModelName(this.firstPage.getProjectName()));
            data = new GridData();
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            this.modelName.setLayoutData((Object)data);
            this.modelName.addModifyListener(this.validator);
            Label encodingLabel = new Label(composite, 16384);
            encodingLabel.setText(SiriusEditorPlugin.getPlugin().getString("_UI_XMLEncoding"));
            data = new GridData();
            data.horizontalAlignment = 4;
            encodingLabel.setLayoutData((Object)data);
            this.encodingField = new Combo(composite, 2048);
            data = new GridData();
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            this.encodingField.setLayoutData((Object)data);
            for (String string : this.getEncodings()) {
                this.encodingField.add(string);
            }
            this.encodingField.select(0);
            this.encodingField.addModifyListener(this.validator);
            this.setPageComplete(this.validatePage());
            this.setControl((Control)composite);
        }

        protected boolean validatePage() {
            return this.getEncodings().contains(this.encodingField.getText()) && this.getModelName().getText().endsWith(DOT + ViewpointSpecificationProject.VIEWPOINT_MODEL_EXTENSION) && this.getModelName().getText().length() > ViewpointSpecificationProject.VIEWPOINT_MODEL_EXTENSION.length() + 1;
        }

        private Collection<String> getEncodings() {
            if (this.encodings == null) {
                this.encodings = new ArrayList<String>();
                StringTokenizer stringTokenizer = new StringTokenizer(SiriusEditorPlugin.getPlugin().getString("_UI_XMLEncodingChoices"));
                while (stringTokenizer.hasMoreTokens()) {
                    this.encodings.add(stringTokenizer.nextToken());
                }
            }
            return this.encodings;
        }

        public void setVisible(boolean visible) {
            if (visible && !this.isVsmNameChanged.booleanValue()) {
                this.modelName.setText(this.extractModelName(this.firstPage.getProjectName()));
            }
            super.setVisible(visible);
        }

        private String extractModelName(String projectName) {
            String[] projectNames;
            String modelPrefixName = "";
            modelPrefixName = projectName != null && projectName.contains(DOT) ? ("design".equals((projectNames = projectName.split("[.]"))[projectNames.length - 1]) ? projectNames[projectNames.length - 2] : projectNames[projectNames.length - 1]) : projectName;
            return String.valueOf(modelPrefixName) + DOT + ViewpointSpecificationProject.VIEWPOINT_MODEL_EXTENSION;
        }
    }
}

