/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.tools.internal.validation.description.constraints;

import com.google.common.collect.Iterables;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.sirius.business.api.dialect.description.MultiLanguagesValidator;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterContext;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterStatus;
import org.eclipse.sirius.common.tools.api.interpreter.TypeName;
import org.eclipse.sirius.common.tools.api.interpreter.VariableType;
import org.eclipse.sirius.tools.internal.interpreter.SiriusInterpreterContextFactory;
import org.eclipse.sirius.tools.internal.validation.AbstractConstraint;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;

public class ResolvableTypeNameConstraint
extends AbstractConstraint {
    public IStatus validate(IValidationContext ctx) {
        EObject eObj = ctx.getTarget();
        EMFEventType eventType = ctx.getEventType();
        if (eventType == EMFEventType.NULL && eObj != null) {
            for (EAttribute feat : Iterables.filter((Iterable)eObj.eClass().getEAllStructuralFeatures(), EAttribute.class)) {
                Object[] result;
                if (DescriptionPackage.Literals.TYPE_NAME != feat.getEType() || (result = this.checkIsResolvable(feat, eObj)) == null) continue;
                return ctx.createFailureStatus(result);
            }
        }
        return ctx.createSuccessStatus();
    }

    private Object[] checkIsResolvable(EAttribute domainClassFeature, EObject eObj) {
        TypeName className;
        Object value = eObj.eGet((EStructuralFeature)domainClassFeature);
        if (value instanceof String && (className = TypeName.fromString((String)((String)value))).getPackagePrefix().isPresent()) {
            IInterpreterContext context = SiriusInterpreterContextFactory.createInterpreterContext((EObject)eObj, (EStructuralFeature)domainClassFeature);
            context.getVariables().put("toCheck", VariableType.ANY_EOBJECT);
            for (IInterpreterStatus s : MultiLanguagesValidator.getInstance().validateExpression(context, "aql:toCheck.oclIsKindOf(" + className.getCompleteName("::") + ")").getStatuses()) {
                if (!"error".equals(s.getSeverity())) continue;
                return new Object[]{value, domainClassFeature.getName()};
            }
        }
        return null;
    }
}

