/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.mrtree.p2order;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;
import org.eclipse.elk.alg.mrtree.TreeLayoutPhases;
import org.eclipse.elk.alg.mrtree.graph.TEdge;
import org.eclipse.elk.alg.mrtree.graph.TGraph;
import org.eclipse.elk.alg.mrtree.graph.TNode;
import org.eclipse.elk.alg.mrtree.intermediate.IntermediateProcessorStrategy;
import org.eclipse.elk.alg.mrtree.options.InternalProperties;
import org.eclipse.elk.alg.mrtree.options.MrTreeOptions;
import org.eclipse.elk.alg.mrtree.options.OrderWeighting;
import org.eclipse.elk.core.alg.ILayoutPhase;
import org.eclipse.elk.core.alg.ILayoutProcessorFactory;
import org.eclipse.elk.core.alg.LayoutProcessorConfiguration;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.PropertyHolderComparator;

public class NodeOrderer
implements ILayoutPhase<TreeLayoutPhases, TGraph> {
    private static final LayoutProcessorConfiguration<TreeLayoutPhases, TGraph> INTERMEDIATE_PROCESSING_CONFIG = LayoutProcessorConfiguration.create().before((Enum)TreeLayoutPhases.P2_NODE_ORDERING).add((ILayoutProcessorFactory)IntermediateProcessorStrategy.ROOT_PROC).add((ILayoutProcessorFactory)IntermediateProcessorStrategy.FAN_PROC).add((ILayoutProcessorFactory)IntermediateProcessorStrategy.LEVEL_PROC);
    private OrderWeighting weighting;
    private boolean debug = false;

    public LayoutProcessorConfiguration<TreeLayoutPhases, TGraph> getLayoutProcessorConfiguration(TGraph graph) {
        return INTERMEDIATE_PROCESSING_CONFIG;
    }

    public void process(TGraph tGraph, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("Processor arrange node", 1.0f);
        this.debug = (Boolean)tGraph.getProperty(MrTreeOptions.DEBUG_MODE);
        if (this.debug) {
            progressMonitor.log((Object)"NodeOrderer!");
        }
        TNode root = tGraph.getNodes().stream().filter(x -> (Boolean)x.getProperty(InternalProperties.ROOT)).findFirst().get();
        this.weighting = (OrderWeighting)((Object)tGraph.getProperty(MrTreeOptions.WEIGHTING));
        if (this.weighting.equals((Object)OrderWeighting.FAN) || this.weighting.equals((Object)OrderWeighting.DESCENDANTS)) {
            this.orderLevelFanDescendants(Arrays.asList(root), progressMonitor.subTask(1.0f));
        } else if (this.weighting.equals((Object)OrderWeighting.CONSTRAINT)) {
            this.orderLevelConstraint(Arrays.asList(root), progressMonitor.subTask(1.0f));
        }
        progressMonitor.done();
    }

    private void orderLevelFanDescendants(List<TNode> currentLevel, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("Processor arrange level", 1.0f);
        IProperty<Integer> sortProperty = InternalProperties.FAN;
        if (this.weighting.equals((Object)OrderWeighting.DESCENDANTS)) {
            sortProperty = InternalProperties.DESCENDANTS;
        }
        int pos = 0;
        Collections.sort(currentLevel, PropertyHolderComparator.with(sortProperty));
        int firstOcc = currentLevel.size();
        ListIterator<TNode> it = currentLevel.listIterator(currentLevel.size());
        boolean notNull = true;
        while (notNull && it.hasPrevious()) {
            TNode tNode = it.previous();
            if ((Integer)tNode.getProperty(sortProperty) == 0) {
                --firstOcc;
                continue;
            }
            notNull = false;
        }
        List<TNode> tmp = currentLevel.subList(0, firstOcc);
        LinkedList<TNode> inners = new LinkedList<TNode>(tmp);
        tmp = currentLevel.subList(firstOcc, currentLevel.size());
        LinkedList<TNode> leaves = new LinkedList<TNode>(tmp);
        if (inners.isEmpty()) {
            for (TNode tENode : leaves) {
                tENode.setProperty(InternalProperties.POSITION, pos++);
            }
        } else {
            int size = inners.size();
            for (TNode tPNode : inners) {
                tPNode.setProperty(InternalProperties.POSITION, pos++);
                LinkedList<TNode> children = tPNode.getChildrenCopy();
                this.orderLevelFanDescendants(children, progressMonitor.subTask((float)(1 / size)));
                Collections.sort(children, Collections.reverseOrder(PropertyHolderComparator.with(InternalProperties.POSITION)));
                LinkedList<TEdge> sortedOutEdges = new LinkedList<TEdge>();
                for (TNode tNode : children) {
                    for (TEdge tEdge : tPNode.getOutgoingEdges()) {
                        if (tEdge.getTarget() != tNode) continue;
                        sortedOutEdges.add(tEdge);
                    }
                }
                tPNode.getOutgoingEdges().clear();
                tPNode.getOutgoingEdges().addAll(sortedOutEdges);
                it = leaves.listIterator(leaves.size());
                int fillGap = tPNode.getOutgoingEdges().size();
                notNull = true;
                while (fillGap > 0 && notNull && it.hasPrevious()) {
                    TNode tNode = it.previous();
                    if ((Integer)tNode.getProperty(sortProperty) == 0) {
                        tNode.setProperty(InternalProperties.POSITION, pos++);
                        --fillGap;
                        it.remove();
                        continue;
                    }
                    notNull = false;
                }
            }
        }
        progressMonitor.done();
    }

    private void orderLevelConstraint(List<TNode> currentLevel, IElkProgressMonitor progressMonitor) {
        TNode[] inners;
        int targetPos;
        TNode curNode;
        progressMonitor.begin("Processor arrange level", 1.0f);
        if (this.debug) {
            progressMonitor.log((Object)"OrderLevelConstraint!");
        }
        List undefinedNodes = currentLevel.stream().filter(x -> (Integer)x.getProperty(MrTreeOptions.POSITION_CONSTRAINT) < 0).collect(Collectors.toList());
        List inBoundNodes = currentLevel.stream().filter(x -> (Integer)x.getProperty(MrTreeOptions.POSITION_CONSTRAINT) < currentLevel.size() && (Integer)x.getProperty(MrTreeOptions.POSITION_CONSTRAINT) >= 0).collect(Collectors.toList());
        List outOfBoundNodes = currentLevel.stream().filter(x -> (Integer)x.getProperty(MrTreeOptions.POSITION_CONSTRAINT) >= currentLevel.size()).collect(Collectors.toList());
        TNode[] sortedNodes = new TNode[currentLevel.size()];
        int i = 0;
        while (i < inBoundNodes.size()) {
            curNode = (TNode)((Object)inBoundNodes.get(i));
            targetPos = (Integer)curNode.getProperty(MrTreeOptions.POSITION_CONSTRAINT);
            if (targetPos >= 0 && targetPos < inBoundNodes.size() && sortedNodes[targetPos] == null) {
                sortedNodes[targetPos] = curNode;
                inBoundNodes.remove(i);
                --i;
            }
            ++i;
        }
        i = 0;
        while (i < inBoundNodes.size()) {
            curNode = (TNode)((Object)inBoundNodes.get(i));
            targetPos = (Integer)curNode.getProperty(MrTreeOptions.POSITION_CONSTRAINT);
            int j = 0;
            while (true) {
                int newTargetPos;
                if ((newTargetPos = targetPos + j) < sortedNodes.length && newTargetPos >= 0 && sortedNodes[newTargetPos] == null) {
                    sortedNodes[newTargetPos] = curNode;
                    inBoundNodes.remove(i);
                    --i;
                    break;
                }
                newTargetPos = targetPos - j;
                if (newTargetPos < sortedNodes.length && newTargetPos >= 0 && sortedNodes[newTargetPos] == null) {
                    sortedNodes[newTargetPos] = curNode;
                    inBoundNodes.remove(i);
                    --i;
                    break;
                }
                ++j;
            }
            ++i;
        }
        outOfBoundNodes.sort((x, y) -> -Integer.compare((Integer)x.getProperty(MrTreeOptions.POSITION_CONSTRAINT), (Integer)y.getProperty(MrTreeOptions.POSITION_CONSTRAINT)));
        i = sortedNodes.length - 1;
        while (i >= 0) {
            if (sortedNodes[i] == null && !outOfBoundNodes.isEmpty()) {
                sortedNodes[i] = (TNode)((Object)outOfBoundNodes.get(0));
                outOfBoundNodes.remove(0);
            }
            --i;
        }
        i = 0;
        while (i < sortedNodes.length) {
            if (sortedNodes[i] == null && !undefinedNodes.isEmpty()) {
                sortedNodes[i] = (TNode)((Object)undefinedNodes.get(0));
                undefinedNodes.remove(0);
            }
            ++i;
        }
        i = 0;
        while (i < sortedNodes.length) {
            sortedNodes[i].setProperty(InternalProperties.POSITION, i);
            ++i;
        }
        TNode[] tNodeArray = inners = (TNode[])currentLevel.stream().filter(x -> (Integer)x.getProperty(InternalProperties.FAN) != 0).toArray(TNode[]::new);
        int n = inners.length;
        int n2 = 0;
        while (n2 < n) {
            TNode tPNode = tNodeArray[n2];
            LinkedList<TNode> children = tPNode.getChildrenCopy();
            this.orderLevelConstraint(children, progressMonitor.subTask((float)(1 / inners.length)));
            Collections.sort(children, PropertyHolderComparator.with(InternalProperties.POSITION));
            LinkedList<TEdge> sortedOutEdges = new LinkedList<TEdge>();
            for (TNode tNode : children) {
                for (TEdge tEdge : tPNode.getOutgoingEdges()) {
                    if (tEdge.getTarget() != tNode) continue;
                    sortedOutEdges.add(tEdge);
                }
            }
            tPNode.getOutgoingEdges().clear();
            tPNode.getOutgoingEdges().addAll(sortedOutEdges);
            ++n2;
        }
        progressMonitor.done();
    }
}

