/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate.wrapping;

import java.util.Iterator;
import java.util.List;
import java.util.function.BinaryOperator;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.core.options.Direction;

public class GraphStats {
    public final LGraph graph;
    private double spacing = 0.0;
    private double inLayerSpacing = 0.0;
    public final double dar;
    public final int longestPath;
    private Double maxWidth;
    private Double maxHeight;
    private Double sumWidth;
    private double[] widths;
    private double[] heights;
    private boolean[] cutsAllowed;

    public GraphStats(LGraph graph) {
        this.graph = graph;
        Direction dir = (Direction)graph.getProperty(LayeredOptions.DIRECTION);
        double aspectRatio = (Double)graph.getProperty(LayeredOptions.ASPECT_RATIO);
        double correction = (Double)graph.getProperty(LayeredOptions.WRAPPING_CORRECTION_FACTOR);
        this.dar = dir == Direction.LEFT || dir == Direction.RIGHT || dir == Direction.UNDEFINED ? aspectRatio * correction : 1.0 / (aspectRatio * correction);
        this.spacing = (Double)graph.getProperty(LayeredOptions.SPACING_NODE_NODE_BETWEEN_LAYERS);
        this.inLayerSpacing = (Double)graph.getProperty(LayeredOptions.SPACING_NODE_NODE);
        this.longestPath = graph.getLayers().size();
    }

    public double getApproximateLayerWidth(Layer l) {
        return this.determineLayerWidth(l);
    }

    public double getApproximateLayeringWidth() {
        return this.getSumWidth();
    }

    public double getApproximateChunkBasedLayeringWidth(List<Integer> cuts) {
        if (cuts.isEmpty()) {
            return this.getApproximateLayeringWidth();
        }
        double width = 0.0;
        int lowIdx = 0;
        for (Integer highIdx : cuts) {
            width = Math.max(width, this.determineChunkWidth(lowIdx, highIdx));
            lowIdx = highIdx;
        }
        width = Math.max(width, this.determineChunkWidth(lowIdx, this.graph.getLayers().size()));
        return width;
    }

    public double getApproximateLayerHeight(Layer l) {
        return this.determineLayerHeight(l);
    }

    public double getApproximateLayeringHeight() {
        return this.getMaxHeight();
    }

    public double getApproximateChunkBasedLayeringHeight(List<Integer> cuts) {
        if (cuts.isEmpty()) {
            return 0.0;
        }
        double height = 0.0;
        int lowIdx = 0;
        for (Integer highIdx : cuts) {
            height += this.determineChunkHeight(lowIdx, highIdx);
            lowIdx = highIdx;
        }
        return height += this.determineChunkHeight(lowIdx, this.graph.getLayers().size());
    }

    public double getMaxWidth() {
        if (this.maxWidth == null) {
            this.maxWidth = this.determineWidth(Math::max);
        }
        return this.maxWidth;
    }

    public double getSumWidth() {
        if (this.sumWidth == null) {
            this.sumWidth = this.determineWidth((a, b) -> a + b);
        }
        return this.sumWidth;
    }

    public double[] getWidths() {
        if (this.widths == null) {
            this.initWidthsAndHeights();
        }
        return this.widths;
    }

    private void initWidthsAndHeights() {
        int n = this.longestPath;
        this.widths = new double[n];
        this.heights = new double[n];
        int i = 0;
        while (i < n) {
            Layer l = this.graph.getLayers().get(i);
            this.widths[i] = this.determineLayerWidth(l);
            this.heights[i] = this.determineLayerHeight(l);
            ++i;
        }
    }

    private double determineWidth(BinaryOperator<Double> fun) {
        return this.graph.getLayers().stream().map(l -> this.determineLayerWidth((Layer)l)).reduce(fun).get();
    }

    private double determineLayerWidth(Layer l) {
        double maxW = 0.0;
        for (LNode n : l.getNodes()) {
            double nW = n.getSize().x + n.getMargin().right + n.getMargin().left + this.spacing;
            maxW = Math.max(maxW, nW);
        }
        return maxW;
    }

    private double determineChunkWidth(int lowIdx, int highIdx) {
        return this.graph.getLayers().subList(lowIdx, highIdx).stream().mapToDouble(l -> this.determineLayerWidth((Layer)l)).reduce(Double::sum).orElse(0.0);
    }

    public double getMaxHeight() {
        if (this.maxHeight == null) {
            this.maxHeight = this.determineHeight(Math::max);
        }
        return this.maxHeight;
    }

    public double[] getHeights() {
        if (this.heights == null) {
            this.initWidthsAndHeights();
        }
        return this.heights;
    }

    private double determineHeight(BinaryOperator<Double> fun) {
        return this.graph.getLayers().stream().map(l -> this.determineLayerHeight((Layer)l)).reduce(fun).get();
    }

    private double determineLayerHeight(Layer layer) {
        double lH = 0.0;
        for (LNode n : layer.getNodes()) {
            lH += n.getSize().y + n.getMargin().bottom + n.getMargin().top + this.inLayerSpacing;
            for (LEdge inc : n.getIncomingEdges()) {
                if (inc.getSource().getNode().getType() != LNode.NodeType.NORTH_SOUTH_PORT) continue;
                LNode src = inc.getSource().getNode();
                LNode origin = (LNode)((Object)src.getProperty(InternalProperties.ORIGIN));
                lH += origin.getSize().y + origin.getMargin().bottom + origin.getMargin().top;
            }
        }
        return lH;
    }

    private double determineChunkHeight(int lowIdx, int highIdx) {
        return this.graph.getLayers().subList(lowIdx, highIdx).stream().mapToDouble(l -> this.determineLayerHeight((Layer)l)).max().orElse(0.0);
    }

    public boolean isCutAllowed(int layerIndex) {
        if (this.cutsAllowed == null) {
            this.initCutAllowed();
        }
        return this.cutsAllowed[layerIndex];
    }

    private void initCutAllowed() {
        if (this.cutsAllowed != null) {
            return;
        }
        this.cutsAllowed = new boolean[this.graph.getLayers().size()];
        this.cutsAllowed[0] = false;
        if (this.graph.hasProperty(LayeredOptions.WRAPPING_VALIDIFY_FORBIDDEN_INDICES)) {
            List forbidden = (List)this.graph.getProperty(LayeredOptions.WRAPPING_VALIDIFY_FORBIDDEN_INDICES);
            Iterator iterator = forbidden.iterator();
            while (iterator.hasNext()) {
                int f = (Integer)iterator.next();
                if (f <= 0 || f >= this.cutsAllowed.length) continue;
                this.cutsAllowed[f] = false;
            }
        } else {
            Iterator<Layer> layerIt = this.graph.getLayers().iterator();
            if (layerIt.hasNext()) {
                layerIt.next();
            }
            int i = 1;
            while (layerIt.hasNext()) {
                Layer layer = layerIt.next();
                this.cutsAllowed[i++] = this.isCutAllowed(layer);
            }
        }
    }

    public boolean[] getCutsAllowed() {
        if (this.cutsAllowed == null) {
            this.initCutAllowed();
        }
        return this.cutsAllowed;
    }

    private boolean isCutAllowed(Layer layer) {
        boolean cutAllowed = true;
        LNode n1 = null;
        LNode n2 = null;
        block0: for (LNode tgt : layer.getNodes()) {
            for (LEdge e : tgt.getIncomingEdges()) {
                if (n1 != null && n1 != tgt) {
                    cutAllowed = false;
                    break block0;
                }
                n1 = tgt;
                LNode src = e.getSource().getNode();
                if (n2 != null && n2 != src) {
                    cutAllowed = false;
                    break block0;
                }
                n2 = src;
            }
        }
        return cutAllowed;
    }
}

