/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p4nodes.bk;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.core.util.Pair;

public final class NeighborhoodInformation {
    public int nodeCount;
    public int[] layerIndex;
    public int[] nodeIndex;
    public List<List<Pair<LNode, LEdge>>> leftNeighbors;
    public List<List<Pair<LNode, LEdge>>> rightNeighbors;
    private NeighborComparator neighborComparator;

    private NeighborhoodInformation() {
    }

    public void cleanup() {
        this.layerIndex = null;
        this.nodeIndex = null;
        this.leftNeighbors.clear();
        this.rightNeighbors.clear();
        this.neighborComparator = null;
    }

    public static NeighborhoodInformation buildFor(LGraph graph) {
        NeighborhoodInformation ni = new NeighborhoodInformation();
        ni.nodeCount = 0;
        for (Layer layer : graph) {
            ni.nodeCount += layer.getNodes().size();
        }
        int lId = 0;
        int lIndex = 0;
        ni.layerIndex = new int[graph.getLayers().size()];
        int nId = 0;
        int nIndex = 0;
        ni.nodeIndex = new int[ni.nodeCount];
        for (Layer l : graph.getLayers()) {
            l.id = lId++;
            ni.layerIndex[l.id] = lIndex++;
            nIndex = 0;
            for (LNode n : l.getNodes()) {
                n.id = nId++;
                ni.nodeIndex[n.id] = nIndex++;
            }
        }
        ni.neighborComparator = ni.new NeighborComparator();
        ni.leftNeighbors = Lists.newArrayListWithCapacity((int)ni.nodeCount);
        NeighborhoodInformation.determineAllLeftNeighbors(ni, graph);
        ni.rightNeighbors = Lists.newArrayListWithCapacity((int)ni.nodeCount);
        NeighborhoodInformation.determineAllRightNeighbors(ni, graph);
        return ni;
    }

    private static void determineAllRightNeighbors(NeighborhoodInformation ni, LGraph graph) {
        for (Layer l : graph) {
            for (LNode n : l) {
                ArrayList result = Lists.newArrayList();
                int maxPriority = 0;
                for (LEdge edge : n.getOutgoingEdges()) {
                    if (edge.isSelfLoop() || edge.isInLayerEdge()) continue;
                    int edgePrio = (Integer)edge.getProperty(LayeredOptions.PRIORITY_STRAIGHTNESS);
                    if (edgePrio > maxPriority) {
                        maxPriority = edgePrio;
                        result.clear();
                    }
                    if (edgePrio != maxPriority) continue;
                    result.add(Pair.of((Object)((Object)edge.getTarget().getNode()), (Object)((Object)edge)));
                }
                Collections.sort(result, ni.neighborComparator);
                ni.rightNeighbors.add(n.id, result);
            }
        }
    }

    private static void determineAllLeftNeighbors(NeighborhoodInformation ni, LGraph graph) {
        for (Layer l : graph) {
            for (LNode n : l) {
                ArrayList result = Lists.newArrayList();
                int maxPriority = 0;
                for (LEdge edge : n.getIncomingEdges()) {
                    if (edge.isSelfLoop() || edge.isInLayerEdge()) continue;
                    int edgePrio = (Integer)edge.getProperty(LayeredOptions.PRIORITY_STRAIGHTNESS);
                    if (edgePrio > maxPriority) {
                        maxPriority = edgePrio;
                        result.clear();
                    }
                    if (edgePrio != maxPriority) continue;
                    result.add(Pair.of((Object)((Object)edge.getSource().getNode()), (Object)((Object)edge)));
                }
                Collections.sort(result, ni.neighborComparator);
                ni.leftNeighbors.add(n.id, result);
            }
        }
    }

    private final class NeighborComparator
    implements Comparator<Pair<LNode, LEdge>> {
        private NeighborComparator() {
        }

        @Override
        public int compare(Pair<LNode, LEdge> o1, Pair<LNode, LEdge> o2) {
            int cmp = NeighborhoodInformation.this.nodeIndex[((LNode)((Object)o1.getFirst())).id] - NeighborhoodInformation.this.nodeIndex[((LNode)((Object)o2.getFirst())).id];
            return (int)Math.signum(cmp);
        }
    }
}

