/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.internal.tool.command.builders;

import java.util.HashMap;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.helper.task.InitInterpreterVariablesTask;
import org.eclipse.sirius.business.api.helper.task.UnexecutableTask;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.description.tool.NodeCreationDescription;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Gate;
import org.eclipse.sirius.diagram.sequence.description.tool.GateCreationTool;
import org.eclipse.sirius.diagram.sequence.description.tool.OrderedElementCreationTool;
import org.eclipse.sirius.diagram.sequence.internal.tool.command.builders.SequenceCreatedEventsFlaggingSiriusCommand;
import org.eclipse.sirius.diagram.sequence.ordering.EventEnd;
import org.eclipse.sirius.diagram.tools.internal.command.builders.NodeCreationCommandBuilder;
import org.eclipse.sirius.tools.api.command.DCommand;
import org.eclipse.sirius.tools.api.interpreter.InterpreterUtil;
import org.eclipse.sirius.viewpoint.DRepresentation;

public class GateCreationCommandBuilder
extends NodeCreationCommandBuilder {
    protected EventEnd startingEndPredecessor;
    protected EventEnd finishingEndPredecessor;
    private Point location;

    public GateCreationCommandBuilder(GateCreationTool tool, DDiagramElementContainer node, EventEnd startingEndPredecessor, EventEnd finishingEndPredecessor, Point location) {
        super((NodeCreationDescription)tool, (DDiagramElement)node);
        this.startingEndPredecessor = startingEndPredecessor;
        this.finishingEndPredecessor = finishingEndPredecessor;
        this.location = location;
    }

    protected DCommand buildCreateNodeCommandFromTool(EObject semanticContainer, EObject container) {
        DCommand result = this.createEnclosingCommand();
        if (this.location != null && result instanceof SequenceCreatedEventsFlaggingSiriusCommand) {
            ((SequenceCreatedEventsFlaggingSiriusCommand)result).setLostNodesLocation(this.location);
        }
        if (this.permissionAuthority.canEditInstance((EObject)this.diagramElement)) {
            IInterpreter interpreter = InterpreterUtil.getInterpreter((EObject)semanticContainer);
            HashMap<Object, Object> variables = new HashMap<Object, Object>();
            result.getTasks().add(new InitInterpreterVariablesTask(variables, interpreter, this.uiCallback));
            variables.put(this.tool.getVariable(), semanticContainer);
            variables.put(this.tool.getViewVariable(), container);
            if (this.tool instanceof OrderedElementCreationTool) {
                OrderedElementCreationTool orderedElementCreationTool = (OrderedElementCreationTool)this.tool;
                variables.put(orderedElementCreationTool.getStartingEndPredecessor(), this.startingEndPredecessor);
                variables.put(orderedElementCreationTool.getFinishingEndPredecessor(), this.finishingEndPredecessor);
            }
            this.addDiagramVariable(result, container, interpreter);
            if (this.tool.getInitialOperation().getFirstModelOperations() != null) {
                result.getTasks().add(this.taskHelper.buildTaskFromModelOperation((DRepresentation)this.diagram, semanticContainer, this.tool.getInitialOperation().getFirstModelOperations()));
            }
        } else {
            result.getTasks().add(UnexecutableTask.INSTANCE);
        }
        return result;
    }

    protected DCommand createEnclosingCommand() {
        return new SequenceCreatedEventsFlaggingSiriusCommand(this.editingDomain, this.getEnclosingCommandLabel(), this.diagram, Gate.viewpointElementPredicate());
    }

    protected boolean evaluatePrecondition(IInterpreter interpreter, EObject semanticContainer, String precondition) {
        if (this.tool instanceof OrderedElementCreationTool) {
            OrderedElementCreationTool orderedElementCreationTool = (OrderedElementCreationTool)this.tool;
            interpreter.setVariable(orderedElementCreationTool.getStartingEndPredecessor().getName(), (Object)this.startingEndPredecessor);
            interpreter.setVariable(orderedElementCreationTool.getFinishingEndPredecessor().getName(), (Object)this.finishingEndPredecessor);
        }
        boolean result = super.evaluatePrecondition(interpreter, semanticContainer, precondition);
        if (this.tool instanceof OrderedElementCreationTool) {
            OrderedElementCreationTool orderedElementCreationTool = (OrderedElementCreationTool)this.tool;
            interpreter.unSetVariable(orderedElementCreationTool.getStartingEndPredecessor().getName());
            interpreter.unSetVariable(orderedElementCreationTool.getFinishingEndPredecessor().getName());
        }
        return result;
    }
}

