/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.query;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public class ViewpointURIQuery {
    public static final String VIEWPOINT_URI_SCHEME = "viewpoint";
    private final URI uri;

    public ViewpointURIQuery(URI uri) {
        Preconditions.checkArgument((boolean)ViewpointURIQuery.isValidViewpointURI(uri));
        this.uri = uri;
    }

    public static boolean isValidViewpointURI(URI uri) {
        boolean usesViewpointScheme;
        boolean bl = usesViewpointScheme = uri != null && VIEWPOINT_URI_SCHEME.equals(uri.scheme());
        return usesViewpointScheme && uri.segmentCount() >= 2;
    }

    public static Option<URI> asViewpointURI(URI uri, ResourceSet resourceSet) {
        Option result = Options.newNone();
        if (uri.isPlatform()) {
            EObject target;
            block7: {
                target = null;
                try {
                    target = resourceSet.getEObject(uri, true);
                }
                catch (WrappedException e) {
                    if (!(e.getCause() instanceof IOException) || !uri.isPlatformPlugin()) break block7;
                    URI convertedResourceUri = URI.createPlatformResourceURI((String)uri.toPlatformString(true), (boolean)true).appendFragment(uri.fragment());
                    target = resourceSet.getEObject(convertedResourceUri, true);
                }
            }
            if (target != null) {
                String pluginId = uri.segment(1);
                if (target instanceof Viewpoint) {
                    String viewpointName = ((Viewpoint)target).getName();
                    URI logicalViewpointUri = URI.createURI((String)("viewpoint:/" + pluginId + "/" + viewpointName));
                    result = Options.newSome((Object)logicalViewpointUri);
                } else {
                    Option<EObject> viewpointContext = new EObjectQuery(target).getFirstAncestorOfType(DescriptionPackage.eINSTANCE.getViewpoint());
                    if (viewpointContext.some()) {
                        String viewpointName = ((Viewpoint)viewpointContext.get()).getName();
                        URI logicalViewpointUri = URI.createURI((String)("viewpoint:/" + pluginId + "/" + viewpointName));
                        result = Options.newSome((Object)logicalViewpointUri.appendFragment(uri.fragment()));
                    }
                }
            }
        }
        return result;
    }

    public String getPluginId() {
        return this.uri.segment(0);
    }

    public String getViewpointName() {
        return URI.decode((String)this.uri.segment(1));
    }

    public URI getBaseURI() {
        return this.uri.trimFragment();
    }
}

