/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.helper.task.operations;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.helper.task.ICreationTask;
import org.eclipse.sirius.business.internal.helper.task.operations.AbstractOperationTask;
import org.eclipse.sirius.business.internal.helper.task.operations.InterpretedExpressionVariableTask;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ecore.extender.business.api.accessor.exception.FeatureNotFoundException;
import org.eclipse.sirius.ecore.extender.business.api.accessor.exception.MetaClassNotFoundException;
import org.eclipse.sirius.tools.api.Messages;
import org.eclipse.sirius.tools.api.SiriusPlugin;
import org.eclipse.sirius.tools.api.command.CommandContext;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.description.tool.CreateInstance;

public class CreateInstanceTask
extends AbstractOperationTask
implements ICreationTask {
    private CreateInstance createOp;
    private EObject target;
    private String referenceName;
    private EObject instance;

    public CreateInstanceTask(CommandContext context, ModelAccessor extPackage, CreateInstance createInstance, IInterpreter interpreter) {
        super(context, extPackage, interpreter);
        this.createOp = createInstance;
    }

    @Override
    public void execute() throws MetaClassNotFoundException, FeatureNotFoundException {
        this.target = this.context.getCurrentTarget();
        String typeName = this.getFeatureName(this.target, (EObject)this.createOp, this.createOp.getTypeName());
        this.instance = this.extPackage.createInstance(typeName);
        if (this.instance == null) {
            SiriusPlugin.getDefault().error(MessageFormat.format(Messages.CreateInstanceTask_creationErrorMsg, typeName), new RuntimeException());
        } else {
            Object value;
            if (!StringUtil.isEmpty((String)this.createOp.getVariableName())) {
                InterpretedExpressionVariableTask childTask = new InterpretedExpressionVariableTask(this.context, this.extPackage, 0, this.createOp.getVariableName(), this.instance, this.interpreter);
                childTask.execute();
            }
            this.referenceName = this.getFeatureName(this.target, (EObject)this.createOp, this.createOp.getReferenceName());
            if (!this.extPackage.eIsMany(this.target, this.referenceName) && (value = this.extPackage.eGet(this.target, this.referenceName)) != null) {
                SiriusPlugin.getDefault().error(MessageFormat.format(Messages.CreateInstanceTask_addToRefErrorMsg, this.referenceName, this.target), new RuntimeException());
                return;
            }
            this.extPackage.eAdd(this.target, this.referenceName, (Object)this.instance);
            this.context.setNextPushEObject(this.instance);
        }
    }

    @Override
    public String getLabel() {
        return Messages.CreateInstanceTask_label;
    }

    @Override
    public Collection<EObject> getCreatedElements() {
        HashSet<EObject> result = new HashSet<EObject>(1);
        if (this.instance != null) {
            result.add(this.instance);
        }
        return result;
    }

    @Override
    public Collection<EObject> getAffectedElements() {
        HashSet<EObject> result = new HashSet<EObject>(1);
        if (this.target != null) {
            result.add(this.target);
        }
        return result;
    }

    @Override
    public Collection<EObject> getCreatedReferences() {
        return Collections.emptySet();
    }

    @Override
    public Collection<DRepresentationElement> getCreatedRepresentationElements() {
        return Collections.emptySet();
    }
}

