/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.sample.migration.design;

import java.util.Map;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolylineDecoration;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.common.ui.tools.api.util.EclipseUIUtil;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.ui.business.api.view.SiriusGMFHelper;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractNotSelectableShapeNodeEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DNodeContainer2EditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DNodeContainerEditPart;
import org.eclipse.sirius.ext.draw2d.figure.ViewGradientFigureDesc;
import org.eclipse.sirius.ext.gmf.runtime.gef.ui.figures.ViewNodeContainerFigureDesc;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.IEditorPart;

public class LayoutHelper {
    public static PointList getBendpoints(DEdge edge) {
        IFigure figure = LayoutHelper.getFigure((DDiagramElement)edge);
        if (figure instanceof Connection) {
            return ((Connection)figure).getPoints();
        }
        return null;
    }

    public static Rectangle getDraw2DBounds(DDiagramElement diagramElement) {
        IFigure figure = LayoutHelper.getFigure(diagramElement);
        if (figure != null) {
            return figure.getBounds();
        }
        return null;
    }

    public static Color getForegroundColor(DDiagramElement diagramElement) {
        IFigure figure = LayoutHelper.getFigureByType(diagramElement, PolylineDecoration.class);
        if (figure != null) {
            return figure.getForegroundColor();
        }
        return null;
    }

    public static Color getBackgroundColor(DDiagramElement diagramElement) {
        NodeFigure nodeFigure;
        IFigure figure = null;
        if (diagramElement instanceof DNode && (nodeFigure = LayoutHelper.getNodeFigure((DNode)diagramElement)) != null) {
            figure = (IFigure)nodeFigure.getChildren().get(0);
        }
        if (diagramElement instanceof DNodeContainer) {
            DNodeContainerEditPart editPart;
            ViewNodeContainerFigureDesc containerFigureDesc;
            IGraphicalEditPart graphicalEditPart = LayoutHelper.getEditPart(diagramElement);
            if (graphicalEditPart instanceof DNodeContainerEditPart && (containerFigureDesc = (editPart = (DNodeContainerEditPart)graphicalEditPart).getPrimaryShape()) instanceof ViewGradientFigureDesc) {
                return ((ViewGradientFigureDesc)containerFigureDesc).getBackgroundColor();
            }
            if (graphicalEditPart instanceof DNodeContainer2EditPart && (containerFigureDesc = (editPart = (DNodeContainer2EditPart)graphicalEditPart).getPrimaryShape()) instanceof ViewGradientFigureDesc) {
                return ((ViewGradientFigureDesc)containerFigureDesc).getBackgroundColor();
            }
        }
        if (figure != null) {
            return figure.getBackgroundColor();
        }
        return null;
    }

    public static Color getGradientColor(DDiagramElement diagramElement) {
        if (diagramElement instanceof DNodeContainer) {
            DNodeContainerEditPart editPart;
            ViewNodeContainerFigureDesc containerFigureDesc;
            IGraphicalEditPart graphicalEditPart = LayoutHelper.getEditPart(diagramElement);
            if (graphicalEditPart instanceof DNodeContainerEditPart && (containerFigureDesc = (editPart = (DNodeContainerEditPart)graphicalEditPart).getPrimaryShape()) instanceof ViewGradientFigureDesc) {
                return ((ViewGradientFigureDesc)containerFigureDesc).getGradientColor();
            }
            if (graphicalEditPart instanceof DNodeContainer2EditPart && (containerFigureDesc = (editPart = (DNodeContainer2EditPart)graphicalEditPart).getPrimaryShape()) instanceof ViewGradientFigureDesc) {
                return ((ViewGradientFigureDesc)containerFigureDesc).getGradientColor();
            }
        }
        return null;
    }

    private static NodeFigure getNodeFigure(DNode dNode) {
        IFigure expectedNodefigure;
        AbstractNotSelectableShapeNodeEditPart shapeNodeEditPart = null;
        IGraphicalEditPart editPart = LayoutHelper.getEditPart((DDiagramElement)dNode);
        for (Object childEditPart : editPart.getChildren()) {
            if (!(childEditPart instanceof AbstractNotSelectableShapeNodeEditPart)) continue;
            shapeNodeEditPart = (AbstractNotSelectableShapeNodeEditPart)childEditPart;
            break;
        }
        if (shapeNodeEditPart != null && (expectedNodefigure = shapeNodeEditPart.getFigure()) instanceof NodeFigure) {
            return (NodeFigure)expectedNodefigure;
        }
        return null;
    }

    public static Integer getBackgroundStyle(DDiagramElement diagramElement) {
        if (diagramElement instanceof DNodeContainer) {
            DNodeContainerEditPart editPart;
            ViewNodeContainerFigureDesc containerFigureDesc;
            IGraphicalEditPart graphicalEditPart = LayoutHelper.getEditPart(diagramElement);
            if (graphicalEditPart instanceof DNodeContainerEditPart && (containerFigureDesc = (editPart = (DNodeContainerEditPart)graphicalEditPart).getPrimaryShape()) instanceof ViewGradientFigureDesc) {
                return ((ViewGradientFigureDesc)containerFigureDesc).getBackgroundStyle();
            }
            if (graphicalEditPart instanceof DNodeContainer2EditPart && (containerFigureDesc = (editPart = (DNodeContainer2EditPart)graphicalEditPart).getPrimaryShape()) instanceof ViewGradientFigureDesc) {
                return ((ViewGradientFigureDesc)containerFigureDesc).getBackgroundStyle();
            }
        }
        return null;
    }

    private static View getGMFView(DDiagramElement element) {
        return SiriusGMFHelper.getGmfView((DDiagramElement)element);
    }

    private static IFigure getFigure(DDiagramElement diagramElement) {
        IGraphicalEditPart editPart = LayoutHelper.getEditPart(diagramElement);
        if (editPart != null) {
            return editPart.getFigure();
        }
        return null;
    }

    private static IFigure getFigureByType(DDiagramElement diagramElement, Class type) {
        IGraphicalEditPart editPart = LayoutHelper.getEditPart(diagramElement);
        if (editPart != null) {
            IFigure figure = editPart.getFigure();
            return LayoutHelper.getFigure(figure, type);
        }
        return null;
    }

    private static IFigure getFigure(IFigure figure, Class type) {
        if (figure.getClass() == type) {
            return figure;
        }
        for (Object currentFigure : figure.getChildren()) {
            IFigure tempFigure;
            if (!(currentFigure instanceof IFigure) || (tempFigure = LayoutHelper.getFigure((IFigure)currentFigure, type)) == null) continue;
            return tempFigure;
        }
        return null;
    }

    public static IGraphicalEditPart getEditPart(DDiagramElement diagramElement) {
        Map editPartRegistry;
        Object editPart;
        View gmfView;
        IEditorPart editor = EclipseUIUtil.getActiveEditor();
        if (editor instanceof DiagramEditor && (gmfView = LayoutHelper.getGMFView(diagramElement)) != null && (editPart = (editPartRegistry = ((DiagramEditor)editor).getDiagramGraphicalViewer().getEditPartRegistry()).get(gmfView)) instanceof IGraphicalEditPart) {
            return (IGraphicalEditPart)editPart;
        }
        return null;
    }
}

