/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class PerformanceMonitor {
    Map<String, Long> values = new HashMap<String, Long>();
    Map<String, Long> operations = new HashMap<String, Long>();
    Map<String, Long> startTime = new HashMap<String, Long>();
    public static boolean PERFOMANCE_MONITORING_IS_ACTIVE = true;
    private static PerformanceMonitor mon = new PerformanceMonitor();

    public static PerformanceMonitor getDefault() {
        return mon;
    }

    public void begin(String id) {
        this.startTime.put(id, System.currentTimeMillis());
        if (!this.values.containsKey(id)) {
            this.values.put(id, 0L);
        }
    }

    public void end(String id) {
        long cur = System.currentTimeMillis();
        if (this.startTime.containsKey(id)) {
            long start = this.startTime.get(id);
            long ctime = this.values.get(id);
            this.values.put(id, ctime + (cur - start));
            this.incrOperations(id);
        }
    }

    private void incrOperations(String id) {
        if (this.operations.containsKey(id)) {
            this.operations.put(id, this.operations.get(id) + 1L);
        } else {
            this.operations.put(id, 1L);
        }
    }

    public void print() {
        Set<String> okeys = this.values.keySet();
        ArrayList<String> keys = new ArrayList<String>();
        keys.addAll(okeys);
        Collections.sort(keys);
        for (String id : keys) {
            if (this.operations.containsKey(id) && this.operations.get(id) > 1L) {
                System.out.println("(" + id + ") \t:" + this.to_(this.values.get(id)) + " /" + this.to_(this.values.get(id) / this.operations.get(id)) + " ops:" + this.operations.get(id));
                continue;
            }
            System.out.println("(" + id + ") \t:" + this.to_(this.values.get(id)));
        }
    }

    private String to_(long time) {
        return new Formatter().format("%d", time).toString();
    }

    public void add(String id, long value) {
        if (this.values.containsKey(id)) {
            long old = this.values.get(id);
            this.values.put(id, old + value);
            this.incrOperations(id);
        } else {
            this.values.put(id, value);
            this.incrOperations(id);
        }
    }
}

