/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.validators.internal.ui;

import org.eclipse.dltk.validators.core.IValidator;
import org.eclipse.dltk.validators.internal.ui.ValidatorBlock;
import org.eclipse.dltk.validators.internal.ui.ValidatorMessages;
import org.eclipse.dltk.validators.internal.ui.ValidatorUpdater;
import org.eclipse.dltk.validators.internal.ui.ValidatorsUI;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ValidatorPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String VALIDATOR_PREFERENCE_PAGE = "org.eclipse.dltk.validators.ui.ValidatorPreferencePage";
    private ValidatorBlock fInterpretersBlock;

    public ValidatorPreferencePage() {
        this.setTitle(ValidatorMessages.ValidatorPreferencePage_1);
        this.setDescription(ValidatorMessages.ValidatorPreferencePage_2);
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite ancestor) {
        this.initializeDialogUnits((Control)ancestor);
        this.noDefaultAndApplyButton();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        ancestor.setLayout((Layout)layout);
        this.fInterpretersBlock = this.createValidatorsBlock();
        this.fInterpretersBlock.createControl(ancestor);
        Control control = this.fInterpretersBlock.getControl();
        GridData data = new GridData(1808);
        data.horizontalSpan = 1;
        control.setLayoutData((Object)data);
        this.fInterpretersBlock.restoreColumnSettings(this.getDialogSettings(), VALIDATOR_PREFERENCE_PAGE);
        this.applyDialogFont(ancestor);
        return ancestor;
    }

    private ValidatorBlock createValidatorsBlock() {
        return new ValidatorBlock();
    }

    public boolean performOk() {
        final boolean[] canceled = new boolean[1];
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            public void run() {
                ValidatorUpdater updater = new ValidatorUpdater();
                IValidator[] vnterpreters = ValidatorPreferencePage.this.fInterpretersBlock.getValidators();
                if (!updater.updateValidatorSettings(vnterpreters)) {
                    canceled[0] = true;
                }
            }
        });
        if (canceled[0]) {
            return false;
        }
        this.fInterpretersBlock.saveColumnSettings(this.getDialogSettings(), VALIDATOR_PREFERENCE_PAGE);
        return super.performOk();
    }

    private IDialogSettings getDialogSettings() {
        return ValidatorsUI.getDefault().getDialogSettings();
    }
}

