/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.ui.text.completion;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.internal.javascript.typeinference.IReference;
import org.eclipse.dltk.javascript.scriptdoc.ScriptDocumentationProvider;
import org.eclipse.dltk.javascript.typeinfo.model.Element;
import org.eclipse.dltk.ui.text.completion.ProposalInfo;

class JavaScriptProposalInfo
extends ProposalInfo {
    private final Object ref;

    JavaScriptProposalInfo(Object ref) {
        super(null);
        this.ref = ref;
    }

    public String getInfo(IProgressMonitor monitor) {
        if (this.ref instanceof IReference) {
            Reader contentReader;
            ArrayList ms = new ArrayList();
            ((IReference)this.ref).addModelElements(ms);
            if (ms.size() > 0 && (contentReader = new ScriptDocumentationProvider().getInfo((IMember)ms.get(0), true, true)) != null) {
                String string = this.getString(contentReader);
                return string;
            }
        } else if (this.ref instanceof IMember) {
            Reader contentReader = new ScriptDocumentationProvider().getInfo((IMember)this.ref, true, true);
            if (contentReader != null) {
                String string = this.getString(contentReader);
                return string;
            }
        } else {
            if (this.ref instanceof String) {
                return (String)this.ref;
            }
            if (this.ref instanceof Element) {
                return ((Element)this.ref).getDescription();
            }
        }
        return null;
    }

    private String getString(Reader reader) {
        StringBuffer buf = new StringBuffer();
        char[] buffer = new char[1024];
        try {
            int count;
            while ((count = reader.read(buffer)) != -1) {
                buf.append(buffer, 0, count);
            }
        }
        catch (IOException iOException) {
            return null;
        }
        return buf.toString();
    }
}

