/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.console.ui;

import java.util.StringTokenizer;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;

public class AnsiColorHelper {
    public static final Color COLOR_BLACK = new Color((Device)Display.getCurrent(), 0, 0, 0);
    public static final Color COLOR_BLUE = new Color((Device)Display.getCurrent(), 0, 0, 255);
    public static final Color COLOR_CYAN = new Color((Device)Display.getCurrent(), 0, 255, 255);
    public static final Color COLOR_GREEN = new Color((Device)Display.getCurrent(), 0, 255, 0);
    public static final Color COLOR_MAGENTA = new Color((Device)Display.getCurrent(), 255, 0, 255);
    public static final Color COLOR_RED = new Color((Device)Display.getCurrent(), 255, 0, 0);
    public static final Color COLOR_WHITE = new Color((Device)Display.getCurrent(), 255, 255, 255);
    public static final Color COLOR_YELLOW = new Color((Device)Display.getCurrent(), 255, 255, 0);
    private static final StyleRange DEFAULT_ERROR = new StyleRange(-1, -1, COLOR_RED, null, 1);
    private static final StyleRange DEFAULT_OUTPUT = new StyleRange(-1, -1, COLOR_BLUE, null);
    private StyleRange defaultOutput;
    private StyleRange defaultError;
    private boolean enabled = true;
    private boolean bright;
    private boolean dim;
    private boolean underscore;
    private boolean blink;
    private boolean reverse;
    private boolean hidden;
    private Color foreground;
    private Color background;

    public AnsiColorHelper(StyleRange defaultOutput, StyleRange defaultError) {
        this.defaultOutput = defaultOutput != null ? defaultOutput : DEFAULT_OUTPUT;
        this.defaultError = defaultError != null ? defaultError : DEFAULT_ERROR;
    }

    public AnsiColorHelper() {
        this(DEFAULT_OUTPUT, DEFAULT_ERROR);
    }

    public void reset() {
        this.bright = false;
        this.dim = false;
        this.underscore = false;
        this.blink = false;
        this.reverse = false;
        this.hidden = false;
        this.foreground = null;
        this.background = null;
    }

    public StyleRange resolveStyleRange(int start, int length, boolean isError) {
        Color curForeground = this.foreground;
        Color curBackground = this.background;
        int curFontStyle = 0;
        if (this.bright) {
            curFontStyle |= 1;
        }
        if (this.dim) {
            curFontStyle |= 2;
        }
        if (curForeground == null) {
            StyleRange curDefault = isError ? this.defaultError : this.defaultOutput;
            curForeground = curDefault.foreground;
            curBackground = curDefault.background;
            if (curFontStyle == 0) {
                curFontStyle = curDefault.fontStyle;
            }
        }
        if (this.hidden) {
            curForeground = curBackground;
        } else if (this.reverse) {
            Color oldForeground = curForeground;
            curForeground = curBackground;
            curBackground = oldForeground;
        }
        StyleRange styleRange = new StyleRange(start, length, curForeground, curBackground, curFontStyle);
        styleRange.underline = this.underscore;
        styleRange.strikeout = this.blink;
        return styleRange;
    }

    private void decodeAnsi(String ansiCode) {
        StringTokenizer tokenizer = new StringTokenizer(ansiCode, ";");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if ("0".equals(token)) {
                this.reset();
                continue;
            }
            if ("1".equals(token)) {
                this.bright = true;
                continue;
            }
            if ("2".equals(token)) {
                this.dim = true;
                continue;
            }
            if ("4".equals(token)) {
                this.underscore = true;
                continue;
            }
            if ("5".equals(token)) {
                this.blink = true;
                continue;
            }
            if ("7".equals(token)) {
                this.reverse = true;
                continue;
            }
            if ("8".equals(token)) {
                this.hidden = true;
                continue;
            }
            if ("30".equals(token)) {
                this.foreground = COLOR_BLACK;
                continue;
            }
            if ("31".equals(token)) {
                this.foreground = COLOR_RED;
                continue;
            }
            if ("32".equals(token)) {
                this.foreground = COLOR_GREEN;
                continue;
            }
            if ("33".equals(token)) {
                this.foreground = COLOR_YELLOW;
                continue;
            }
            if ("34".equals(token)) {
                this.foreground = COLOR_BLUE;
                continue;
            }
            if ("35".equals(token)) {
                this.foreground = COLOR_MAGENTA;
                continue;
            }
            if ("36".equals(token)) {
                this.foreground = COLOR_CYAN;
                continue;
            }
            if ("37".equals(token)) {
                this.foreground = COLOR_WHITE;
                continue;
            }
            if ("40".equals(token)) {
                this.background = COLOR_BLACK;
                continue;
            }
            if ("41".equals(token)) {
                this.background = COLOR_RED;
                continue;
            }
            if ("42".equals(token)) {
                this.background = COLOR_GREEN;
                continue;
            }
            if ("43".equals(token)) {
                this.background = COLOR_YELLOW;
                continue;
            }
            if ("44".equals(token)) {
                this.background = COLOR_BLUE;
                continue;
            }
            if ("45".equals(token)) {
                this.background = COLOR_MAGENTA;
                continue;
            }
            if ("46".equals(token)) {
                this.background = COLOR_CYAN;
                continue;
            }
            if (!"47".equals(token)) continue;
            this.background = COLOR_WHITE;
        }
    }

    public void processText(int originalOffset, String content, boolean isInput, boolean isError, IAnsiColorHandler handler) throws BadLocationException {
        int start = 0;
        int adjust = 0;
        if (this.enabled) {
            int cnt = 0;
            int max = content.length();
            while (cnt < max) {
                if (content.charAt(cnt) == '[') {
                    int ansiCnt;
                    boolean isAnsi = false;
                    for (ansiCnt = cnt + 1; ansiCnt < max; ++ansiCnt) {
                        char curChar = content.charAt(ansiCnt);
                        if (curChar == ';' || curChar >= '0' && curChar <= '9') {
                            continue;
                        }
                        if (curChar == 'm') {
                            isAnsi = true;
                            break;
                        }
                        isAnsi = false;
                        break;
                    }
                    if (isAnsi) {
                        String curContent = content.substring(start, cnt);
                        handler.handleText(originalOffset + start - adjust, curContent, isInput, isError);
                        String ansiCode = content.substring(cnt + 1, ansiCnt);
                        this.decodeAnsi(ansiCode);
                        adjust += ansiCnt - cnt + 1;
                        cnt = ansiCnt;
                        start = ansiCnt + 1;
                    }
                }
                ++cnt;
            }
        }
        if (start < content.length()) {
            String overflowContent = start == 0 ? content : content.substring(start);
            handler.handleText(originalOffset + start - adjust, overflowContent, isInput, isError);
        }
        handler.processingComplete(originalOffset, content.length() - adjust);
    }

    public void disableWhile(Runnable runnable) {
        boolean oldEnabled = this.enabled;
        this.enabled = false;
        try {
            runnable.run();
        }
        finally {
            this.enabled = oldEnabled;
        }
    }

    public static interface IAnsiColorHandler {
        public void handleText(int var1, String var2, boolean var3, boolean var4) throws BadLocationException;

        public void processingComplete(int var1, int var2);
    }
}

