/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.parser;

import org.antlr.runtime.Token;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.builder.ISourceLineTracker;
import org.eclipse.dltk.internal.core.SourceRange;

class LineTracker {
    private final ISourceLineTracker lineTracker;

    public LineTracker(ISourceLineTracker lineTracker) {
        this.lineTracker = lineTracker;
    }

    public int getOffset(int line, int column) {
        return line > 0 ? this.lineTracker.getLineOffset(line - 1) + Math.max(column, 0) : 0;
    }

    public int getLineNumberOfOffset(int offset) {
        return this.lineTracker.getLineNumberOfOffset(offset);
    }

    public int getLength() {
        return this.lineTracker.getLength();
    }

    public int getOffset(Token token) {
        return this.getOffset(token.getLine(), token.getCharPositionInLine());
    }

    public int length(Token token) {
        String sm = token.getText();
        return sm != null ? sm.length() : 1;
    }

    public ISourceRange toSourceRange(Token token) {
        return new SourceRange(this.getOffset(token), this.length(token));
    }
}

