/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.typeinference;

import com.xored.org.mozilla.javascript.JavaMembers;
import com.xored.org.mozilla.javascript.MemberBox;
import com.xored.org.mozilla.javascript.NativeJavaMethod;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.dltk.internal.javascript.typeinference.ReferenceFactory;
import org.eclipse.dltk.internal.javascript.typeinference.StandardSelfCompletingReference;

public class NativeObjectReference
extends StandardSelfCompletingReference {
    public static final Map<String, String> TYPES = new HashMap<String, String>();
    private final Class clz;

    static {
        TYPES.put("double", "number");
        TYPES.put("float", "number");
        TYPES.put("int", "number");
        TYPES.put("long", "number");
    }

    private static String convertType(String name) {
        String result = TYPES.get(name);
        if (result != null) {
            return result;
        }
        int i = name.lastIndexOf(".");
        if (i >= 0) {
            return name.substring(i + 1);
        }
        return name;
    }

    public NativeObjectReference(String paramOrVarName, Class clz) {
        super(paramOrVarName, false);
        this.clz = clz;
    }

    protected void createChilds() {
        block18: {
            try {
                JavaMembers javaMembers = new JavaMembers(null, this.clz);
                Hashtable fieldAndMethods = javaMembers.getFieldAndMethods(false);
                Hashtable members = javaMembers.getMembers(false);
                if (members == null) break block18;
                Iterator iterator = members.entrySet().iterator();
                while (iterator.hasNext()) {
                    StandardSelfCompletingReference uref = null;
                    Map.Entry entry = iterator.next();
                    String key = (String)entry.getKey();
                    if (entry.getValue() instanceof NativeJavaMethod) {
                        MemberBox[] methods = ((NativeJavaMethod)entry.getValue()).getMethods();
                        int i = 0;
                        while (i < methods.length) {
                            Class[] argTypes;
                            if (methods[i].getReturnType() != null) {
                                Class clss = methods[i].getReturnType();
                                if (clss == String.class) {
                                    uref = ReferenceFactory.createStringReference(key);
                                } else if (clss == Boolean.class || clss == Boolean.TYPE) {
                                    uref = ReferenceFactory.createBooleanReference(key);
                                } else if (Date.class.isAssignableFrom(clss)) {
                                    uref = ReferenceFactory.createDateReference(key);
                                } else if (Number.class.isAssignableFrom(clss) || clss.isPrimitive()) {
                                    uref = ReferenceFactory.createNumberReference(key);
                                } else if (clss.isArray()) {
                                    uref = ReferenceFactory.createArrayReference(key);
                                }
                            }
                            if (uref == null) {
                                uref = new StandardSelfCompletingReference(key, false);
                            }
                            if ((argTypes = methods[i].getArgTypes()) != null) {
                                String[] names = new String[argTypes.length];
                                int j = 0;
                                while (j < argTypes.length) {
                                    names[j] = argTypes[j].isArray() ? String.valueOf(NativeObjectReference.convertType(argTypes[j].getComponentType().getName())) + "[]" : NativeObjectReference.convertType(argTypes[j].getName());
                                    ++j;
                                }
                                uref.setParameterNames(names);
                            }
                            uref.setFunctionRef();
                            this.setChild(key, uref);
                            ++i;
                        }
                        continue;
                    }
                    this.setChild(key, new StandardSelfCompletingReference(key, false));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

